;;; -*- Mode: LISP; Package: atn; Syntax: Common-lisp; -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   atn-classes.cl
;;; Short Desc: Classes for ATN lex and graphs
;;; Version:    0.1
;;; Status:     Provisional
;;; Last Mod:   1.4.92 DTA&EV
;;; Author:     Dean Allemang and Erik Vinkhuyzen
;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================




(in-package :atn)

(defclass atn ()
      ((atn-desc    
        :accessor atn-desc
        :initarg :atn-desc
        :initform nil
        :type list)))

(defclass lexicon ()
      ((lex-desc    
        :accessor lex-desc
        :initarg :lex-desc
        :initform nil
        :type list)))


(defmethod change-type ((a lexicon) (b lexicon)) a)

(defmethod change-type ((a atn) (b atn)) a)

(defmethod dump-editable ((w lexicon))
     (let ((output "("))
         (loop for entry in (lex-desc w) do (setf output (format nil "~a~a~%" output entry)))
         (format nil "~a)~%" output)))

(defmethod read-instance ((item lexicon) desc name)
     (declare (ignore name))
     (progn
         (setf (lex-desc item) desc)
         item))


(defmethod dump-editable ((net atn))
     (let ((output "("))
         (loop for construct  in (atn-desc net) do
             (progn (setf output (format nil "~a(~a~%" output (car construct)))
                 (loop for transition in (cdr construct) do
                     (setf output (format nil "~a~a~%" output transition)))
                 (setf output (format nil "~a)~%" output)))
             )
         (format nil "~a)~%" output)))

(defvar *open-atn-windows* nil)

(defclass atn-dialog (dialog)
      ())

(defclass atn-bitmap-pane (bitmap-pane) nil)

(defmethod default-pane-class ((ad atn-dialog))
     'atn-bitmap-pane)

(defmethod event :after ((ad atn-dialog)
                                       (event (eql mouse-left-down))
                                       buttons data time)
     (print "Clicking on a atn-dialog"))

(defmethod initialize-instance :after ((ad atn-dialog) &rest whatever)
     (push ad *open-atn-windows*))

(defmethod window-close ((ad atn-dialog))
     (close ad))

(defclass atn-main-dialog (atn-dialog)
      ())

(defmethod bring-window-to-front :after ((ad atn-main-dialog))
        (in-package :atn)
        (set-atn-menubar)
     (setf (stream-title *lisp-main-window*) "PAIL - Augmented Transition Networks module"))

(defmethod view-click-event-handler ((atn-dialog atn-dialog) whatever)
     (call-next-method)
     (in-package :atn)
     (set-atn-menubar)
     (set-help-atn))

(defclass atn-fred-window (text-edit-window)
      ())

(defmethod initialize-instance :after ((afw atn-fred-window) &rest whatever)
     (push afw *open-atn-windows*))

(defmethod window-close ((afw atn-fred-window))
;     (delete afw *open-atn-windows*)
     (close afw))



(defmethod redisplay-window :after ((d atn-main-dialog) &optional box)
      (in-package :atn))


(defmethod window-close ((imd atn-main-dialog))
      (when (yes-or-no-p "Do you really want to
quit the ATN module")
          (remove-from-window-menu (object-name *atn-main-window*))
          (close imd)
          (setf imd nil)
          (quit-atn)))


(defmethod read-instance ((item atn) desc name)
     (declare (ignore name))
     (progn
         (setf (atn-desc item) desc)
         item))



(defclass atn-lex-window (sequence-window)
       ())

(defclass atn-net-window (text-edit-window)
      ())

(defmethod window-close ((clw atn-net-window))
     (catch 'cancel
;;;          (when (modified-p clw)
;;;               (let ((save (ask-save-changes clw)))
;;;                   (when (eql save :cancel) (throw 'cancel nil))
;;;                   (when (eql save :yes)
                   (unless (save-file clw) (throw 'cancel nil))
            (close clw)))

(defmethod save-file ((clw atn-net-window))
     (te::save-file clw)
     (setf (stream-title clw)
                       (concatenate 'string 
                             "Network "  
                             (file-namestring (te::file clw)))))


(defmethod window-close ((clw atn-net-window))
      (:save-as clw)
     (close clw))

(defmethod window-close ((clw atn-lex-window))
      (catch 'cancel
            (when (save-p (wsequence clw))
                   (let ((save (ask-save-changes *lex-dialog*)))
                       (when (eql save :cancel) (throw 'cancel nil))
                       (when (eql save :yes)
                              (unless (save-lexicon) (throw 'cancel nil)))))
            (close clw)))



(defparameter *atn-demo-running* nil)
(defparameter *show-graphics* t)
(defparameter *show-status* nil)
(defparameter *show-diagnostics* nil)
(defparameter *show-status* nil)
(defparameter *show-warnings* nil)
(defvar *num-parses* 0)
(defvar *start-subnet* nil)
(defvar *input-done* nil)

(defparameter *current-lex-file* nil)
(defparameter *lex-dialog* nil)

(defvar *subnet* nil)
(defvar *input* nil)
(defvar *input-length* nil)
(defvar *lextree* '(nil))
(defvar *nextpos* nil)
(defvar *minchar* 65)

(defvar * nil)
(defvar *lex* nil)
(defvar *registers* nil)
(defvar *stack* nil)

(defvar regs 'regs)
(defvar init 'init)

(defvar *net* nil)
(defvar *network* nil)  
(defvar *lexicon* nil)                
(defvar *single-step* nil)  

(defvar *current-net-file* nil)
(defvar *current-lex-file* nil)

(defconstant *word* 'word)
(defconstant *jump* 'jump)
(defconstant *tst* 'tst)
(defconstant *vir* 'vir)
(defconstant *cat* 'cat)
(defconstant *push* 'push)
(defconstant *pop* 'pop)
(defvar *last-sentence* "")
(defvar *sentence-list* nil)
(defparameter *atn-main-window* nil)
(defparameter *out-dialog* nil)
(defvar *stepper-text* "Enable Stepper")

(defvar *got-step-command* nil)
(defvar *lexs-menu* nil)
(defvar *nets-menu* nil)
(defvar *atn-tool-window* nil)  
(defvar *step-exit-button* nil)  
(defvar *atn-output-window* nil)
(defvar *sentence-window* nil)
(defvar *atn-buttons-list* nil)   
(defvar *radio-buttons-list* nil)
(defvar *lexicon-button* nil)
(defvar *networks-button* nil)
(defvar *regs-button* nil)      
(defvar *hold-button* nil)
(defvar *stack-button* nil)    
(defvar *lookup-button* nil)
(defvar *new-sentence-button* nil) 
(defvar *parse-sentence-button* nil)
(defvar *help-tool-button* nil)   
(defvar *exit-tool-button* nil)
(defvar *graph-button* nil)      
(defvar *step-button* nil)
(defvar *diag-button* nil)      
(defvar *trace-button* nil)
(defvar *step-step-button* nil) 
(defvar *step-go-button* nil)

(defvar *net-name* "")          
(defvar *lex-name* "")

(defvar *usedwindows* nil)
(defvar *hilitenode* nil)
(defvar *hilitenet* nil)
(defvar *arrowtheta* (/ pi 6))
(defvar *arrowx* 7)
(defvar *arrowy* 7)
(defvar *nodefont* (make-font :modern nil 10 '(:condensed)))
(defvar *labelfont* (make-font :modern nil 10 '(:bold)))
(defvar *nodesize* 16)
(defvar *lastnet* nil)
(defvar *arc-start* (+ *nodesize* (truncate *nodesize* 4)))
(defvar *arc-offset* (* 1.3 *nodesize*))
(defvar *window-border* 6)
(defvar *window-offset* 18)


(defparameter *word-font* (make-font :modern nil 16 '(:bold)))
(defparameter *push-font* (make-font :modern nil 16 '(:bold)))
(defparameter *cat-font*  (make-font :modern nil 16 '(:bold)))
(defparameter *jump-font* (make-font :decorative :symbol 16 '(:bold)))


;;; ==========================================================================
;;; * END OF FILE *
;;; ==========================================================================


