;;; -*- Mode: LISP; Package: atn; Syntax: Common-lisp; -*-
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   atn-init.lisp
;;; Short Desc: general user interface for the  ATN tool
;;;            
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   4. april 1992 - PC
;;; Author(s):  Paolo Cattaneo
;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;; 
;;; 
;;; --------------------------------------------------------------------------

(in-package :atn)

(defun atn ()
     (setq pail-lib::*atn-module-loaded* t)
     (in-package :atn)
     (create-atn-window)
     (set-atn-menubar)
     ;  (set-help-atn)
     )



(defun set-help-atn ()
  (set-help :general "atn\\help\\atn-desc.hlp"))
            


(defun create-atn-window ()
      (let* ((*number-of-buttons* 4)           
              (box (clipping-box *lisp-main-window*))
              (h-indent (round (* 0.2 (box-width box))))
              (v-indent (round (* 0.2 (- (box-height box) 20))))
              (h-size (- (box-width box) (* 2 h-indent)))
              (button-width (round (/ h-size *number-of-buttons*)))
                (button-height 25)
                (out-dialog nil)
              (height (box-height (clipping-box *lisp-main-window*)))
              (width (box-width (clipping-box *lisp-main-window*))))
          (unless *atn-main-window*
              (setq *atn-main-window*
                   (open-dialog ()
                        'atn-main-dialog *lisp-main-window* :pop-up-p nil
                        :title "ATN Main" :name ':atn-main
                        :pane-class 'atn-bitmap-pane
                        :background-color (make-rgb :red 0 :green 128 :blue 128) 
                        :window-exterior (clipping-box *lisp-main-window*))))
         (add-to-window-menu
               (stream-title *atn-main-window*)
               (object-name *atn-main-window*))
      (setq out-dialog (setq *out-dialog*
            (open-dialog
                  (list
                           (make-dialog-item :widget 'button
                                 :title "Help"
                                  :available-p nil
                                 :font (make-font :modern nil 16 '(:bold))
                                 :set-value-fn '(lambda (item new old) (stepper-help))
                                 :box (make-box
                                       0
                                       0
                                       button-width
                                       button-height))
                           (make-dialog-item :widget 'button
                                 :title "Enable"
                                 :name ':enable
                                 :font (make-font :modern nil 16 '(:bold))
                                 :set-value-fn '(lambda (item new old) (set-stepper))
                                 :box (make-box
                                       (round (/ (- (box-width (window-interior *atn-main-window*)) (* 2 h-indent)) 4))
                                       0
                                       (* 2 (round (/ (- (box-width (window-interior *atn-main-window*)) (* 2 h-indent)) 4)))
                                       button-height))
                           (make-dialog-item :widget 'button
                                 :title "Skip"
                                 :name ':skip
                                 :available-p nil
                                 :font (make-font :modern nil 16 '(:bold))
                                 :set-value-fn '(lambda (item new old) (atn-stepper-continue))
                                 :box (make-box
                                       (* 2 (round (/ (- (box-width (window-interior *atn-main-window*)) (* 2 h-indent)) 4)))
                                       0
                                       (* 3 (round (/ (- (box-width (window-interior *atn-main-window*)) (* 2 h-indent)) 4)))
                                       button-height))
                           (make-dialog-item :widget 'button
                                 :title "Step"
                                 :name ':step
                                 :available-p nil
                                 :font (make-font :modern nil 16 '(:bold))
                                 :set-value-fn '(lambda (item new old) (atn-stepper-step))
                                 :box (make-box
                                       (* 3 (round (/ (- (box-width (window-interior *atn-main-window*)) (* 2 h-indent)) 4)))
                                       0
                                       (- (box-width (window-interior *atn-main-window*)) (* 2 h-indent))
                                       button-height)))
                  'dialog *atn-main-window*
                  :pop-up-p nil
                  :title "ATN: Output"
                  :user-closable nil
                  :user-shrinkable t
                  :user-resizable nil
                  :user-scrollable nil
                  :user-movable t
                  :window-border :dialog-box
                  :window-interior
                  (make-box 
                         h-indent 
                         v-indent
                         (- (box-width (window-interior *atn-main-window*)) h-indent)
                         (- (box-height (window-interior *atn-main-window*)) v-indent)))))
         (setq *atn-output-window*
               (open-stream 'atn-fred-window out-dialog :output
                     :title "Augmented Transition Networks"
                     :user-closable nil :user-resizable nil
                     :user-scrollable t :user-movable nil :user-shrinkable nil 
                     :font (make-font :modern nil 14)
                     :name ':atn-output
                     :window-exterior
                     (make-box
                             0 25
                             (box-width (visible-box out-dialog))
                             (box-height (visible-box out-dialog)))))))



(defun atn-stepper-continue ()
     (setq *got-step-command* :go))



(defun atn-stepper-step ()
     (setq *got-step-command* :next-step))



(defun stepper-buttons ()
     (list 
        (find-named-object ':enable *out-dialog*)
        (find-named-object ':skip *out-dialog*)
        (find-named-object ':step *out-dialog*)))



(defun set-stepper ()
     (if *single-step*
        (progn
            (set-menu-item-title
                 (find-named-object ':enable *lisp-menu-bar*) 
                 "Enable Stepper")
            (atn-stepper-disable)
            (setq *got-step-command* :quit)
            (setq *single-step* nil))
        (progn
            (set-menu-item-title
                 (find-named-object ':enable *lisp-menu-bar*)
                 "Disable Stepper")
            (setq *got-step-command* nil)
            (atn-stepper-enable)
            (setq *single-step* t))))



(defun atn-stepper-enable ()
     (let ((sb (stepper-buttons)))
         (set-dialog-item-title (car sb) "Disable")
         (dolist (button (cdr sb))
              (set-dialog-item-available-p button t))))



(defun atn-stepper-disable ()
     (let ((sb (stepper-buttons)))
         (set-dialog-item-title (car sb) "Enable")
         (dolist (button (cdr sb))
              (set-dialog-item-available-p button nil))
         (setq *got-step-command* nil)))



(defvar *atn-file-menu* nil)

(defun atn-new ()
     (:new *atn-main-window*))

(defun atn-open ()
      (pail-open *atn-main-window*))                  
             
(defun atn-save ()
      (te::save-file (front-window *atn-main-window*)))                  
             
(defun atn-save-as ()
      (pail-save-as (front-window *atn-main-window*)))         

(defun atn-close ()
     (let ((window (front-window *atn-main-window*)))
         (if window (window-close window)
            (window-close *atn-main-window*))))

(defun atn-print ()
     (:print (front-window *atn-main-window*)))


(setq *atn-file-menu*
     (make-menu-item :title "~File" :value
           (open-menu 
                (list 
                   (make-menu-item :title "~New"
                         :value 'atn-new :available-p t
                         :selected-p nil :font nil :event-synonym 
                         '(control-key #\N))
                   (make-menu-item :title "~Open"
                         :value 'atn-open :available-p t 
                         :selected-p nil :font nil :event-synonym 
                         '(control-key #\O))
                   (make-menu-item :title "~Close"
                        :value 'atn-close ;;OKKKIO extremly dangerous
                         :selected-p nil :font nil)
                   menu-separator
                   (make-menu-item :title "Load Network..."
                         :value 'load-network :available-p t 
                         :selected-p nil :font nil)
                   (make-menu-item :title "Load Lexicon..."
                         :value 'load-lexicon :available-p t 
                         :selected-p nil :font nil)
                   menu-separator
                   (make-menu-item :title "~Save"
                         :value 'atn-save 
                         :selected-p nil :font nil :event-synonym 
                         '(control-key #\S))
                  (make-menu-item :title "Save ~As"
                        :value 'atn-save 
                        :selected-p nil :font nil)
                   menu-separator
                   (make-menu-item :title "~Print"
                         :value 'atn-print
                         :selected-p nil :font nil :event-synonym 
                         '(control-key #\P))
                   menu-separator
                   (make-menu-item :name :help :title "~Help"
                         :value 'atn-file-help
                         :selected-p nil :font nil :event-synonym 
                         '(control-key #\H))
                   (make-menu-item :title "E~xit from ATN"
                         :value 'atn-exit :available-p t
                         :selected-p nil :font nil :event-synonym 
                         '(control-key #\X)))
                'pop-up-menu *lisp-main-window* :name '*atn-file-menu* :title '"" 
                :selection-function 'funcall-menu-item)))
     
     
(defun atn-exit ()
     (window-close *atn-main-window*))

(defun quit-atn ()
     (setq *lexicon* nil)
     (setq *network* nil)
     (setq *current-net-file* nil)
     (setq *current-lex-file* nil)
     (setq pail-lib::*atn-module-loaded* nil)
     (make-available :atn)
     (select-window pail-lib::*pail-main-window*)
     (in-package :pail-lib))
  


(defvar *atn-lexicon-menu* nil)

(setq *atn-lexicon-menu*
     (make-menu-item :title "~Lexicon" :value
           (open-menu 
                 (list 
                    (make-menu-item :title "New Lexicon"
                           :name ':new-lexicon
                           :available-p t
                           :value 'new-lexicon)
                    (make-menu-item :title "Load Lexicon ..."
                           :name ':load-lexicon
                           :available-p t
                           :value 'load-lexicon)
                    (make-menu-item :title "Save Lexicon"
                           :name ':save-lexicon
                           :available-p nil
                           :value 'save-atn-lexicon)
                    menu-separator
                    (make-menu-item :title "New Lexical Entry"
                           :name ':new-word
                           :available-p nil
                           :value 'new-word)
                    (make-menu-item :title "Delete Word"
                           :name ':delete-word
                           :available-p nil
                           :value 'delete-word)
                    (make-menu-item :title "Find Word"
                           :name ':find-word
                           :available-p nil
                           :value 'find-word)
                    menu-separator
                    (make-menu-item :title "Help"
                           :available-p nil
                           :value 'lexicon-help))
                 'pop-up-menu *lisp-main-window* :name '*atn-lexicon-menu* :title '"" 
                 :selection-function 'funcall-menu-item)))


(defvar *atn-network-menu* nil)

(setq *atn-network-menu*
     (make-menu-item :title "~Network" :value
           (open-menu 
                 (list 
                    (make-menu-item :title "Edit New Network"
                           :name ':edit-network
                           :available-p t
                           :value 'edit-new-network)
                    (make-menu-item :title "Load Network..."
                         :value 'load-network :available-p t 
                           :name ':load-network
                         :selected-p nil :font nil)
                    (make-menu-item :title "Edit Current Network"
                           :name ':edit-current-network
                           :available-p nil
                           :value 'edit-current-network)
                    menu-separator
                    (make-menu-item :title "Reset Nodes Position"
                           :name ':reset-nodes-positions
                           :available-p nil
                           :value 'reset-nodes-positions)
                    menu-separator
                    (make-menu-item :title "Help"
                           :available-p nil
                           :value 'lexicon-help))
                 'pop-up-menu *lisp-main-window* :name '*atn-network-menu* :title '"" 
                 :selection-function 'funcall-menu-item)))



(defun edit-current-network ()
     (te::load-file (setq *current-edit-network*
                              (open-stream 'atn-net-window
                                   *atn-main-window* :io
                                   :user-closable nil
                                   :title (concatenate 'string
                                               "Network : "
                                               (file-namestring *current-net-file*))))
      *current-net-file*))


(defun new-net-file ()
     (let ((file nil))
     (dotimes (i 100)
          (setq file (concatenate 'string
                                              *pail-directory*
                                              "atn\\networks\\untit"
                                           (write-to-string i)
                                           ".net"))
          (unless (probe-file file)
               (return)))
         file))
     

(defun edit-new-network ()
     (setq *new-net-file* (new-net-file))
     (setq *net-dialog*
          (open-stream 'atn-net-window
        *atn-main-window*
        :io
        :title (concatenate 'string "Network : " (file-namestring *new-net-file*)))))

;;; 
;;; (defun edit-new-network ()
;;;      (setf text-window
;;;              (open-stream
;;;           'text-edit-window
;;;           *atn-main-window*
;;;           :title (concatenate 'string "New Network"))))

;;; AB 06.06.1994
;;; (defun reset-nodes-position ()
;;;       (setf *moved-node* nil)
;;;       (dolist (nwin *usedwindows*)
;;;             (window-hide (net-window nwin))
;;;             (dolist (node (node-list nwin))
;;;                   (setf (moved node) 0))
;;;             (setf (has-moved-nodes (net-window nwin)) nil)
;;;             (window-show (net-window nwin))))



(defvar *atn-parser-menu* nil)

(setq *atn-parser-menu*
     (make-menu-item :title "~Parser" :value
           (open-menu 
                (list 
                   (make-menu-item :title "Set Starting Subnet"
                          :name ':set-starting-subnet
                         :available-p nil
                         :value 'set-starting-subnet)
                   (make-menu-item :title "Parse Sentence"
                          :name ':parse-sentence
                         :available-p nil
                         :value 'parse-sentence)
                   (make-menu-item :title "Parse Predefined Text"
                          :name ':parse-predefined-text
                         :available-p nil
                         :value 'parse-predefined-text)
                   (make-menu-item :title "Repeat Last Parse"
                          :name ':repeat-last-parse
                         :available-p nil
                         :value 'repeat-last-parse)
                   menu-separator
                   (make-menu-item :title "Print Registers"
                          :name ':print-registers
                         :available-p nil
                         :value 'print-every-register)
                   (make-menu-item :title "Print HOLD Register"
                          :name ':print-hold
                         :available-p nil
                         :value 'print-hold-register)
                   (make-menu-item :title "Print STACK"
                          :name ':print-stack
                         :available-p nil
                         :value 'print-stack)
                   menu-separator
                   (make-menu-item :title "Enable Stepper"
                         :value 'set-stepper
                          :name ':enable)
                   (make-menu-item :title "Parser Settings..."
                         :name ':parser-settings
                         :available-p nil
                         :value 'parser-settings)
                   menu-separator
                   (make-menu-item :title "Help"
                         :available-p nil
                         :value 'parser-help))
                'pop-up-menu *lisp-main-window* :name '*atn-parser-menu* :title '"" 
                :selection-function 'funcall-menu-item)))
                   

                        

(defun set-starting-subnet ()
      (when *network*
             ;;; AB 22.05.1994
             ;;; Use always a conversion to downcase letters
             (let ((name (select-item-from-list
                                        *atn-main-window* 
                                        (list-subnets)
                                        "Select subnetwork to start parsing with:")))
                 (when name
                        (when *show-graphics*
                               (dolist (w *usedwindows*)
                                     (when (string=
                                                       (write-to-string name)
                                                       (stream-title (net-window w)))
                                            (select-window (net-window w)))))
                        (format-display *atn-output-window*
                             "~%Initial subnet is ~A.~%" name)
                        (setq *start-subnet* name)
                        (get-network name)))))



(defun print-hold-register ()
  (print-registers *registers* nil 1))



(defun print-every-register ()
  (print-registers *registers* t 1))


       
(defvar *atn-parser-settings* nil)

(defun parser-settings ()
     (let ((width (box-width (clipping-box *lisp-main-window*))))
         (setq *atn-parser-settings*
              (open-dialog
                   (list
                      (make-dialog-item :widget 'static-text
                            :box (make-box 30 10 170 30)
                            :value "Parser settings"
                            :font (make-font :modern nil 16 '(:bold)))
                      (make-dialog-item :widget 'check-box
                            :box (make-box 30 40 150 60)
                            :value *show-diagnostics*
                            :title "Debug"
                            :set-value-fn '(lambda (item new old) (progn (update-debug) t))
                            :font (make-font :modern nil 16 '(:bold)))
                      (make-dialog-item :widget 'check-box
                            :box (make-box 30 70 150 90)
                            :value *show-status*
                            :title "Trace"
                            :set-value-fn '(lambda (item new old) (progn (update-trace) t))
                            :font (make-font :modern nil 16 '(:bold)))
                      (make-dialog-item :widget 'check-box
                            :box (make-box 30 100 150 120)
                            :value *show-graphics*
                            :available-p t
                            :title "Graphics"
                            :set-value-fn '(lambda (item new old) (progn (update-graphics) t))
                            :font (make-font :modern nil 16 '(:bold)))
                      (make-dialog-item :widget 'default-button
                            :box (make-box 110 130 160 155)
                            :title "OK"
                            :set-value-fn #'(lambda (item new old) (values t t))
                            :font (make-font :modern nil 16 '(:bold))))
                   'atn-dialog *atn-main-window*
                   :window-border :dialog-box
                   :title "parser settings" :pop-up-p t
                   :window-interior (make-box (round (- (/ width 2) 90)) 200
                                                                         (round (+ (/ width 2) 90)) 365)
                   :user-closable nil :user-resizable nil :user-shrinkable nil))
         (pop-up-dialog *atn-parser-settings*)
         t))



(defun update-graphics (&rest nulla)
     (declare (ignore nulla))
     (if *show-graphics*
        (progn
             (setq *show-graphics* nil)
            (close-net))
        (progn
             (setq *usedwindows* nil)
             (setq *show-graphics* t)
            (net-graphics))))



(defun update-trace (&rest nulla)
     (declare (ignore nulla))
     (setq *show-status* (not *show-status*)))

(defun update-debug (&rest nulla)
     (declare (ignore nulla))
     (setq *show-diagnostics* (not *show-diagnostics*)))           




(defvar *atn-demo-menu* nil)

(setq *atn-demo-menu*
     (make-menu-item :title "~Demos" :value
           (open-menu 
                (list 
                   (make-menu-item :title "Demo 1"
                         :available-p t
                         :value 'demo-1)
                   (make-menu-item :title "Demo 2"
                         :available-p t
                         :value 'demo-2)
                   (make-menu-item :title "Demo 3"
                         :available-p t
                         :value 'demo-3))
                'pop-up-menu *lisp-main-window* :name '*atn-parser-menu* :title '"" 
                :selection-function 'funcall-menu-item)))

(defun demo-1 (&rest nulla)
  (declare (ignore nulla))
  (start-demo-1))


(defun demo-2 (&rest nulla)
  (declare (ignore nulla))
  (start-demo-2))

(defun demo-3 (&rest nulla)
  (declare (ignore nulla))
  (start-demo-3))


                                                   
(defvar *atn-menubar* nil)

(defun set-atn-menubar ()
     (clean-up-menubar)
         (add-to-menu *lisp-menu-bar*
          (make-menu-item
                :title '~Tools
                :value *pail-tool-menu*))
     (add-to-menu *lisp-menu-bar*
          *atn-file-menu*)
     (add-to-menu *lisp-menu-bar*
          (make-menu-item
                :title '~Edit
                :value *pail-edit-menu*))
     (add-to-menu *lisp-menu-bar*
          *atn-lexicon-menu*)
     (add-to-menu *lisp-menu-bar*
          *atn-network-menu*)
     (add-to-menu *lisp-menu-bar*
          *atn-parser-menu*)
     (add-to-menu *lisp-menu-bar*
          *atn-demo-menu*)
     (add-to-menu *lisp-menu-bar*
          *pail-window-menu*)  
     )


