;;; -*- Mode: LISP; Package: atn; Syntax: Common-lisp; -*-
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   atn-demo1.cl
;;; Short Desc: First demo on Augmented Transition Networks
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   28.9.91 - FB
;;; Author:     Fabio Baj
;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------

;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================

(in-package :atn)

;;=====================================================================
;; The definition of demo1
;;=====================================================================

(defvar *demo-net-file* nil)
(defvar *demo-lex-file* nil)


(defvar *view* nil)

(defun start-demo-1 ()
      (when (create-demo-dialog   
                    :window-title "ATN Demos"
                    :title "Augmented Transition Networks"
                    :subtitle "A First Demo"
                    :helpfile "atn\\help\\atn-d1.hlp"
                    :window *atn-main-window*)
             (progn
                  (setq *demo-net-file*
                        (concatenate 'string *pail-directory* "atn\\networks\\net-1."))
                  (setq *demo-lex-file*
                        (concatenate 'string *pail-directory* "atn\\lexicon\\lex-1."))
                  (setq *current-net-file*
                        (concatenate 'string *pail-directory* "atn\\networks\\net-1."))
                  (setq *current-lex-file*
                        (concatenate 'string *pail-directory* "atn\\lexicon\\lex-1."))
                  (setq *atn-demo-running* t)
                  (catch 'stop-demo (main-demo-1))
                  (setq *atn-demo-running* nil))))

(defun main-demo-1 ( )
     (format-demo "Here is a first demo on augmented 
transition networks. Push <continue> to
load the ATN module")
     (demo-loop)
     (format-demo "

Now we select the current net
and the current lexicon. Push <continue>
")
     (demo-loop)
      (load *current-net-file*)
      (format-display *atn-output-window*
           "Network ~a loaded!~%~%"
           (file-namestring *current-net-file*))
      (setq *start-subnet* nil)
      (set-menu-after-load-network)
      (setq *net* *network*)
      (when *show-graphics*
             (update-graphics)
             (update-graphics))
      (setq *lexicon* (loadlex *demo-lex-file*))
      (create-lex-window *lexicon*)
      (format-display *atn-output-window*
           "~%Lexicon ~a loaded!~%~%"
           (file-namestring *demo-lex-file*))
      (set-menu-after-load-lexicon)
     (format-demo "
Here is a sample of how the
user can specify a transition net. Push <continue>
")
     (demo-loop)
     (view-current-network)
     (format-demo "
The <Graphics> button toggles
a graphic simulation of the transition
network. Now you can see the correspondence 
between the formal specification of the
network and its graphical representation.
Click on <Graphics> to activate the graphic
representation
")
     (demo-loop)
;     (window-close *view*)
     (parser-settings)
     (sleep 1)
     (demo-loop)
     (format-demo "
The user can write a sentence to
be parsed by the current network, for
instance :
Paolo sees that Luca eats a pizza
Push <continue>
")
     (demo-loop)
     (setq *last-sentence* "paolo sees that luca eats a pizza")
     (parse-sentence)
     (format-demo "
The <Step> button allows the user to
follow the  parsing process one step 
at time.
")
     (demo-loop)
     ;;(stepper-code)
     (format-demo "
Variuos levels of verbosity in
the output can be selected with the
<debug> and <trace> buttons
Please click them.
")
     (parser-settings)
     (demo-loop)
     (format-demo 
         "~%The <Repeat Last Part> button
starts the parsing algorithm. When the
graphical output is set on, a hopping
cursor displays the currently active 
node of the network. 
")
     (demo-loop)
     (format-demo "
In the case one parse has been 
found. The next sentence is not
correct for the current network:
Paolo  Luca eats a pizza
")
     (demo-loop)
     (setq *last-sentence* "Paolo  Luca eats a pizza")
     (parse-sentence)
     (format-demo " 
This sentence has not been
recognized. 
There are also some buttons
useful to inspect the state of the
conputation. ")
     (demo-loop)
     (format-demo "
The <Regs> button prints the values
of the registers defined in the current
scope.
")
     (demo-loop)
     (print-every-register)
     (format-demo "
The <Hold> button prints the value
of the HOLD  register
")
     (demo-loop)
     (print-hold-register)
     (format-demo "
The <Stack> button prints the 
current content of the stack.
Let's push, for example, the <Stack>
button
")
     (demo-loop)
     (print-stack)
      (demo-loop)
      (when *show-graphics* (update-graphics))
      (close-lex-window)
     (format-demo "
This is the end of the first demo
"))
;     (close-net))