;;; -*- Mode: LISP; Package: atn; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;  AUGMENTED TRANSITION NETWORKS
;;; ************************************************************************
;;;
;;; Filename:   atn-demo2.lisp
;;; Short Desc: Second demo on Augmented Transition Networks
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   28.9.91 - FB
;;; Author:     Fabio Baj
;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------

;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================

(in-package :atn)


;;=====================================================================
;; The definition of demo2
;;=====================================================================


(setq *view* nil)

(defun start-demo-2 ()
      (when (create-demo-dialog 
                        :window-title "ATN Demos"
                        :title "Augmented Transition Networks"
                        :subtitle "A Second Demo"
                        :helpfile "atn\\help\\atn-d2.hlp"
                        :window *atn-main-window*)
             (setq *demo-net-file*
                   (concatenate 'string
                         *pail-directory* "atn\\networks\\net-5."))
             (setq *demo-lex-file*
                   (concatenate 'string
                         *pail-directory* "atn\\lexicon\\lex-2."))
             (setq *current-net-file*
                   (concatenate 'string
                         *pail-directory* "atn\\networks\\net-5."))
             (setq *current-lex-file*
                   (concatenate 'string
                         *pail-directory* "atn\\lexicon\\lex-2."))
             (setq *atn-demo-running* t)
             (catch 'stop-demo (main-demo-2))
             (setq *atn-demo-running* nil)))



(defun main-demo-2 ( )
      (format-demo "Here is a second demo on augmented 
transition networks.

For this demo we select the network file net-5
and the lexicon file lex-2. Push <continue>
")
      (demo-loop)
      (load *current-net-file*)
      (format-display *atn-output-window*
           "Network ~a loaded!~%~%"
            (file-namestring *current-net-file*))
      (setq *start-subnet* nil)
      (set-menu-after-load-network)
      (setq *net* *network*)
      (when *show-graphics*
             (update-graphics)
             (update-graphics))
      (setq *lexicon* (loadlex *demo-lex-file*))
      (create-lex-window *lexicon*)
      (format-display *atn-output-window*
           "~%Lexicon ~a loaded!~%~%"
            (file-namestring *demo-lex-file*))
      (set-menu-after-load-lexicon)
      (format-demo "
This network is designed to handle
interrogatives, passive sentences and 
some auxiliary verbs. Its output is
a logical analisis of the given  sentence.
This network makes use of registers, so
it is a true augmented transition network
while net-1 was in fact a simple recursive 
transition network.

Here is the definition of net-5:
")
      (view-current-network)
      (demo-loop)
      (format-demo "
Notice that this lexicon is much
more complicated than the one in lex-1
")
      (demo-loop)
      (format-demo "
Now we turn the graphic layout on
Please click on <graphics> 
")
      (demo-loop)
      (parser-settings)
      (sleep 1)
      (demo-loop)
      (format-demo "
We also set the <trace> mode 
")
      (demo-loop)
      (parser-settings)
      (sleep 1)
      (demo-loop)
      (format-demo "
The user will type in a sentence to
be parsed by the current network, for
instance :
Is a pizza eaten by the man in the restaurant?
Push <continue>
")
      (demo-loop)
      (setq *last-sentence* "Is a pizza eaten by the man in the restaurant?")
      (format-demo  
           "
The <Parse Sentence> menu item
starts the parsing algorithm. When the
graphical output is set on, a hopping
cursor displays the currently active 
node of the network. 
")
      (demo-loop)
      (parse-sentence)   
      (format-demo "
The present network is designed to
output a logical analysis of the
given sentence once a parse is found.
The kind of output you can see in the
ATN:output display is determined by 
the user who designed the network.
In this case the parser descovered that
the sentence is a question, that the
tense is present, that the subject is
the man and so on. Notice that, since
the interpretation of the sentence is
ambiguous, the atn generates two different
parses. 
")
      (demo-loop) 
      (format-demo "
We can give a look to the state
of the registers, by selecting <Print Registers>
in the Parser menu
")
      (demo-loop)
      (print-every-register)
      (format-demo "
Remember that you can inspect the
state of the registers at any point 
of the parsing process, using the
<step> mode.
")
      (demo-loop)
      (when *show-graphics* (update-graphics))
      (close-lex-window)
      (format-demo "
**This is the end of the second demo**"))
     