;;; -*- Mode: LISP; Package: atn; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;  AUGMENTED TRANSITION NETWORKS
;;; ************************************************************************
;;;
;;; Filename:   atn-demo3.cl
;;; Short Desc:  third demo on Augmented Transition Networks
 ;;; Version:    1.0
 ;;; Status:     Review
 ;;; Last Mod:   28.9.91 - FB
 ;;; Author:     Fabio Baj
 ;;;
 ;;; --------------------------------------------------------------------------
 ;;; Change History:
 ;;;
 ;;;
 ;;; --------------------------------------------------------------------------

 
 ;;; ==========================================================================
 ;;; PACKAGE DECLARATIONS
 ;;; ==========================================================================
 (in-package :atn)


(defun start-demo-3 ()
      (when
               (create-demo-dialog 
                    :window-title "ATN Demos"
                    :title "Augmented Transition Networks"
                    :subtitle "A Third Demo"
                    :helpfile "atn\\help\\atn-demo3.hlp"
                    :window *atn-main-window*)
             (setq *demo-net-file*
                   (concatenate 'string
                         *pail-directory* "atn\\networks\\net-6."))
             (setq *demo-lex-file*
                   (concatenate 'string
                         *pail-directory* "atn\\lexicon\\lex-3."))
             (setq *current-net-file*
                   (concatenate 'string
                         *pail-directory* "atn\\networks\\net-6."))
             (setq *current-lex-file*
                   (concatenate 'string
                         *pail-directory* "atn\\lexicon\\lex-3."))
             (setq *atn-demo-running* t)
             (catch 'stop-demo (main-demo-3))
             (setq *atn-demo-running* nil)))




(defun main-demo-3 ( )
      (format-demo "Here is a third demo on augmented 
transition networks. You will see
how to integrate the ATN module
with the theorem proving one. 
The network net-6 and lexicon lex-3
define a parser which translates a
subset  of english sentences into first
order logic formulas, which can be given 
as input to the theorem proving module.
")
      (demo-loop)
      (format-demo "
Now we select net-6  as the current net
and lex-3 as current lexicon
Here is the definition of net-6
")
      (demo-loop)
      (load *current-net-file*)
      (format-display *atn-output-window*
           "Network ~a loaded!~%~%"
            (file-namestring *current-net-file*))
      (setq *start-subnet* nil)
      (set-menu-after-load-network)
      (setq *net* *network*)
      (when *show-graphics*
             (update-graphics)
             (update-graphics))
      (setq *lexicon* (loadlex *demo-lex-file*))
      (create-lex-window *lexicon*)
      (format-display *atn-output-window*
           "~%Lexicon ~a loaded!~%~%"
            (file-namestring *demo-lex-file*))
      (set-menu-after-load-lexicon)
      (view-current-network)
      (demo-loop)
      (format-demo "
This network is able to transorm
sentences like  

luca loves every woman which 
does not like a man

into first oder formulas like

all x2  ((Woman(x2) \& \~\~exists x3  
(Man(x3) \& Like(x2\,x3))) \=\> Love(luca\,x2)).

Then the Theorem Proving module can be
used to make deductions about the semantic
content of the sentences.
")   
     (demo-loop)
     (format-demo "
Now we try to parse a simple sentence like:
    Paolo likes a woman who does  not 
    love a man which owns a car
")
     (setq *last-sentence* 
          "Paolo likes a woman who does not love a man which owns a car" )
     (demo-loop)
     (format-demo "
First you turn the graphic layout on:
")
      (demo-loop)
      (parser-settings)
      (format-demo "By selecting <Parse Sentence> 
we start the parsing algorithm. When the
graphical output is set on, a hopping
cursor displays the currently active 
node of the network. 
")
     (demo-loop)
     (repeat-last-parse)  
     (format-demo "
The output window shows the first
order formula representing the meaning
of the input sentence. The network
is designed to direct the output 
formulas also to a theorem file, 
[*pail-directory*]/atp/examples/AtnOut.th
which can be loaded with the ATP module.
For instance  you can use the ATP module
to check the consistency of a set of 
sentences, or to see if a sentence is
logical consequence of a set of premises
")
      (demo-loop) 
      (when *show-graphics* (update-graphics))
      (close-lex-window)
      (format-demo "
**This is the end of the third demo**"))
