;;; -*- Mode: LISP; Package: atp; Syntax: Common-lisp; -*-

(in-package :atp)

;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   atp-browser.cl
;;; Short Desc: A browser to show proof trees
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   8.9.91 - FB
;;; Author:     Fabio Baj
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------

;;; ==========================================================================
;;; GLOBAL VARIABLE DECLARATIONS
;;; ==========================================================================


(defvar *current-browser* nil)
(defvar *button-descriptions* nil)



(defclass atp-browser (browser)
      ())

(defmethod initialize-instance  :after ((a atp-browser)  &rest keys)
     (setq *current-browser* a))

(defmethod window-close ((a atp-browser))
     (setq *current-browser* nil)
     (dolist (descriptions *button-descriptions*)
          (when (windowp descriptions)
               (window-close descriptions)))
     (close a))



(defclass atp-browser-dialog (dialog)
      ())

(defmethod initialize-instance :after ((a atp-browser-dialog)  &rest keys)
     (push a *button-descriptions*))

(defmethod window-close ((a atp-browser-dialog))
     (delete a *button-descriptions*)
     (close a))




(defmethod pail-lib::browser-select-item ((b atp-browser) item mousestate)
      (let* ((description (dialog-item-title item))
                (meaning (eval (read-from-string description)))
                (result (clause-to-string meaning))
                (browser-item-description
                 (open-dialog ()
                       'dialog (wtree b)
                       :user-closable nil :user-movable nil
                       :user-resizable nil :user-shrinkable nil
                       :user-scrollable nil :pop-up-p nil
                       :window-border :dialog-box
                       :font (make-font :modern nil 10 '(:bold))
                       :window-exterior
                       (make-box
                              (- (box-right (dialog-item-box item))
                                 (position-x (scroll-position (wtree *browser-disp*))))
                              (- (box-top (dialog-item-box item))
                                 (position-y (scroll-position (wtree *browser-disp*))))
                              (- (+ (box-right (dialog-item-box item)) 50
                                      (* 5 (length result)))
                                 (position-x (scroll-position (wtree *browser-disp*))))
                              (- (+ (box-top (dialog-item-box item)) 30)
                                 (position-y (scroll-position (wtree *browser-disp*))))))))
          (update-dialog browser-item-description
                (list
                   (make-dialog-item :widget 'static-text
                          :box (make-box 5 5 (+ (* 5 (length result)) 5) 30)
                          :value result)
                   (make-dialog-item :widget 'default-button
                          :box (make-box
                                          (+ 5 (* 5 (length result)))
                                          1
                                          (+ 35 (* 5 (length result)))
                                          19)
                          :set-value-fn
                          `(lambda (item new old) (close ,browser-item-description))
                          :name ':close
                          :title "Close"
                          :font (make-font :modern nil 10 '(:bold)))))))
       
                
        
            
#|
(defmethod browser-help ((b button))
  (make-instance 'help-window
    :filename (concatenate 'string
                           *pail-directory*
                           "atp\\help\\atp-browser.help")
;    :view-size #@(350 250)
    :direction :output
    :grow-icon-p t
    :window-title "ATP: Theorem Browser HELP"))

|#