;;; -*- Mode: LISP; Package: atp; Syntax: Common-lisp; -*-

(in-package :atp)

;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   atn-classes.lisp
;;; Short Desc: general user interface for the  ATP tool
;;;            
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   4. july 1992 - PC
;;; Author(s):  Paolo Cattaneo
;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;; 
;;; 
;;; --------------------------------------------------------------------------

(defclass atp-dialog (dialog)
  ())

(defmethod initialize-instance :after ((ad atp-dialog) &rest x)
     (push ad *open-atp-windows*))

(defmethod window-close ((ad atp-dialog))
     (close ad)
     (delete ad *open-atp-windows*))



(defclass atp-main-dialog (atp-dialog)
      ())

(defmethod bring-window-to-front :after ((ad atp-main-dialog))
        (in-package :atp)
        (set-atp-menubar)
     (setf (stream-title *lisp-main-window*) "PAIL - Automated Theorem Prover module"))

(defmethod window-close ((imd atp-main-dialog))
      (when (yes-or-no-p "Do you really want to
quit the ATP module")
          (remove-from-window-menu (object-name *atp-main-window*))
          (close imd)
          (setf imd nil)
          (quit-atp)))

(defmethod redisplay-window :after ((d atp-main-dialog) &optional box)
      (in-package :atp))


(defmethod view-click-event-handler ((atp-dialog atp-dialog) where)
  (call-next-method)
  (in-package :atp)
;  (set-atp-menubar)
;  (set-help-atp)
     )



(shadow 'format-display)

(defun format-display (where how &rest params)
   (apply #'format (append (list where how) params))
   (format where "~%"))