;;; -*- Mode: LISP; Package: atp; Syntax: Common-lisp; -*-

(in-package :atp)

;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   atn-init.lisp
;;; Short Desc: general user interface for the  ATP tool
;;;            
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   4. july 1992 - PC
;;; Author(s):  Paolo Cattaneo
;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;; 
;;; 
;;; --------------------------------------------------------------------------

(use-package '(:cg))

(defparameter *open-atp-windows* nil)
(defparameter *atp-main-window* nil)
(defparameter *out-dialog* nil)
(defparameter *atp-output* nil)
(defparameter *atp-messages* nil)
(defparameter *stop-prove* nil)

(defvar *show-graphics* nil)
(defvar *show-status* nil)
(defvar *show-diagnostics* nil)
(defvar *show-status* nil)
(defvar *atp-output* nil)
(defvar *atp-messages* nil)

(defvar *contradiction* nil)
(defvar *theorem-loaded* nil)

(defconstant *w-percentage* 0.7)
(defconstant *w-indent* 15)
(defconstant *w-o-percentage* 0.6)
(defconstant *w-m-percentage* (- 1 *w-o-percentage*))
(defvar *w-size* 0)

;;(defmethod format-display :after (wherever fmt-string &rest args)
;;  (declare (ignore args fmt-string))
;;  (format wherever "~%"))               ;; special purpose for atp

(defun atp ()
      (setq pail-lib::*atp-module-loaded* t)
      (in-package :atp)
      (create-atp-window)
      (set-atp-menubar)
      ;  (set-help-atp)
      )



(defun set-help-atp ()
  (set-help :general "atp\\help\\atp-desc.hlp"))



(defun create-atp-window ()
     (unless *atp-main-window*
          (progn
              (setq *atp-main-window*
                   (open-dialog () 'atp-main-dialog *lisp-main-window* :pop-up-p nil
                        :title "ATP Main"
                        :name ':atp-main
                        :background-color (make-rgb :red 0 :green 128 :blue 128) 
                        :window-exterior (clipping-box *lisp-main-window*)))
              (add-to-window-menu
                   (stream-title *atp-main-window*)
                   (object-name *atp-main-window*))
              (create-theorem-dialogs))))


(defun create-theorem-dialogs ()
     (let* ((*number-of-buttons* 4)           
                (box (window-interior *atp-main-window*))
                (h-indent (round (* 0.2 (box-width box))))
                (v-indent (round (* 0.2 (- (box-height box) 20))))
                (h-size (- (box-width box) (* 2 h-indent)))
                (button-width (round (/ h-size *number-of-buttons*)))
                (button-height 25)
                (help-button nil)
                (out-dialog nil))
          (setq out-dialog (setq *out-dialog*
                (open-dialog () 'dialog *atp-main-window*
                      :pop-up-p nil
                      :title "ATP: Output"
                      :user-closable nil
                      :user-shrinkable t
                      :user-resizable nil
                      :user-scrollable nil
                      :user-movable t
                      :window-border :dialog-box
                      :window-interior
                      (make-box 
                             h-indent 
                             (+ v-indent button-height)
                             (- (box-width box) h-indent)
                             (- (box-height box) v-indent)))))
         (setq *out-disp* (setq *dialog-disp*
              (open-stream
                   'text-edit-window out-dialog :output
                   :title "ATP: Output"
                   :name ':atp-output
                    :user-movable nil
                    :user-shrinkable nil
                   :user-closable nil
                   :user-resizable nil
                    :user-scrollable t
                   :font (make-font :modern nil 14)
                   :window-exterior
                   (make-box
                             0 button-height
                             (box-width (visible-box out-dialog))
                             (box-height (visible-box out-dialog))))))
         (update-dialog *out-dialog*
               (list
                  (make-dialog-item :widget 'button
                       :title "Help"
                       :set-value-fn #'(lambda (&rest x) (stepper-help))
                       :font (make-font nil :arial 16 '(:bold))
                       :available-p nil
                       :box (make-box
                                       0 0
                                        (round (/ (box-width (visible-box out-dialog)) *number-of-buttons*))
                                        button-height))
                  (make-dialog-item :widget 'button
                         :title "Proof Tree"
                         :name ':show-proof-tree-button
                         :set-value-fn #'(lambda (&rest x) (show-proof-tree))
                         :font (make-font nil :arial 16 '(:bold))
                         :available-p nil
                         :box
                         (make-box
                                (round (/ (box-width (visible-box out-dialog)) *number-of-buttons*))
                                0
                                (round (/ (* 2 (box-width (visible-box out-dialog))) *number-of-buttons*))
                                button-height))
                  (make-dialog-item :widget 'button
                         :title "Prove Theorem"
                         :name ':prove-theorem-button
                         :set-value-fn #'(lambda (&rest x) (new-p-t))
                         :font (make-font nil :arial 16 '(:bold))
                         :available-p nil
                         :box
                         (make-box
                                (round (/ (* 2 (box-width (visible-box out-dialog))) *number-of-buttons*)) 0
                                (round (/ (* 3 (box-width (visible-box out-dialog))) *number-of-buttons*)) button-height))
                  (make-dialog-item :widget 'button
                       :title "Load Theorem"
                       :name ':load-theorem
                       :set-value-fn #'(lambda (&rest x) (load-theorem))
                       :font (make-font nil :arial 16 '(:bold))
                       :available-p t
                       :box (make-box
                                       (round (/ (* 3 (box-width (visible-box out-dialog))) *number-of-buttons*)) 0
                                       (box-width (visible-box out-dialog)) button-height))))))
     


(defvar *atp-file-menu* nil)

(defun atp-new ()
     (:new *atp-main-window*))

;;; (defun atp-new ()
;;;      (let ((nt nil)
;;;             (file "New.th"))
;;;          (setq theorem
;;;                       (te::edit-file
;;;                        nil file))
;;; ;;;          (add-to-window-menu
;;; ;;;               (stream-title theorem)
;;; ;;;               (object-name theorem))
;;;          ))
;;; (defun atp-new ()
;;;      (setq pp
;;;           (open-stream 'text-edit-window
;;;                *atp-main-window*
;;;                :input
;;;                )))

(defun atp-close ()
     (let ((window (front-window *atp-main-window*)))
     (:close window)))

(defun atp-print ()
     (:print (front-window *atp-main-window*)))

(setq *atp-file-menu*
   (open-menu 
      (list 
         (make-menu-item :name :help :title "~Help"
            :value 'atp-file-help :available-p nil
            :selected-p nil :font nil :event-synonym 
            '(control-key #\H))
         menu-separator
         (make-menu-item :name :help :title "~New"
            :value 'atp-new :available-p t
            :selected-p nil :font nil :event-synonym 
            '(control-key #\N))
         (make-menu-item :name :help :title "~Open"
            :value 'atp-open :available-p t 
            :selected-p nil :font nil :event-synonym 
            '(control-key #\O))
         (make-menu-item :name :help :title "~Close"
            :value 'atp-close :available-p nil
            :selected-p nil :font nil)
         menu-separator
         (make-menu-item :title "~Load Theorem..."
            :value 'load-theorem :available-p t 
                :name ':load-theorem
            :selected-p nil :font nil)
         (make-menu-item :name :help :title "~Edit Theorem..."
            :value 'edit-theorem :available-p t 
            :selected-p nil :font nil)
         menu-separator
         (make-menu-item :name :help :title "~Save"
            :value 'atp-save :available-p t
            :selected-p nil :font nil :event-synonym 
            '(control-key #\S))
         (make-menu-item :name :help :title "Save ~As"
            :value 'atp-save-as :available-p t
            :selected-p nil :font nil)
         menu-separator
         (make-menu-item :name :help :title "~Print"
            :value 'atp-print :available-p t
            :selected-p nil :font nil :event-synonym 
            '(control-key #\P))
         menu-separator
         (make-menu-item :name :help :title "E~xit from ATP"
            :value 'atp-exit :available-p t
            :selected-p nil :font nil :event-synonym 
            '(control-key #\X)))
      'pop-up-menu *lisp-main-window* :name '*atp-file-menu* :title '"" 
      :selection-function 'funcall-menu-item))

                  
(defun atp-open ()
      (:open *atp-main-window*))                  
             

(defun atp-save ()
      (:save *atp-main-window*))                  
             
(defun atp-save-as ()
      (:save-as *atp-main-window*))                  
             
(defun atp-exit ()
     (window-close *atp-main-window*))
                            
(defun quit-atp ()
     (make-available :atp)
     (setq pail-lib::*atp-module-loaded* nil)
     (select-window pail-lib::*pail-main-window*)
     (in-package :pail-lib))


(defun load-theorem ()
     (let
    ((nfile 
                       (ask-user-for-existing-pathname
                        "Theorem to load"
                        :stream  *atp-main-window*
                        :allowed-types '(("Theorem Files" . "*.thm")("All Files"  . "*.*"))
                        :host (concatenate 'string *pail-directory* "atp\\examples\\")
                        )))            
         (when nfile
              (progn
                   (format-display *out-disp*
                        "~% Loading theorem ~A ...~%"
                        (file-namestring nfile))
                  (setq *last-theorem* nfile)
                  (catch 'syntax-error (preproc1 *last-theorem*))
                  (if (eq 0  *errors-found*)
                     (progn
                         (setq *theorem-loaded* t)
                         (enable-menu-items t)))))))


(defun enable-menu-items (value)
      (if (eql $strategy$ 'prolog-strat)
         (set-menu-item-available-p
              (find-named-object ':prolog-interpreter-button *atp-prover-menu*)
              value)
         (set-menu-item-available-p
              (find-named-object ':prolog-interpreter-button *atp-prover-menu*)
              nil))
     (set-menu-item-available-p
          (find-named-object ':prove-theorem-button *atp-prover-menu*)
          value)
     (set-dialog-item-available-p
          (find-named-object ':prove-theorem-button *out-dialog*)
          value)
     (set-menu-item-available-p
          (find-named-object ':show-proof-button *atp-prover-menu*)
          (not value))
     (set-menu-item-available-p
          (find-named-object ':show-proof-tree-button *atp-prover-menu*)
          (not value))
     (set-dialog-item-available-p
          (find-named-object ':show-proof-tree-button *out-dialog*)
          (not value))
     (set-menu-item-available-p
          (find-named-object ':load-previous-button *atp-prover-menu*)
          value))



(defun edit-theorem ()
     (let ((file (pop-up-open-file-dialog
                        *atp-main-window*
                        nil
                        "Open File"
                        "Theorem to edit"
                        "*.th"
                        (concatenate 'string *pail-directory* "atp\\examples\\")))
            theorem)
         (when file
              (setq theorem
                   (te::edit-file
                    nil file))
              ;;;                   (add-to-window-menu
              ;;;                        (stream-title theorem)
              ;;;                        (object-name theorem)
              ) ))





(defvar *atp-prover-menu* nil)

(setq *atp-prover-menu*
   (open-menu 
      (list 
         (make-menu-item  :title "Load Theorem..."
            :value 'load-theorem :available-p t
                :name ':load-theorem
            :selected-p nil :font nil)
         menu-separator
         (make-menu-item  :title "Prove Theorem"
            :value 'new-p-t :available-p nil
            :name ':prove-theorem-button
            :selected-p nil :font nil)
         (make-menu-item  :title "Show Proof"
            :value 'show-proof :available-p nil
            :name ':show-proof-button
            :selected-p nil :font nil)
         (make-menu-item :title "Show Proof Tree"
            :value 'show-proof-tree :available-p nil
            :name ':show-proof-tree-button
            :selected-p nil :font nil)
         menu-separator
         (make-menu-item :title "Prolog Interpreter"
            :value 'prolog-interpreter :available-p nil 
            :name ':prolog-interpreter-button
            :selected-p nil :font nil)
         (make-menu-item :title "Load Previous"
            :value 'load-previous :available-p nil
            :name ':load-previous-button
            :selected-p nil :font nil)
         (make-menu-item  :title "List Database"
            :value 'list-db :available-p t 
            :selected-p nil :font nil)
         (make-menu-item :title "Clear Output"
            :value 'clear-out :available-p t
            :selected-p nil :font nil)
         menu-separator
         (make-menu-item :title "Theorem Parameters..."
            :value 'set-atp-param :available-p t
            :selected-p nil :font nil)
         menu-separator
         (make-menu-item :title "Help"
            :value 'atp-prover-help :available-p nil
            :name ':atp-help-button
            :selected-p nil :font nil))
      'pop-up-menu *lisp-main-window* :name '*atp-prover-menu* :title '"" 
      :selection-function 'funcall-menu-item))
     

(defun new-p-t ()
       (if (string=
                (dialog-item-title
                    (find-named-object ':prove-theorem-button *out-dialog*))
                "Stop Proving")
          (setq *stop-prove* t)
          (progn
               (unless *stop-prove*
                     (if $prolog-mode$ (setq $simps$ nil)))
               (p-t))))
               
              
  

(defun p-t () 
      (setq *stop-prove* nil)
      (set-menu-items-before-prove)
      (format-display *out-disp*
           "~% Proving theorem ...~%")
      (loop
          (process-pending-events)
          (when *stop-prove* (return))
          (if  (contradiction) 
             (progn 
                  (setq *contradiction* t)
                  (if  (more-solutions)
                     (progn
                          (process-pending-events)
                          (setq $contr$ nil))
                     (return 'contradiction))))
          (let* ((x-y (funcall (choose-clauses-function (eval $strategy$))))
                    (x (car x-y))
                    (y (cadr x-y)))
              (if (member nil x-y) (return 'consistent))
              (make-deductions x  y)))
      (unless *stop-prove*
            (notify-results))
      (set-menu-items-after-prove))
              


(defun set-menu-items-before-prove ()
     (set-menu-item-available-p
          (find-named-object ':load-theorem *atp-file-menu*) nil)
     (set-menu-item-available-p
          (find-named-object ':load-theorem *atp-prover-menu*) nil)
     (set-dialog-item-available-p
          (find-named-object ':load-theorem *out-dialog*) nil)
      (set-menu-item-available-p
            (find-named-object ':show-proof-button *atp-prover-menu*) nil)
      (set-menu-item-available-p
            (find-named-object ':show-proof-tree-button *atp-prover-menu*) nil)
      (set-dialog-item-available-p
           (find-named-object ':show-proof-tree-button *out-dialog*) nil)
      (set-menu-item-title
            (find-named-object ':prove-theorem-button *atp-prover-menu*)
            "Stop Proving")
      (set-dialog-item-title
            (find-named-object ':prove-theorem-button *out-dialog*)
            "Stop Proving"))


(defun set-menu-items-after-prove ()
     (set-menu-item-available-p
          (find-named-object ':load-theorem *atp-file-menu*) t)
     (set-menu-item-available-p
          (find-named-object ':load-theorem *atp-prover-menu*) t)
     (set-dialog-item-available-p
          (find-named-object ':load-theorem *out-dialog*) t)
      (set-menu-item-available-p
            (find-named-object ':show-proof-button *atp-prover-menu*) (root-id))
      (set-menu-item-available-p
            (find-named-object ':show-proof-tree-button *atp-prover-menu*) (root-id))
      (set-dialog-item-available-p
           (find-named-object ':show-proof-tree-button *out-dialog*) (root-id))
      (set-dialog-item-title
            (find-named-object ':prove-theorem-button *out-dialog*)
            "Prove Theorem")
      (set-menu-item-title
            (find-named-object ':prove-theorem-button *atp-prover-menu*)
            "Prove Theorem"))
      
   
(defun load-previous ()
      (format-display *out-disp*
           "~% Loading theorem ~A ...~%"
           (file-namestring *last-theorem*))
     (catch 'syntax-error (preproc1 *last-theorem*))
     (if (eq 0  *errors-found*)
        (setq *theorem-loaded* t)))



(defun show-proof ()
     (format-display *out-disp*
         "~%        P R O O F ~%")
     (trace-proof-i))



(defun list-db ()
     (format-display *out-disp*
         "~%  Listing Data Base ... ~%")
     (list-rules))



(defun clear-out ()
     (acl::clear-page *out-disp*))



(defun show-proof-tree ()
  (proof-tree 2))



(defvar *atp-demo-menu* nil)
(defvar *atp-demo-running* nil)

(setq *atp-demo-menu*
   (open-menu 
      (list 
         (make-menu-item :name :atp-demo1 :title "Demo 1"
            :value 'demo-1 :available-p t 
            :selected-p nil :font nil)
         (make-menu-item :name :atp-demo2 :title "Demo 2"
            :value 'demo-2 :available-p t
            :selected-p nil :font nil)
         (make-menu-item :name :atp-demo3 :title "Demo 3"
            :value 'demo-3 :available-p t
            :selected-p nil :font nil)
         (make-menu-item :name :atp-demo3 :title "Demo 4"
            :value 'demo-4 :available-p t
            :selected-p nil :font nil)
         (make-menu-item :name :atp-demo3 :title "Demo 5"
            :value 'demo-5 :available-p t
            :selected-p nil :font nil)
         (make-menu-item :name :atp-demo3 :title "Demo 6"
            :value 'demo-6 :available-p t
            :selected-p nil :font nil))
      'pop-up-menu *lisp-main-window* :name '*atp-demo-menu* :title '"" 
      :selection-function 'funcall-menu-item))
     


(defun demo-1 (&rest nulla)
     (declare (ignore nulla))
     (start-demo-1))

(defun demo-2 (&rest nulla)
     (declare (ignore nulla))
     (start-demo-2))

(defun demo-3 (&rest nulla)
     (declare (ignore nulla))
     (start-demo-3))

(defun demo-4 (&rest nulla)
     (declare (ignore nulla))
     (start-demo-4))

(defun demo-5 (&rest nulla)
     (declare (ignore nulla))
     (start-demo-5))

(defun demo-6 (&rest nulla)
     (declare (ignore nulla))
     (start-demo-6))



(defvar *atp-menubar* nil)

(defun set-atp-menubar ()
;;;      (setq *lisp-menu-bar*
;;;           (open-stream 'menu-bar *lisp-main-window* :io))
     (clean-up-menubar)
     (add-to-menu *lisp-menu-bar*
          (make-menu-item
                :name 'nil
                :title '~Tools
                :value *pail-tool-menu*
                :available-p t
                :selected-p nil 
                :font nil 
                :event-synonym 'nil 
                :plist '(pc::event-synonym nil)))
     (add-to-menu *lisp-menu-bar*
          (make-menu-item
                :name 'nil
                :title '~File
                :value *atp-file-menu*
                :available-p t
                :selected-p nil 
                :font nil 
                :event-synonym 'nil 
                :plist '(pc::event-synonym nil)))
     (add-to-menu *lisp-menu-bar*
          (make-menu-item
                :name 'nil
                :title '~Edit
                :value *pail-edit-menu*
                :available-p t
                :selected-p nil 
                :font nil 
                :event-synonym 'nil 
                :plist '(pc::event-synonym nil)))
     (add-to-menu *lisp-menu-bar*
          (make-menu-item
                :name 'nil
                :title '"Theorem ~Prover"
                :value *atp-prover-menu*
                :available-p t
                :selected-p nil 
                :font nil 
                :event-synonym 'nil 
                :plist '(pc::event-synonym nil)))
     (add-to-menu *lisp-menu-bar*
          (make-menu-item
                :name 'nil
                :title '~Demos
                :value *atp-demo-menu*
                :available-p t
                :selected-p nil 
                :font nil 
                :event-synonym 'nil 
                :plist '(pc::event-synonym nil)))
     (add-to-menu *lisp-menu-bar*
          *pail-window-menu*)  
    ;; (set-window-menu *atp-main-window* *lisp-menu-bar*)
     )



(defun notify-results ()
      (let ((result-dialog
               (open-dialog
                     (list
                        (make-dialog-item :widget 'static-text
                               :font (make-font :modern nil 20 '(:bold))
                               :box (make-box 20 15 370 35)
                               :value 
                               (if $contr$
                                  (if $answering$
                                     (format nil "   Answer found at clause ~A" $contr$ )
                                     (format nil "Contradiction found at clause ~A" $contr$))
                                     (format nil "     Contradiction not found")))
                        (make-dialog-item :widget 'static-text
                               :font (make-font :modern nil 20)
                               :box (make-box 20 60 250 80)
                               :value "Termination-status")
                        (make-dialog-item :widget 'static-text
                               :font (make-font :modern nil 20 '(:bold))
                               :box (make-box 270 60 350 80)
                               :value "normal")
                        (make-dialog-item :widget 'static-text
                               :font (make-font :modern nil 20)
                               :box (make-box 20 90 250 110)
                               :value "Clauses generated")
                        (make-dialog-item :widget 'static-text
                               :font (make-font :modern nil 20 '(:bold))
                               :box (make-box 270 90 350 110)
                               :value $generated-rules$)
                        (make-dialog-item :widget 'static-text
                               :font (make-font :modern nil 20)
                               :box (make-box 20 120 250 140)
                               :value "Clauses kept")
                        (make-dialog-item :widget 'static-text
                               :font (make-font :modern nil 20 '(:bold))
                               :box (make-box 270 120 350 140)
                               :value (1- $rule-id))
                        (make-dialog-item :widget 'static-text
                               :font (make-font :modern nil 20)
                               :box (if $contr$
                                           (make-box 20 150 250 170)
                                           (make-box 0 0 0 0))
                               :value "Proof length")
                        (make-dialog-item :widget 'static-text
                               :font (make-font :modern nil 20 '(:bold))
                               :box (if $contr$
                                           (make-box 270 150 350 170)
                                           (make-box 0 0 0 0))
                               :value (proof-length))
                        (make-dialog-item :widget 'static-text
                               :font (make-font :modern nil 20)
                               :box (if $contr$
                                           (make-box 20 180 250 200)
                                           (make-box 20 160 250 180))
                               :value "Unification attempts")
                        (make-dialog-item :widget 'static-text
                               :font (make-font :modern nil 20 '(:bold))
                               :box (if $contr$
                                           (make-box 270 180 350 200)
                                           (make-box 270 160 350 180))
                               :value $unification-attempts$)
                        (make-dialog-item :widget 'default-button
                               :title "OK"
                               :set-value-fn
                               #'(lambda (&rest args) (values t t))
                               :box (make-box 260 220 360 250)))
                     'dialog *atp-main-window* :pop-up-p t
                     :user-closable nil :user-shrinkable nil
                     :user-scrollable nil :user-resizable nil
                     :dialog-border :dialog-box :title ""
                     :window-interior
                     (make-box
                            (round (- (/ (box-width (window-interior *atp-main-window*)) 2) 185))
                            (round (- (/ (box-height (window-interior *atp-main-window*)) 2) 130))
                            (round (+ (/ (box-width (window-interior *atp-main-window*)) 2) 185))
                            (round (+ (/ (box-height (window-interior *atp-main-window*)) 2) 130))))))
          (pop-up-dialog result-dialog)
          (close result-dialog)))
              
                     
      
(defun proof-length()
  (length (delete 'axiom 
	   (delete 'sos  
		   (remove-duplicates
		    (expand (list (root-id))))))))
