;;; -*- Mode: LISP; Package: atp; Syntax: Common-lisp; -*-

(in-package :atp)

(defvar *atp-parameter-settings* nil)

(defun set-atp-param ()
      (setq *atp-parameter-settings*
            (open-dialog
                  (list
                     (make-dialog-item :widget 'static-text 
                            :tabstop nil :background-color t 
                            :box #.(make-box 20 10 150 26)
                            :font (make-font nil :arial 14 '(:bold))
                            :name :text0 :value "Output format")
                     (make-dialog-item :widget 'radio-button
                            :tabstop nil :background-color t 
                            :box #.(make-box 40 30 165 46)
                            :font (make-font nil :arial 14 '(:bold))
                            :set-value-fn
                            '(lambda (item new old) 
                                 (setq $output-format$ 'no-output))
                            :name :rbutton01 :title "No Output"
                            :cluster 0 :value (eql $output-format$ 'no-output))
                     (make-dialog-item :widget 'radio-button
                            :tabstop nil :background-color t 
                            :box #.(make-box 180 30 300 46)
                            :font (make-font nil :arial 14 '(:bold))
                            :set-value-fn
                            '(lambda (item new old)
                                 (setq $output-format$ 'prolog))
                            :name :rbutton02 :title "Prolog Format"
                            :cluster 0 :value (eql $output-format$ 'prolog))
                     (make-dialog-item :widget 'radio-button
                            :tabstop nil :background-color t 
                            :box #.(make-box 40 50 165 66)
                            :font (make-font nil :arial 14 '(:bold))
                            :set-value-fn
                            '(lambda (item new old)
                                 (setq $output-format$ 'sequent))
                            :name :rbutton03 :title "Sequent Format"
                            :cluster 0 :value (eql $output-format$ 'sequent))
                     (make-dialog-item :widget 'radio-button
                            :tabstop nil :background-color t 
                            :box #.(make-box 180 50 300 66)
                            :set-value-fn
                            '(lambda (item new old)
                                 (setq $output-format$ 'clause))
                            :font (make-font nil :arial 14 '(:bold))
                            :name :rbutton04 :title "Clause Format"
                            :cluster 0 :value (eql $output-format$ 'clause))
                     (make-dialog-item :widget 'static-text 
                            :tabstop nil :background-color t 
                            :box #.(make-box 20 75 150 91)
                            :font (make-font nil :arial 14 '(:bold))
                            :name :text1 :value "Insertion Procedure")
                     (make-dialog-item :widget 'radio-button
                            :tabstop nil :background-color t 
                            :box #.(make-box 40 95 165 111)
                            :font (make-font nil :arial 14 '(:bold))
                            :set-value-fn
                            '(lambda (item new old)
                                 (setq $insert-procedure$ 'fifo-ins))
                            :name :rbutton11 :title "First In First Out"
                            :cluster 1 :value (eql $insert-procedure$ 'fifo-ins))
                     (make-dialog-item :widget 'radio-button
                            :tabstop nil :background-color t 
                            :box #.(make-box 180 95 300 111)
                            :set-value-fn
                            '(lambda (item new old)
                                 (setq $insert-procedure$ 'smallest))
                            :font (make-font nil :arial 14 '(:bold))
                            :name :rbutton12 :title "Smallest First"
                            :cluster 1 :value (eql $insert-procedure$ 'smallest-ins))
                     (make-dialog-item :widget 'radio-button
                            :tabstop nil :background-color t 
                            :box #.(make-box 40 115 165 131)
                            :font (make-font nil :arial 14 '(:bold))
                            :set-value-fn
                            '(lambda (item new old)
                                 (setq $insert-procedure$ 'lifo-ins))
                            :name :rbutton13 :title "Last In First Out"
                            :cluster 1 :value (eql $insert-procedure$ 'lifo-ins))
                     (make-dialog-item :widget 'static-text 
                            :tabstop nil :background-color t 
                            :box #.(make-box 20 140 150 156)
                            :font (make-font nil :arial 14 '(:bold))
                            :name :text2 :value "Strategy")
                     (make-dialog-item :widget 'radio-button
                            :tabstop nil :background-color t 
                            :box #.(make-box 40 160 165 178)
                            :font (make-font nil :arial 14 '(:bold))
                            :set-value-fn
                            '(lambda (item new old) 
                                 (prolog-init)
                                 (setq $strategy$ 'prolog-strat))
                            :name :rbutton21 :title "Prolog Strategy"
                            :cluster 2 :value (eql $strategy$ 'prolog-strat))
                     (make-dialog-item :widget 'radio-button
                            :tabstop nil :background-color t 
                            :box #.(make-box 180 160 300 178)
                            :font (make-font nil :arial 14 '(:bold))
                            :set-value-fn
                            '(lambda (item new old)
                                 (setq $prolog-mode$ nil)
                                 (setq $strategy$ '*man*))
                            :name :rbutton22 :title "Manual Strategy"
                            :cluster 2 :value (eql $strategy$ '*man*))
                     (make-dialog-item :widget 'radio-button
                            :tabstop nil :background-color t 
                            :box #.(make-box 40 180 165 198)
                            :font (make-font nil :arial 14 '(:bold))
                            :set-value-fn
                            '(lambda (item new old)
                                 (sos-init)
                                 (setq $strategy$ '*sos*))
                            :name :rbutton23 :title "Set of Support"
                            :cluster 2 :value (eql $strategy$ '*sos*))
                     (make-dialog-item :widget 'radio-button
                            :tabstop nil :background-color t 
                            :box #.(make-box 180 180 300 196)
                            :set-value-fn
                            '(lambda (item new old)
                                 (init-standard)
                                 (setq $strategy$ 'standard))
                            :font (make-font nil :arial 14 '(:bold))
                            :name :rbutton24 :title "Standard"
                            :cluster 2 :value (eql $strategy$ 'standard))
                     (make-dialog-item :widget 'static-text 
                            :tabstop nil :background-color t 
                            :box #.(make-box 20 205 150 221)
                            :font (make-font nil :arial 14 '(:bold))
                            :name :text3 :value "Inference Rules")
                     (make-dialog-item :widget 'check-box
                            :tabstop nil :background-color t 
                            :box #.(make-box 40 225 165 241)
                            :font (make-font nil :arial 14 '(:bold))
                            :set-value-fn
                            '(lambda (item new old)
                                 (setq $answering$ (not $answering$)) t)
                            :name :chbox31 :title "Answering"
                            :value $answering$)
                     (make-dialog-item :widget 'check-box
                            :tabstop nil :background-color t 
                            :box #.(make-box 40 245 250 261)
                            :font (make-font nil :arial 14 '(:bold))
                            :set-value-fn
                            '(lambda (item new old)
                                 (setq $semantic-simplification$ (not $semantic-simplification$)) t)
                            :name :chbox32 :title "Semantic Simplification"
                            :value $semantic-simplification$)
                     (make-dialog-item :widget 'check-box
                            :tabstop nil :background-color t 
                            :box #.(make-box 40 265 250 281)
                            :font (make-font nil :arial 14 '(:bold))
                            :set-value-fn
                            '(lambda (item new old)
                                 (setq $neg-resolution$ (not $neg-resolution$)) t)
                            :name :chbox33 :title "Negative Resolution"
                            :value $neg-resolution$)
                     (make-dialog-item :widget 'check-box
                            :tabstop nil :background-color t 
                            :box #.(make-box 40 285 250 301)
                            :font (make-font nil :arial 14 '(:bold))
                            :set-value-fn
                            '(lambda (item new old)
                                 (setq $p-resolution$ (not $p-resolution$)) t)
                            :name :chbox34 :title "Positive Atom Resolution"
                            :value $p-resolution$)
                     (make-dialog-item :widget 'check-box
                            :tabstop nil :background-color t 
                            :box #.(make-box 40 305 165 321)
                            :font (make-font nil :arial 14 '(:bold))
                            :set-value-fn
                            '(lambda (item new old)
                                 (setq $factoring$ (not $factoring$)) t)
                            :name :chbox35 :title "Factorization"
                            :value $factoring$)
                     (make-dialog-item :widget 'check-box
                            :tabstop nil :background-color t 
                            :box #.(make-box 40 325 250 341)
                            :font (make-font nil :arial 14 '(:bold))
                            :set-value-fn
                            '(lambda (item new old)
                                 (setq $resolution$ (not $resolution$)) t)
                            :name :chbox36 :title "Binary Resolution"
                            :value $resolution$)
                     (make-dialog-item :widget 'radio-button
                            :tabstop nil :background-color t 
                            :box #.(make-box 40 350 220 366)
                            :font (make-font nil :arial 14 '(:bold))
                            :set-value-fn
                            '(lambda (item new old) 
                                 (setq $restricted-paramodulation$ (not $restricted-paramodulation$))
                                 t)
                            :name :rbutton41 :title "Restricted Paramodulation"
                            :cluster 4 :value $restricted-paramodulation$)
                     (make-dialog-item :widget 'radio-button
                            :tabstop nil :background-color t 
                            :box #.(make-box 40 370 170 386)
                            :font (make-font nil :arial 14 '(:bold))
                            :set-value-fn
                            '(lambda (item new old) 
                                 (setq $paramodulation$ (not $paramodulation$))
                                 t)
                            :name :rbutton42 :title "Paramodulation"
                            :cluster 4 :value $paramodulation$)
                     (make-dialog-item :widget 'cancel-button :groupstart t 
                            :tabstop nil :background-color nil :box 
                            #.(make-box 180 385 240 410) :title "Help" 
                            :available-p nil
                            :font (make-font nil :arial 16 '(:bold))
                            :set-value-fn 
                            '(lambda (item new old) (atp-parameters-help))
                            :name :help-button)
                     (make-dialog-item :widget 'default-button :groupstart t 
                            :tabstop nil :background-color nil :box 
                            #.(make-box 245 385 305 410) :title "OK" 
                            :font (make-font nil :arial 16 '(:bold))
                            :set-value-fn 
                            #'(lambda (item new old) (values t t))
                            :name :default-button))
                  'dialog *atp-main-window* :name :atp-parameters
                  :title "ATP Parameters" :font (make-font :swiss :system 16 '(:bold)) 
                  :window-state nil :user-movable t :user-resizable nil 
                  :user-closable nil :user-shrinkable nil :user-scrollable nil 
                  :window-border :dialog-box
                  :pop-up-p t :window-interior
                  (make-box
                         (round (- (/ (box-width (window-interior *atp-main-window*)) 2) 155)) 85
                         (round (+ (/ (box-width (window-interior *atp-main-window*)) 2) 155)) 500)))
      (pop-up-dialog *atp-parameter-settings*)
      (close *atp-parameter-settings*)
      (setq *atp-parameter-settings* nil))
   
       

#|
(defun atp-parameters-help ()
  (make-instance 'help-window
    :filename (concatenate 'string
                           *pail-directory*
                           "atp:help:atp-parameters.help")
    :view-size #@(350 250)
    :direction :output
    :grow-icon-p t
    :window-title "ATP: Parameters HELP"))
|#

