;;; -*- Mode: LISP; Package: atp; Syntax: Common-lisp; -*-

(in-package :atp)

;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   class.cl
;;; Short Desc: classification of clauses
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   8.9.91 - FB
;;; Author:     Fabio Baj
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================




(defmethod classify ((clause clause-class) ancestors) 
  (set-class clause)
  (let 	((ci (make-instance 'clause-info)))
      (setf (size ci)  (funcall $weighting-procedure$  clause))
      (setf (sizelist ci)  (rsizelist clause))
      (setf (classlist ci) (rclass clause))
      (setf (ancestors ci) ancestors)
      ci))


    ;; WARNING: at now en-class recognizes only N-rules


(defmethod rsizelist ((clause clause-class))
  (cons (mapcar #'atm-wgt (negative-atoms  clause))
	(mapcar #'atm-wgt (positive-atoms clause))))

(defun map-plus (l)
  (if (null l) 0
    (apply '+ l)))

(defmethod rclass  ((clause clause-class))
  (append (para-class clause) ( en-class clause)(pd-class clause)))

(defmethod para-class ((clause clause-class))
  (cond  ((not (null (collect-equations (positive-atoms  clause)))) '(para))))


(defmethod pd-class  ((clause clause-class))
  (cond ( (is-positive-atom clause)
	  (if  (and (listp (car (positive-atoms clause)))(eq '-> (caar (positive-atoms clause))))
	      '(d)
	    '(p)))))
   

;; WARNING: actually en-class recognizes only N-rules

(defmethod en-class  ((clause clause-class))
  (cond ((null (positive-atoms clause)) '(en))))


(defmethod set-class  ((clause clause-class))
  (cond ((and (is-positive-atom clause)
	      (listp (car (positive-atoms clause))))
	 (cond ((eq '-> (caar (positive-atoms clause)))
		(change-class   clause 'oriented-equation))
	       ((eq '= (caar (positive-atoms clause)))
		(change-class  clause 'equation ))
	       (t (change-class clause 'positive-atom))))
	((null (positive-atoms clause)) (change-class clause 'all-negative-clause))
       ((not (null (collect-equations (positive-atoms  clause))))
	 (change-class clause 'para-clause))
       ((eq 1 (length (positive-atoms clause))) (change-class clause 'horn-clause))))


	 
      
 
