;;; -*- Mode: LISP; Package: atp; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   atp-demo1.cl
;;; Short Desc: First demo on automated theorem proving
;;;             The source file for the demo theorem is in atp-demo1.th
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   8.9.91 - FB
;;; Author:     Fabio Baj
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------

;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================
(in-package :atp)


;;=====================================================================
;; The definition of demo1
;;=====================================================================


(defun start-demo-1 ()
      (when 
               (create-demo-dialog  
                :window-title "ATP Demos"
                :title "Automated Theorem Prover"
                :subtitle "A First Demo"
                :helpfile "atp\\demos\\atp-d1.asc"
                :window *atp-main-window*)
             (progn
                  (setq *atp-demo-running* t)
                  (catch 'stop-demo (main-demo-1))
                  (setq *atp-demo-running* nil))))


(defun main-demo-1 ()
     (setq *last-theorem* "Agatha")
      (clear-out)
     (format-demo "Here is a first demo on automated theorem proving")
     (demo-loop)
     (format-demo "Let us suppose we are given the following problem:
The killer, a person who lives in the castle  killed 
Agatha. Agatha, Butler and  Charles live in the castle,
and nobody else. Everyone who kills someone hates him 
and is not richer than him. Charles does not hate who 
is hated by Agatha, who hates everyone but Butler. 
Butler hates everyone who is not richer than Agatha;
He also hates everyone is hated by Agatha. 
Everybody hates somebody. Agata is not Butler.
Who killed Agatha?

")
     (demo-loop)
     (format-demo "To use a theorem proving system to solve problems
one must specify it in the language of First Order 
Logic. Here is for example the logical specification
of the above puzzle")
     (demo-loop)
     (format-demo "
(The_killer killed Agatha).
(The_killer lives_in_the_castle).
(Agatha lives_in_the_castle).
(Butler lives_in_the_castle).
(Charles lives_in_the_castle).
(x lives_in_the_castle) => (x = Agatha) | (x = Butler) | (x = Charles).
(x killed y ) => (x hates y).
(x killed y) => ~~(x is_richer_than y).
(Agatha hates x) => ~~ (Charles hates x).
~~(x = Butler) =>  (Agatha hates x).
~~(x is_richer_than Agatha) => (Butler hates x).
(Agatha hates x) => (Butler hates x).
all x exists y ~~ (x hates y).
~~(Agatha = Butler).
")
    (demo-loop)
    (format-demo "The ATP tool has an answer extraction mechanism
so in some cases you can ask questions about objects.
For instance the question 'Who killed Agatha' can be represented
by the formula:

(the_murderer killed Agatha) => ?(the_murderer).

")

    (demo-loop)
    (format-demo "Now we can use the theorem proving tool
By clicking on the <Load Theorem...> menu
item we can load the theorem Agatha.th
I will do this for you! ")
    (demo-loop)
    (setq *last-theorem*
        (concatenate 'string *pail-directory* "atp\\examples\\Agatha.th"))
    (format-display *out-disp*
           "~% Loading theorem ~A ...~%"
           (file-namestring *last-theorem*))
    (catch 'syntax-error (preproc1 *last-theorem*))
    (if (eq 0  *errors-found*)
         (progn
              (setq *theorem-loaded* t)
              (enable-menu-items t)))
    (format-demo "Notice that when a theorem is loaded
its formulas are transformed in clauses. There are three 
different output formats for clauses: 
- sequent format
- clause  format
- Prolog  format")
    (demo-loop)
    (format-demo "The user can set the output format by pushing
the button <Prover Parameters>")
    (demo-loop)
    (format-demo "Now it is time to ask the prover to prove
the theorem. In this case the question answering system 
will find the correct answer to the question
'who killed Agatha?'
we click on <Prove Theorem> menu-item in the
<Theorem Prover> menu.")	  
    (new-p-t)
    (format-demo "The prover has found that Agatha\'s  murderer 
is Agatha itself.
Many of the generated clauses are not really useful:
we can ask the prover to show only the clauses
used to deduce the answer clicking on <Show Proof>
in the <Theorem Prover> menu
")
    (demo-loop)
    (show-proof)
    (format-demo "The button <Show Proof Tree> graphically displays
the proof tree. The root is the last clause generated
(an answering clause or a contradiction) and the leafs
are the initial axioms
" )
    (demo-loop)
    (show-proof-tree)
    (format-demo "
Pushing on the labels of the prof tree
you can see the correspondent formula. 
Press continue to close the browser.
")
    (demo-loop)
    (when (windowp *browser-disp*)
        (window-close *browser-disp*))
    (demo-loop)
    (format-demo "
******* End of the first DEMO ********")
)




