;;; -*- Mode: LISP; Package: atp; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   atp-demo2.cl
;;; Short Desc: Second demo on automated theorem proving
;;;             The source file for the demo theorem is in atp-demo2.th
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   8.9.91 - FB
;;; Author:     Fabio Baj
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================
(in-package :atp)



;;=====================================================================
;; The definition of demo2
;;=====================================================================


(defun start-demo-2 ( )
      (when
               (create-demo-dialog  
                :window-title "ATP Demos"
                :title "Automated Theorem Prover"
                :subtitle "A Second Demo"
                :helpfile "atp\\demos\\atp-d2.asc"
                :window *atp-main-window*)
             (progn
                  (setq *atp-demo-running* t)
                  (catch 'stop-demo (main-demo-2))
                  (setq *atp-demo-running* nil))))



(defun main-demo-2 ()
     (setq *last-theorem* "atp-d2")
      (clear-out)
     (format-demo "~%Here is a second demo about automated theorem proving")
     (demo-loop)
     (format-demo 
         "~%In this demo we want to use a theorem prover to
investigate a property of natural numbers.
This property says that for every prime number we have that
either its successor or its predecessor is divisible by 6.
To state whether this sentence about numbers is true or not
we must formalize the problem in the language of logic. 
The theorem prover is refutational, so to prove a theorem we
must negate it and try to obtain a contradiction.")
     (demo-loop)
     (format-demo 
         "~%The theorem can be stated in a input file which
will be read by the prover. Now you will see a tipical
input file of the theorem proving module.")
     (demo-loop)
     (te::load-file
         (setq *th-disp* 
                (open-stream 'text-edit-window *atp-main-window* :output))
         (concatenate 'string *pail-directory* "atp\\demos\\atp-d2.th"))
     (format-demo 
         "~%Now we can call the theorem proving tool")
     (demo-loop)
     (format-demo 
         "~%The <Load Theorem> button loads the theorem file")
     (demo-loop)
    (setq *last-theorem*
        (concatenate 'string *pail-directory* "atp\\demos\\atp-d2.th"))
    (format-display *out-disp*
           "~% Loading theorem ~A ...~%"
           (file-namestring *last-theorem*))
    (catch 'syntax-error (preproc1 *last-theorem*))
    (if (eq 0  *errors-found*)
         (progn
              (setq *theorem-loaded* t)
              (enable-menu-items t)))
     (format-demo 
         "~%The theorem proving module allows the user
to select among different theorem proving approaches:
there is the possibility to enable inference rules like
resolution, factoring, paramodulation, rewriting or
SLD-resolution (Prolog), as well as different search strategies.
The <Display Settings> button shows which options are selected
for the current theorem")
     (demo-loop)
     (set-atp-param)
     (format-demo 
         "~%To prove the theorem we must push the
<Prove Theorem> button")
     (demo-loop)
     (new-p-t)
     (format-demo 
         "~%Since the prover succeded to generate the empty clause
(contradiction) at clause c31, we can deduce that our conjecture 
about prime numbers is valid")
     (demo-loop)
     (show-proof)
     (format-demo 
         "~%Here is the complete proof")
     (demo-loop)
     (show-proof-tree)
     (format-demo 
         "~%Here is the proof tree")
     (format-demo 
         "~%Push <Continue> to close the browser") 
     (demo-loop)
     (format-demo 
         "~%******* End of the second DEMO ********")
      (when (windowp *th-disp*)
             (window-close *th-disp*))
    (when (windowp *browser-disp*)
          (window-close *browser-disp*)))

;;===============================================================

