;;; -*- Mode: LISP; Package: atp; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   atp-demo3.cl
;;; Short Desc: Third demo on automated theorem proving
;;;             The source file for the demo theorem is in atp-demo3.th
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   8.9.91 - FB
;;; Author:     Fabio Baj
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================
(in-package :atp)


;;=====================================================================
;; The definition of demo3
;;=====================================================================
  


(defun start-demo-3 ( )
      (when
               (create-demo-dialog  
                :window-title "ATP Demos"
                :title "Automated Theorem Prover"
                :subtitle "A Third Demo"
                :helpfile "atp\\demos\\atp-d3.asc"
                :window *atp-main-window*)
             (progn
                  (setq *atp-demo-running* t)
                  (catch 'stop-demo (main-demo-3))
                  (setq *atp-demo-running* nil))))

  
(defun main-demo-3 ( )
      (setq *last-theorem*
            (concatenate 'string
                  *pail-directory*
                  "atp\\demos\\atp-d3.th"))
      (clear-out)
      (format-demo
           "~%Here is a third demo on automated theorem proving:
It shows how a theorem proving system can be used
like a Prolog interpreter. Since a pure Prolog system is
nothing more than a restricted theorem prover with
answering system, is is possible to use this prover to
execute Prolog programs exactly in the same way a typical
Prolog interpreter does. Furthermore some non-logical
feature of real Prolog like the cut is also available.

")
      (demo-loop)
      (format-demo
           "~%Now you will see a Prolog program which solves
the problem of finding paths in a maze. This program uses
typical prolog features like negation as failure and cut.
Notice that you are allowed to specify Prolog programs
using the standard prolog syntax.

")
      (demo-loop)
      (format-demo  "~%Now we call the theorem proving tool.

")
      (demo-loop)
      (format-demo
           "~%The <LOAD THEOREM> button loads the theorem file

")
      (demo-loop)
      (format-display *out-disp*
           "~% Loading theorem ~A ...~%"
           (file-namestring *last-theorem*))
      (catch 'syntax-error (preproc1 *last-theorem*))
      (if (eq 0  *errors-found*)
         (progn
              (setq *theorem-loaded* t)
              (enable-menu-items t)))
      (format-demo
             "~%You can display the clauses using the prolog format.

")
      (demo-loop)
      (setq $output-format$ 'prolog)
      (set-atp-param)
      (format-demo
            "~%Pushing the <List Database> button the 
above formulas will be displayed in prolog format

")
      (demo-loop)
      (list-db)
      (format-demo
           "~%The goal of this program, specified in the
negative clause c28, is to find the path Path from a to g.

")	  
      (demo-loop)
      (new-p-t)
      (format-demo
           "~%Here is the complete proof.

")
      (demo-loop)
      (show-proof)
      (format-demo
           "~%The button <Show Proof Tree> graphically displays
the proof tree of the last solution computed. 
Its shape  puts in evidence the linear-input, depth first 
search strategy used by Prolog.

" )
      (demo-loop)
      (show-proof-tree)
      (format-demo
           "~%Pushing on the labels of the prof tree
you can see the correspondent formula. 
Press continue to close the browser.

")
      (demo-loop)
      (when (windowp *browser-disp*)
             (window-close *browser-disp*))
      (format-demo
           "~%When a prolog theorem is loaded the user
can also interactively query the system, replacing the 
goal clause (in this case c28) with other queries.
To do so we must push the <Prolog Session> button.

")
      (demo-loop)
      
      (setq *last-prolog-query*
            "path(a,g,X)")
      (clear-out)
      (prolog-interpreter)
     (format-demo 
         "~%******* End of the third DEMO ********"))
    

;;; ========================================================


