;;; -*- Mode: LISP; Package: atp; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   atp-demo4.cl
;;; Short Desc: Fourth demo on automated theorem proving
;;;             The source file for the demo theorem is in atp-demo4.th
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   8.9.91 - FB
;;; Author:     Fabio Baj
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================
(in-package :atp)


;;=====================================================================
;; The definition of demo4
;;=====================================================================



(defun start-demo-4 ( )
      (when
               (create-demo-dialog  
                :window-title "ATP Demos"
                :title "Automated Theorem Prover"
                :subtitle "A Fourth Demo"
                :helpfile "atp\\demos\\atp-d4.asc"
                :window *atp-main-window*)
             (progn
                  (setq *atp-demo-running* t)
                  (catch 'stop-demo (main-demo-4))
                  (setq *atp-demo-running* nil))))



(defun main-demo-4 ( )
      (setq *last-theorem*
            (concatenate 'string
                  *pail-directory*
                  "atp\\demos\\atp-d4.th"))
      (clear-out)
      (format-demo
           "~%Here is a fourth demo on automated theorem proving:
It shows the advantages of a complete theorem proving
system with respect to Prolog.
The next example is a prolog program which correctly
defines the ancestor relation, but can not be executed
by a common prolog interpreter, because it is left 
recursive. Since the Prolog search strategy is depth-first,
left-to-right, it goes into an infinite loop on left
recursive definitions.
Here is the bad Prolog program.

")
      (demo-loop)
      (te::load-file
         (setq *th-disp* (open-stream 'text-edit-window *atp-main-window* :output))
         *last-theorem*)
      (format-demo
           "Now we call the theorem proving tool.

")
      (demo-loop)
      (format-demo
           "The <LOAD THEOREM> button loads the theorem file.

")
      (demo-loop)
      (format-display *out-disp*
           "~% Loading theorem ~A ...~%"
           (file-namestring *last-theorem*))
      (catch 'syntax-error (preproc1 *last-theorem*))
      (if (eq 0  *errors-found*)
         (progn
              (setq *theorem-loaded* t)
              (enable-menu-items t)))
      (format-demo
           "Now we try to proof the theorem with the prolog
strategy. You will notice that there is an infinite loop.
In these cases the user can push the <Stop> button
to kill the execution.

")
      (demo-loop)
      (new-p-t)
      (format-demo
           "It is time to face this theorem with a more
complete theorem proving strategy. First, we reload
the previous theorem.

")  
      (demo-loop)
      (load-previous)
      (format-demo 
           "Then, we change the strategy options for this theorem.
We choose the standard strategy. We must also set some 
inference rule to be used instead of the prolog inference rule.

")
      (demo-loop)
      (setq $strategy$ 'standard)
      (setq $neg-resolution$ t)
      (setq $p-resolution$ t)
      (init-standard)
      (set-atp-param)
      (format-demo
           "With a breadth first strategy the system is able
to find the right solution.
Alternate solutions may be generated.

")
      (demo-loop)
      (new-p-t)
      (demo-loop)
      (when (windowp *th-disp*)
             (window-close *th-disp*))
      (format-demo
           "~%******* End of the fourth DEMO ********"))
                                                       
