;;; -*- Mode: LISP; Package: atp; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   atp-demo5.cl
;;; Short Desc: Fifth demo on automated theorem proving
;;;             The source file for the demo theorem is in atp-demo5.th
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   8.9.91 - FB
;;; Author:     Fabio Baj
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================
(in-package :atp)


;;=====================================================================
;; The definition of demo5
;;=====================================================================



(defun start-demo-5 ( )
      (when
               (create-demo-dialog  
                :window-title "ATP Demos"
                :title "Automated Theorem Prover"
                :subtitle "A Fifth Demo"
                :helpfile "atp\\demos\\atp-d5.asc"
                :window *atp-main-window*)
             (progn
                  (setq *atp-demo-running* t)
                  (catch 'stop-demo (main-demo-5))
                  (setq *atp-demo-running* nil))))



(defun main-demo-5 ( )
      (setq *last-theorem*
            (concatenate 'string
                  *pail-directory*
                  "atp\\demos\\atp-d5.th"))
      (clear-out)
      (format-demo
           "~%Here is a fifth demo on automated theorem proving:

ATP systems can be used to find plans, that are 
sequences  of actions to achieve a goal.
The well known  Monkey and Banana 
problems deals with a monkey who wants to eat a banana 
that is suspended from the ceiling of a room. 
He can walk in the room, carring a chair that is in 
the room and clim the chair to reach the banana.
Let us give a look to the input file.
")
      (demo-loop)
      (te::load-file (setq *th-disp*
         (open-stream 'text-edit-window *atp-main-window* :output))
         *last-theorem*)
      (format-demo
           "~%Now we call the theorem proving tool.
")
      (demo-loop)
      (format-demo
           "~%The <LOAD THEOREM> button loads the theorem file.
")
      (demo-loop)
      (format-display *out-disp*
           "~% Loading theorem ~A ...~%"
           (file-namestring *last-theorem*))
      (catch 'syntax-error (preproc1 *last-theorem*))
      (if (eq 0  *errors-found*)
         (progn
              (setq *theorem-loaded* t)
              (enable-menu-items t)))
      (format-demo
           "~%Pushing the <Prove Theorem> button ...
")
      (demo-loop)
      (new-p-t)
      (format-demo
           "~%Here is the complete proof.
")
      (demo-loop)
      (show-proof)
      (format-demo
           "~%Here is the proof tree.
")
      (demo-loop)
      (show-proof-tree)
      (format-demo
           "~%Push <Continue> to close the browser.
") 
      (demo-loop)
      (when (windowp *th-disp*)
             (window-close *th-disp*))
      (when (windowp *browser-disp*)
             (window-close *browser-disp*))
      (format-demo
            "~%******* End of the fifth DEMO ********"))
