;;; -*- Mode: LISP; Package: atp; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   atp-demo6.cl
;;; Short Desc: Second demo on automated theorem proving
;;;             The source file for the demo theorem is in atp-demo6.th
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   8.9.91 - FB
;;; Author:     Fabio Baj
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================
(in-package :atp)



;;=====================================================================
;; The definition of demo6
;;=====================================================================


  
(defun start-demo-6 ( )
      (when
               (create-demo-dialog  
                :window-title "ATP Demos"
                :title "Automated Theorem Prover"
                :subtitle "A Sixth Demo"
                :helpfile "atp\\demos\\atp-d6.asc"
                :window *atp-main-window*)
             (progn
                  (setq *atp-demo-running* t)
                  (catch 'stop-demo (main-demo-6))
                  (setq *atp-demo-running* nil))))



(defun main-demo-6 ( )
      (setq *last-theorem*
            (concatenate 'string
                  *pail-directory*
                  "atp\\demos\\atp-d6.th"))
      (clear-out)
      (format-demo 
           "~%Normally in symbolic logics theorems are proved eclusively
in a syntactic way: if you substitute terms like (x + y)
with foo(y,x) in some formal system  every theorem still holds. 
However, when reasoning about mathematics or some other
well known domain we generally mix symbolic manipulations
with semantic evaluations.
An example is the way in which we solve linear equations:
this process is normally made of  alternate symbolic deductions  
and semantic evaluations.
")
      (demo-loop)
      (format-demo
           "~%For instance the rewriting step
(x * (A + y))  ---->> (x * A) + (x * y)
is a syntactic transformation, based of the axiom
(x * (z + y)) =  (x * z) + (x * y)
But a step like
(x * (5 + 6))  ---->> (x * 11)
directly uses the intended meaning of symbol +
as the addition between numbers, so it is a semantic step.
")
      (demo-loop)
      (format-demo
              "~%The ATP module allows the users to set the semantic
simplification of terms. In this way when a term can be
evaluated it is substituted with its value, with
respect to a standard interpretation. ")
      (demo-loop)
      (format-demo
              "~%The next example is a simple linear equation.
We will solve the problem first without and then with  
semantic simplification of terms.
")
      (demo-loop)
      (te::load-file
         (setq *th-disp*
              (open-stream 'text-edit-window *atp-main-window* :output))
         *last-theorem*)
      (format-demo
             "~%Now we call the theorem proving tool")
      (demo-loop)
       (format-demo
              "~%The <LOAD THEOREM> button loads the theorem file
")
      (demo-loop)
      (format-display *out-disp*
           "~% Loading theorem ~A ...~%"
           (file-namestring *last-theorem*))
      (catch 'syntax-error (preproc1 *last-theorem*))
      (if (eq 0  *errors-found*)
         (progn
              (setq *theorem-loaded* t)
              (enable-menu-items t)))
      (format-demo
            "~%Now we set some parameters for this proof")
      (demo-loop)
      (setq $strategy$ '*sos*)
      (sos-init)
      (setq $neg-resolution$ nil)
      (setq $p-resolution$ nil)
      (setq $resolution$ t)
      (set-atp-param)
      (format-demo
            "~%Pushing the <Prove Theorem> button ...")
      (demo-loop)
      (new-p-t)
      (format-demo
             "~%Here is the complete proof")
      (demo-loop)
      (show-proof)
      (format-demo
               "~%Now we will prove this theorem with semantic 
simplification.First, we must reload the previous file.")  
      (demo-loop)
      (load-previous)
     (format-demo
           "~%Then, we change the  options for this theorem")
      (demo-loop)
      (setq $strategy$ '*sos*)
      (setq $neg-resolution$ nil)
      (setq $p-resolution$ nil)
      (setq $resolution$ t)
      (setq $semantic-simplification$ t)
      (set-atp-param)
      (format-demo
            "~%Pushing the <Prove Theorem> button ...")
      (demo-loop)
      (new-p-t)
      (format-demo
            "~%Here is the proof tree")
      (show-proof-tree)
      (format-demo
            "~%Push <Continue> to close the browser") 
      (demo-loop)
      (when (windowp *browser-disp*)
             (window-close *browser-disp*))
      (when (windowp *th-disp*)
             (window-close *th-disp*))
      (format-demo
             "~%******* End of the fifth DEMO ********"))
