;;; -*- Mode: LISP; Package: atp; Syntax: Common-lisp; -*-

(in-package :atp)

;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   eval2.cl
;;; Short Desc: Functions to perform semantic attachment 
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   8.9.91 - FB
;;; Author:     Fabio Baj
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------

;;---------------------------------------------------
;; sem-re-duce   : TERM  --->  TERM
;; Behavior     : Tries to re-duce a term using the semantic attacchment
;;              : of symbols
;; Side effects : None
;; Example      : (sem-re-duce '(p ($SUM 3 4) x)) = '(p 7 x)

(defun sem-re-duce (term)
  (let ((re-duced-term nil))
    (cond ((atom term)(constant-red term))
	  ((eq '$IF (car term)) (evaluate-if (cadr term)(caddr term) (cadddr term)))
	  (t (let ((args   (mapcar #'sem-re-duce (cdr term))))
	       (cond ((and (is-evaluable (car term))
			  
			   (right-domain  args (get (car term) 'domain) (car term))
			   (not (eq 'undefined
				    (setq re-duced-term
				      (apply (get (car term) 'attached-function) args)))))
		      re-duced-term)
		     (t (cons (car term) args))))))))

(defun constant-red (term)
  (cond ((is-evaluable  term) (funcall (get term  'attached-function)))
	(t term)))


	 
(defun right-domain (args type-list &optional symbol)
  (declare (ignore symbol))
  (cond (( not (eq(length args)(length type-list))) nil)
	
	((and (null args)(null type-list)) t)
	((right-type (car args) (car type-list))
	 (right-domain (cdr args) (cdr type-list) ))))

(defun is-evaluable (x) (member x $evaluable-symbols$))

(defun right-type (item type)
  (cond 
   ((eq type 'integer) (typep item 'float))
  ;; ((eq type 'integer)  (typep   (read-from-string (concatenate 'string item ".0")) 'float))
	
    ((eq type 'bool) (member item '($F $T)))
    ((eq type 'var) (is-int-var item))
    ((eq type 'term) (if (not (is-int-var item)) t))))
  
  ;;	(t (apply (get type 'recogn-function) (list item)))))
  


;;============================================================
;; The following table contains the definitions
;; of built-in evaluable predicates and functions
(setf (get '+ 'domain) '(integer integer))
(setf (get '+ 'codomain) '(integer))
(setf (get '+ 'attached-function) '+)


(setf (get '* 'domain) '(integer integer))
(setf (get '* 'codomain) '(integer))
(setf (get '* 'attached-function) '*)

(setf (get '/ 'domain) '(integer integer))
(setf (get '/ 'codomain) '(integer))
(setf (get '/ 'attached-function) '/)

    
(setf (get '- 'domain) '(integer integer))
(setf (get '- 'codomain) '(integer))
(setf (get '- 'attached-function) '-)

(setf (get '^ 'domain) ' (integer))
(setf (get '^ 'codomain) '(integer))
(setf (get '^ 'attached-function) 'uminus)
(defun uminus (x) (- x))


(setf (get '$IF 'domain) '(bool term term))
(setf (get '$IF 'codomain) '(integer))
(setf (get '$IF 'attached-function) 'evaluate-if)
(defun evaluate-if (condition then-value else-value)
  (let ((cond-value (sem-re-duce condition)))
    (cond ((eq cond-value '$T) (sem-re-duce then-value))
	  ((eq cond-value '$F) (sem-re-duce else-value))
	  (t (list '$IF cond-value (sem-re-duce then-value) 
		   (sem-re-duce else-value))))))

(setf (get '$OR 'domain) '(bool bool))
(setf (get '$OR 'codomain) '(bool))
(setf (get '$OR 'attached-function) 'evaluate-or)
(defun evaluate-or (t1 t2)
 (if (or (eq t1 '$T)(eq t2 '$T)) '$T '$F))

(setf (get '$AND 'domain) '(bool bool))
(setf (get '$AND 'codomain) '(bool))
(setf (get '$AND 'attached-function) 'evaluate-and)
(defun evaluate-and (t1 t2)
  (if (and (eq t1 '$T)(eq t2 '$T)) '$T '$F))


(setf (get '$NOT 'domain) '(bool))
(setf (get '$NOT 'codomain) '(bool))
(setf (get '$NOT 'attached-function) 'evaluate-not)
(defun evaluate-not (t1)
  (if (eq t1 '$T) '$F '$T))

(setf (get '$ID 'domain) '(term term))
(setf (get '$ID 'codomain) '(bool))
(setf (get '$ID 'attached-function) 'evaluate-eq)
(defun evaluate-eq (t1 t2)
  (if  (equal t1 t2) '$T '$F))


(setf (get '$EQ 'domain) '(integer integer))
(setf (get '$EQ 'codomain) '(bool))
(setf (get '$EQ 'attached-function) 'evaluate-eq)


(setf (get '< 'domain) '(integer integer))
(setf (get '< 'codomain) '(bool))
(setf (get '< 'attached-function) 'evaluate-ls)
(defun evaluate-ls (t1 t2)
  (if  (< t1 t2) '$T '$F))


(setf (get '> 'domain) '(integer integer))
(setf (get '> 'codomain) '(bool))
(setf (get '> 'attached-function) 'evaluate-gr)
(defun evaluate-gr (t1 t2)
  (if  (> t1 t2) '$T '$F))

(setf (get '>= 'domain) '(integer integer))
(setf (get '>= 'codomain) '(bool))
(setf (get '>= 'attached-function) 'evaluate-ge)
(defun evaluate-ge (t1 t2)
  (if  (>= t1 t2) '$T '$F))

(setf (get '$READ 'domain) '())
(setf (get '$READ 'codomain) '(term))
(setf (get '$READ 'attached-function) 'evaluate-read)
(defun evaluate-read ()
  (let ((stream (if *interface* (window *dialog-disp*) t)))
    (format-display  stream "?:"))
  (car (tm-x (mkt))))

(setf (get '$WRITE 'domain) '(term))
(setf (get '$WRITE 'codomain) '(bool))
(setf (get '$WRITE 'attached-function) 'evaluate-write)
(defun evaluate-write (x )
 (let ((stream (if *interface* (window *dialog-disp*) t)))
  (format-display stream (tmx-to-string x)))
  '$T)



(setf (get '$NL 'domain) '())
(setf (get '$NL 'codomain) '(bool))
(setf (get '$NL 'attached-function) 'evaluate-nl)
(defun evaluate-nl ()
  (nl)
  '$T)



(setf (get '$BLANK 'domain) '())
(setf (get '$BLANK 'codomain) '(bool))
(setf (get '$BLANK 'attached-function) 'evaluate-bk)
(defun evaluate-bk ()
  (print " ")
  '$T)



 
