;;; -*- Mode: LISP; Package: atp; Syntax: Common-lisp; -*-

(in-package :atp)

;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   outputs2.cl
;;; Short Desc:  Functions for printing clauses, atom and terms
;;;              in a human-readable format
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   8.9.91 - FB
;;; Author:     Fabio Baj
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------



(defvar *max-clause-string-length* 40)


(defmethod clause-to-string ((c clause-class))
   (case $output-format$
	   ((clause) (clause-to-string-clause c))
	   ((sequent) (clause-to-string-sequent c))
	   ((prolog) (clause-to-string-prolog c))))




(defmethod clause-to-string-clause ((c clause-class))
 (let ((renamed-clause (renvar-for-out c)))
    (concatenate 'string 
      (atom-list-to-string-neg (negative-atoms renamed-clause) "|")
      (if (not (or  (null ( negative-atoms renamed-clause))
		    (null (positive-atoms renamed-clause))))
	  " | ")
      (atom-list-to-string (positive-atoms renamed-clause)  "|" ))))
  


(defmethod clause-to-string-sequent ((c clause-class))
  (let ((renamed-clause (renvar-for-out c)))
    (concatenate 'string 
      (atom-list-to-string (negative-atoms renamed-clause)   "&")
      "  =>  " 
      (atom-list-to-string (positive-atoms renamed-clause)  "|" ))))


(defmethod clause-to-string-prolog ((c clause-class) &optional (offset 37))
  (let* ((renamed-clause (renvar-for-out c))
	 (head-string  (concatenate 'string 
			 (atom-list-to-string (positive-atoms renamed-clause)   ";")
			 ":- "))
	 (position ( + 2 offset (length head-string))))
    (concatenate 'string  head-string
		 (and-to-string (negative-atoms renamed-clause) position  ))))
	
(defun and-to-string (atom-list position)
  (cond
   ((null atom-list)   "")  
   (t (and-to-string1 atom-list position))))
   
(defun and-to-string1 (atom-list position &optional (first-atom t))
  (cond
    ((null atom-list) "")
    ((null (cdr atom-list))
     (concatenate 'string 
       (if (not first-atom) (blank-string position) "")
       (tmx-to-string (car atom-list))))
    (t (concatenate 'string 
	 (if (not first-atom)(blank-string position) "")
	 (tmx-to-string (car atom-list) )
	  "," (string #\newline)
	 ( and-to-string1 (cdr atom-list) position nil)))))
   
    
(defun blank-string (n)
  (let ((control-string
	 (concatenate 'string "~" (num-to-string (1- n)) "A")))
    (format nil control-string " ")))

(defun num-to-string (x)
  (format  nil "~A" x))


(defmethod print-obj ((c clause-class) &optional ( stream t ))
   (format stream "~A" (clause-to-string c)))



(defmethod print-object ((c clause-class) ( stream t ))
  (princ (positive-atoms c))
   (princ (negative-atoms c)))
  

(defun output-clause (id &optional stream) 
  (declare (ignore stream))
  (cond (*interface* 
	 (format-display *out-disp* "~5@a   ~30A~A"
		 id (ancestors   (get id 'info))
		 (clause-to-string (eval id))))
	(t 
	 (format t "~5@a   ~30A~A~%" id (ancestors   (get id 'info))
		 (clause-to-string  (eval id))))))
	    


(defun atom-list-to-string (at-list operator)
  (cond
   ((null at-list)   "")
   (t (atom-list-to-string1 at-list operator))))

(defun  atom-list-to-string1 (at-list operator )
  (cond 
   ((null at-list) "")
   ((null (cdr at-list))
    (atm-to-string (car at-list)))
   (t (concatenate 'string 

	(atm-to-string (car at-list) )
	operator  " " 
	( atom-list-to-string1 (cdr at-list) operator )))))



(defun atom-list-to-string-neg (at-list operator)
  (cond
   ((null at-list)   "")
   (t (atom-list-to-string1-neg at-list operator))))

(defun  atom-list-to-string1-neg (at-list operator )
  (cond 
   ((null at-list) "")
   ((null (cdr at-list))
    (concatenate 'string "~" (atm-to-string (car at-list))))
   (t (concatenate 'string 
	"~"
	(atm-to-string (car at-list) )
	operator  " " 
	( atom-list-to-string1-neg (cdr at-list) operator )))))




(defun atm-to-string (a) 
 (concatenate 'string 
   (tmx-to-string a)
   " "))
 

(defun tmx-to-string  (tm)
  (cond ((atom tm)
	 (if  (eq '$- tm)
	     "[]"
	   (if (and (typep tm 'float) (not $semantic-simplification$))
	          (format nil "~A"(floor tm))
	     (format nil "~A"  tm))))
	((null (cdr  tm)) (format nil "~A" (car tm)))
	((member (car tm) $infix-functors$)
	 (concatenate 'string
	   "(" 
	   (tmx-to-string (cadr tm))
	   " " (format nil "~A" (car tm)) " " 
	   (tmx-to-string (caddr tm))
	   ")"))
	((member (car tm) $postfix-functors$)
	 (concatenate 'string
	   "("  
	   (tmx-to-string (cadr tm))
	    " "(format nil "~A" (car tm) ) " "
	   ")"))
	((is-clist tm) 
	 (clist-to-string tm))
	(t (concatenate 'string
	      (format nil "~A" (car tm)) 
	     "("
	     (tmx-l-to-string (cdr tm))
	     ")"))))
		  
(defun print-formula  (fmla)
  (print-tmx fmla)(nl)
  fmla)

(defun tmx-l-to-string  (tl)
  (cond ((null (cdr tl))  (tmx-to-string (car tl)))
	(t    (concatenate 'string 
		(tmx-to-string (car tl))
		","
		(tmx-l-to-string  (cdr tl))))))


;;-----------------------------------------------
;; Routines for printing PROLOG-STYLE LISTS
;;

(defun clist-to-string  (clist)
  (concatenate 'string "[" (clist1-to-string clist)))

(defun clist1-to-string (clist)
  (clist2-to-string  (cdr clist)))

(defun clist2-to-string (clist2  )
 (concatenate 'string
   (tmx-to-string (car clist2))
  (clist3-to-string (cadr clist2)  )))

(defun clist3-to-string (clist3 )
  (cond 
   ((is-clist clist3)
    (concatenate 'string
      ","   (clist1-to-string clist3 )))
   ((eq '$- clist3) "]")
   (t (concatenate 'string
      "|"  (tmx-to-string clist3) "]"))))


;-------------------------------------------
;(defun split-in-lines (string)
;  (cond ((eq $output-format$ 'prolog)
;	 (mapcar 'list (spl  (remove #\space (coerce string 'list)))))
;	((> (length (coerce string 'list)) *max-clause-string-length*) 
;(mapcar 'list (spl (coerce (split-clause-string string) 'list))))
;	(t (list (list string)))))


(defun split-in-lines (string)
  (cond ((eq $output-format$ 'prolog)
	 (mapcar 'list (spl  (coerce  (remove-double #\space string) 'list))))
	(t (list (list (the-first 140 string ))))))

(defun spl (ch-list)
  (let ((buffer nil)
	(result nil))
  (dolist (c ch-list)
    (cond ((eq c #\newline)
	   (push  (coerce (reverse buffer)'string)result)
	   (setq buffer nil))
	  (t (push c buffer))))
  (push (coerce (reverse buffer) 'string) result)
  (reverse result)))


(defun split-clause-string (cs)
  ( coerce  (split-chl(coerce cs 'list)) 'string))
(defun split-chl (chl)
  (let ((first-line nil))
    (if (> (length chl) *max-clause-string-length*)
	(append 
		(dotimes (x *max-clause-string-length* (reverse first-line))(push (nth x chl)first-line))
		'(#\newline)
		(split-chl(nthcdr *max-clause-string-length* chl)))
      chl)))

(defun the-first (n str)
  (let ((result nil)
	(l (coerce str 'list)))
    (if (<= (length l) n)
	str
      (coerce 
       (dotimes (x n (reverse result))
	 (push (nth x l) result))
       'string))))
  
  
 (defun remove-double (ch string)
   (coerce (remove-double1 ch (coerce string 'list) nil) 'string))


(defun remove-double1 (ch lis was-there)
  (cond ((null lis)nil)
	((eq ch (car lis))
	 (if was-there (remove-double1 ch (cdr lis) t)
	   (cons (car lis)(remove-double1 ch (cdr lis) t))))
	(t (cons (car lis)(remove-double1 ch (cdr lis) nil)))))
	 