;;; -*- Mode: LISP; Package: atp; Syntax: Common-lisp; -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   prolog-interpreter.lisp
;;; Short Desc: A Line- Prolog interpreter simulator
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   11.7.94 - PC
;;; Author:     Paolo Cattaneo on Fabio Baj's code
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :atp)



(defparameter *last-prolog-query* nil)



(defmethod parse-string-from-prolog-interpreter (string)
      (let* ((token-list (make-token-list string))
                (goal-pair (goal (cons '<= token-list)))
                (goal-fmla (car goal-pair))
                (error (cdr (cdr goal-pair)))
                (neg-pos (bipart-clause (car (clausify-main goal-fmla))))
                (goal-clause  (renvar-for-internal (make-clause nil (car neg-pos))))
                (answer-lit (cons
                                            '$ans
                                            (collect-integer-vars 
                                                  (negative-atoms goal-clause)))))
          (cond (error 
                          (pop-up-message-dialog *atp-main-window*
                                "ATP Error"
                                (format nil "Syntax error in ~A~%" string)
                                nil "OK")
                           'error)
                      (t  
                         (setq $user-vars$ (collect-vars goal-fmla))
                         (make-clause nil (append (negative-atoms goal-clause)
                                                                (list  answer-lit)))))))
   
   
 


(defun prolog-interpreter ()
      (setq *contradiction* nil)
      (setq $contr$ nil)
      (multiple-value-bind (query other ok)
              (ask-user-for-string
                    "Prolog Session, please enter query"
                    *last-prolog-query*
                    "OK" "Cancel")
             (when (and (string= ok "OK") query (string/= query ""))
                    (setq *last-prolog-query* query)
                    ;                    (loop 
                    (process-pending-events)
                    (setq $contr$ nil)
                    (restore-r-id)
                    (setq $rules$ (cdr $program$))
                    (setq $goal-stack$ nil) 
                    (setq query
                          (parse-string-from-prolog-interpreter query))
                    ;;;                         (if (not (eq 'error query))
                    ;;;                            (return))
                    ;;;                         (if (and (atom (car (negative-atoms query)))
                    ;;;                                       (equal
                    ;;;                                             "EXIT"
                    ;;;                                             (string-upcase (symbol-name (car (negative-atoms query))))))
                    ;;;                            (return)))
                    (when (not (eq 'error query))
                           (format-display *out-disp*
                                "~%Searching solutions ...~%")
                           (store (prolog-sem-red query) '(sos))
                           (loop
                               (process-pending-events)
                               (let* ((x-y (prolog-choose))
                                         (x (car x-y))
                                         (y (cadr x-y)))
                                   (when (member nil x-y) 
                                          (return (format-display *out-disp* " no")))
                                   (make-deductions x y)
                                   (if (contradiction) 
                                      (progn
                                           (setq *contradiction* t)
                                           (if  (more-solutions) 
                                              (setq $contr$ nil)
                                              (return 'contradiction))))))))))
