;;; -*- Mode: LISP; Package: atp; Syntax: Common-lisp; -*-

(in-package :atp)

;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   renvar.cl
;;; Short Desc: functions for variable renaming
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   8.9.91 - FB
;;; Author:     Fabio Baj
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------


(defmethod renvar-for-internal ((clause clause-class))
  (let* ((vlist (collect-vars (cons (positive-atoms clause) (negative-atoms clause))))
	 (tmp (rename-variables  (cons (positive-atoms clause) (negative-atoms clause))
				 vlist)))
    (make-clause (car tmp)
                   (cdr tmp))))
		  
;(defmethod renvar-for-internal ((clause clause-class))
;  (let* ((vlist (collect-vars 
;		 (list  (positive-atoms clause) (negative-atoms clause) (answer clause))))
;	 (tmp (rename-variables  (list  (positive-atoms clause) 
	;;			       (negative-atoms clause)
	;			       (answer clause))
	;			 vlist)))
   ; (make-clause (car tmp)
   ;                (cadr tmp)(caddr tmp))))
		  

(defmethod internal-renvar (null-clause)
  (declare (ignore null-clause))
  nil)

(defmethod internal-renvar ((clause clause-class))
   (let* ((vlist (collect-integer-vars (cons (positive-atoms clause) (negative-atoms clause))))
	 (tmp (rename-variables  (cons (positive-atoms clause) (negative-atoms clause))
				 vlist)))
    (make-clause (car tmp)
                   (cdr tmp))))
		  


(defmethod renvar-for-out ((clause clause-class))
  (let ((tmp (ren-vars-for-out (cons (positive-atoms clause) 
				     (negative-atoms clause)))))
    (make-clause (car tmp)
		 (cdr tmp))))
	


(defun ren-vars-for-out (sexp)
   (init-out-var)
  (let ((vlist (collect-integer-vars sexp)))
    (rvfo sexp vlist)))

(defun rvfo (sexp vlist)
   (cond ((null vlist) sexp)
	  (t (rvfo (subst (new-out-var) (car vlist) sexp) (cdr vlist)))))
  


(defun rename-variables (sexp vlist)
   (cond ((null vlist) sexp)
	  (t (rename-variables
              (subst (new-int-var) (car vlist) sexp) (cdr vlist)))))
  
(defun collect-integer-vars (sexp)
  (remove-duplicates  (collect-out-vars sexp)))

(defun collect-out-vars (sexp)
   (cond ((null sexp) nil)
         ((atom sexp) (cond ((is-int-var sexp) (list sexp))))
         (t (append (collect-out-vars (car sexp))
                    (collect-out-vars (cdr sexp))))))

(defun collect-vars (sexp)
  (remove-duplicates (  collect-v1 sexp)))

(defun collect-v1 (sexp)
   (cond ((null sexp) nil)
         ((atom sexp) (cond ((is-variable sexp) (list sexp))))
         (t (append (collect-v1 (car sexp))
                    (collect-v1 (cdr sexp))))))

(defun is-int-var (x) (typep x 'integer))
			    			    
(defun new-int-var () (setq n-int-var (+ 1 n-int-var)))
(defun new-out-var ()
   (cond  
          ((null t-out-var) (setq t-out-var out-var)
                            (setq n-out-var (+ 1 n-out-var))))
   (cond ((eq n-out-var 0) (pop t-out-var))
         (t (build (pop t-out-var) n-out-var))))

     
(defun init-out-var ()   
  (if (or  $prolog-mode$ (eq $output-format$  'prolog))
      (setq out-var '("X" "Y" "Z" "T" "U" "W" "V"))
    (setq out-var '(x y z t u w v)))
  (setq t-out-var out-var)                       
  (setq n-out-var 0))               


  
      