;;; -*- Mode: LISP; Package: atp; Syntax: Common-lisp; -*-

(in-package :atp)

;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   tree-dvi.cl
;;; Short Desc: routines for proof trees
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   8.9.91 - FB
;;; Author:     Fabio Baj
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------



(defun trace-proof-i (  )
  (let ((r-id (root-id))) 
    (cond (r-id (trace-rule-i r-id  ))
	  (t (print 'Consistent )))))

(defun trace-rule-i (id  )
  (mapcar 
   #'(lambda (x) ( output-clause x )) 
   (sort 
    (delete 
     'cut 
     (delete 
      'axiom 
      (delete 
       'sos  
       (remove-duplicates (expand (list id)))))) 
    #'clause-id<)) nil)



(defun clause-id< (a1 a2)
  (<
  (read-from-string
   (string-left-trim '(#\C) a1))
   (read-from-string
  (string-left-trim '(#\C) a2))))


(defun root-id ()
  $contr$)
	   
 
(defun get-ancestors (id)
  (cond ((member id  '(cut sos axiom c0)) nil)
	(t
	 (let (( anc (ancestors (get id 'info))))
	  ; (print anc)
	   (cond ((null (cdr anc)) nil)
		 ((null (cdddr anc))
		  (cond ((member (cadr anc ) '( simp hyper-p-resolution))
			 (cons (car anc) (caddr anc)))
			(t 
			 (cons (car anc) (cddr anc)))))
		 (t (if (eq (cadr anc ) 'hyper-p-resolution)
			(append (list  (car anc))
				(caddr anc)
				(car (cddddr anc)))
		      (append (list  (car anc) (caddr anc))
			      (car (cddddr anc))))))))))
	     


(defun expand (id-list)
  (expand1 id-list nil))



(defun expand1 (id-list res)
  (cond ((or (null id-list) (null (car id-list)))
               (reverse res))
              (t (let ((ancs (if (member (car id-list ) res)
                                         nil
                                         (get-ancestors (car id-list)))))
                      (expand1 (remove-duplicates 
                                              (append ancs (cdr id-list)))
                           (cons (car id-list ) res))))))



(defun proof-tree1 (id)
      (cond ((null id) nil)
                  ((atom id)
                   (let ((ancs (get-ancestors id)))
                       (if (or (null ancs) (member id *done*))
                          id
                          (progn
                               (setq *done* (cons id *done*))
                               (cons id (proof-tree1 ancs ))))))
                  (t (remove 'nil (mapcar #'proof-tree1 id)))))
  
  
(defmethod out-symbol ((cl clause-class)   )
  (print-obj cl) ) 

(defmethod label ((tree tree))
  (format nil "~A" (content tree)))

(defun proof-tree (n)
     (declare (ignore n))
     (setq *done* nil)
     (setf *browser-disp*
             (open-dialog () 'atp-browser *atp-main-window* :pop-up-p nil
                  :user-scrollable nil :user-closable nil :user-resizable t
                  :title (concatenate 'string (file-namestring *last-theorem*)
                              " :  Proof Tree")
                  :starting-tree (sexpr-to-tree (proof-tree1 (root-id))))))





#|
   


(defmethod inspect-node :after ((tree tree) where)
  (let ((message (clause-to-string-tree (content tree))))
    (message-dialog message :size (make-point 300 45) :position where)))
    


(defmethod show-clause ((item tree) (b browser))
  (if (not(or  (eq (content item) 'sos)(eq (content item) 'axiom)))
      (output-clause (content item))))

(defmethod clause-to-string-tree (clause-id)
  (if (not(or (eq clause-id  'cut) (eq clause-id  'sos)(eq clause-id 'axiom)))
      (clause-to-string (eval clause-id))
    (string clause-id)))

|#