(in-package :bp)

(defparameter *bp-main-window* nil)
(defparameter *bp-output-window* nil)
(defparameter *out-dialog* nil)

(defparameter *topology-window* nil)
(defparameter *weights-window* nil)
(defparameter *errors-window* nil)
(defparameter *net-graphics* nil)



(defparameter *tolerance* 0.1)
(defparameter *max-trials* 500)
(defparameter *w-max* 5)
(defparameter *a-max* 1)
(defparameter *l-rate* 0.5)
(defparameter *momentum* 0.9)
(defparameter *hidden-neurons* nil)

(defparameter *default-tolerance* *tolerance*)
(defparameter *default-max-trials* *max-trials*)
(defparameter *default-w-max* *w-max*)
(defparameter *default-a-max* *a-max*)
(defparameter *default-l-rate* *l-rate*)
(defparameter *default-momentum* *momentum*)



(defparameter *stop* nil)
(defparameter *total-count* 0)
(defparameter *performance* 0)
(defparameter *error-value* 0)
(defparameter *pausing* nil)
(defparameter *show-test-button* nil)
(defparameter *show-cont-button* nil)
(defparameter *show-closed* nil)
(defparameter *show-done* nil)
(defparameter *learn-done* nil)
(defparameter *not-stable* nil)
(defparameter *not-stable-continue* nil)



(defparameter *training-data* nil)
(defparameter *topology* nil)
(defparameter *graphics* nil)
(defparameter *show-topology* nil)
(defparameter *show-errors* nil)
(defparameter *show-weights* nil)
(defparameter *current-net* nil)
(defparameter *connection-p* nil)
(defparameter *auto-update* nil)



(defvar *init-x* nil)
(defvar *init-y* nil)
(defvar *init-y-err* nil)
(defvar *last-position* nil)
(defvar *last-position-err* nil)
(defvar *step-x* nil)
(defvar *step-y* nil)
(defvar *step-y-err* nil)



;(defparameter *demo-net*)
;(defparameter *demo-in-execution* nil)
;(defparameter *topology* '((output-layer 4) (hidden-layer1 2) (input-layer 4)))
;(defparameter *net-display-exit-button* nil)
;(defparameter *number-of-demos* 1)


(defclass bp-main-dialog (dialog)
      ())

(defmethod bring-window-to-front :after ((bd bp-main-dialog))
        (in-package :bp)
        (set-bp-menubar)
     (setf (stream-title *lisp-main-window*) "PAIL - Back Propagation module"))

(defmethod window-close ((imd bp-main-dialog))
      (when (yes-or-no-p "Do you really want to
quit the BP module")
          (remove-from-window-menu (object-name *bp-main-window*))
          (close imd)
          (setf imd nil)
          (quit-bp)))


(defmethod redisplay-window :after ((d bp-main-dialog) &optional box)
      (in-package :bp))



(defparameter *input-set* nil)
(defparameter *target-set* nil)
(defparameter *input-set-editor* nil)
(defparameter *target-set-editor* nil)
(defparameter *current-set-file* nil)



(defclass bp-net-dialog (dialog)
       ())

(defclass bp-bitmap-window (bitmap-window)
       ())

(defclass bp-bitmap-pane (bitmap-pane)
       ())

(defmethod default-pane-class ((w bp-bitmap-window))
      'bp-bitmap-pane)



(defmethod resize-window ((d bp-net-dialog) position)
      (let ((width (box-width (window-interior d)))
              (height (box-height (window-interior d))))
          (set-dialog-item-box (first (dialog-items d))
                (make-box 0 0 (round (/ width 4)) 25))
          (set-dialog-item-box (second (dialog-items d))
                (make-box (round (/ width 4)) 0 (round (/ (* 2 width) 4)) 25))
          (set-dialog-item-box (third (dialog-items d))
                (make-box (round (/ (* 2 width) 4)) 0 (round (/ (* 3 width) 4)) 25))
          (set-dialog-item-box (fourth (dialog-items d))
                (make-box (round (/ (* 3 width) 4)) 0 width 25))
          (setf (window-exterior (first (windows d)))
                    (make-box 0 25 width height))))



(defclass bpw-net-dialog (dialog)
       ())

(defclass bpw-bitmap-window (bitmap-window)
       ())

(defclass bpw-bitmap-pane (bitmap-pane)
       ())

(defmethod default-pane-class ((w bpw-bitmap-window))
      'bpw-bitmap-pane)


(defmethod resize-window ((d bpw-net-dialog) position)
      (let ((width (box-width (window-interior d)))
              (height (box-height (window-interior d))))
          (set-dialog-item-box (first (dialog-items d))
                (make-box 0 0 (round (/ width 2)) 25))
          (set-dialog-item-box (second (dialog-items d))
                (make-box (round (/ width 2)) 0 width 25))
          (setf (window-exterior (first (windows d)))
                    (make-box 0 25 width height))))



