;;; -*- Mode: LISP; Package: BP; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   bp-graph.lsp
;;; Short Desc: graphics for neural networks
;;; Version:    1.0
;;; Status:     Experimental
;;; Last Mod:   4.2.92 - TW
;;; Author:     Thomas Wehrle
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;


;;; --------------------------------------------------------------------------
;;; Change History:
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================

(in-package :bp)




(defmethod open-activation-display ((graphics net-graphics)
                                                                        &key
                                                                        (arrows-p t)
                                                                        (title "Topology")
                                                                        (left 100)
                                                                        (bottom 100)
                                                                        (width (a-disp-width graphics))
                                                                        (height (a-disp-height graphics))
                                                                        (parent *bp-main-window*))
      (setf (aa-disp graphics)
                (open-dialog
                      (list
                         (make-dialog-item :widget 'button
                                :name ':close
                                :title "Close"
                                :font (make-font :modern nil 16 '(:bold))
                                :box (make-box 0 0 (round (/ width 4)) 25)
                                :set-value-fn '(lambda (&rest x) (show-network-topology) t))
                         (make-dialog-item :widget 'button
                                :name ':test-net
                                :title "Test Net"
                                :font (make-font :modern nil 16 '(:bold))
                                :box (make-box (round (/ width 4)) 0 (round (/ (* 2 width) 4)) 25)
                                :set-value-fn '(lambda (&rest x) (test-net)))
                         (make-dialog-item :widget 'button
                                :title "Continue"
                                :name ':continue
                                :available-p nil
                                :font (make-font :modern nil 16 '(:bold))
                                :box (make-box (round (/ (* 2 width) 4)) 0 (round (/ (* 3 width) 4)) 25)
                                :set-value-fn '(lambda (&rest x) (test-continue)))
                         (make-dialog-item :widget 'button
                                :title "Help"
                                :name ':help
                                :available-p nil
                                :font (make-font :modern nil 16 '(:bold))
                                :box (make-box (round (/ (* 3 width) 4)) 0 width 25)))
                      'bp-net-dialog *bp-main-window*
                      :pop-up-p nil
                      :user-closable nil :user-scrollable nil :user-resizable t
                      :title title
                      :visible-box (make-box 0 0 width (+ 60 height))))
      (setf (a-disp graphics)
                (open-dialog () 'bp-bitmap-window (aa-disp graphics)
                      :user-closable nil :user-scrollable t
                      :user-movable nil :user-resizable nil :user-resizable nil
                      :window-exterior (make-box 0 25
                                                               (a-disp-width graphics)
                                                               (+ 60 (a-disp-height graphics)))))
      (show-activities graphics :arrows-p arrows-p)
      (aa-disp graphics))
                          


(defmethod open-weight-display ((graphics net-graphics)
                                                                  &key
                                                                  (title "Weights")
                                                                  (left 100)
                                                                  (bottom 100)
                                                                  (width (w-disp-width graphics))
                                                                  (height (w-disp-height graphics))
                                                                  (parent *bp-main-window*))
      (setf (ww-disp graphics)
                (open-dialog
                      (list
                         (make-dialog-item :widget 'button
                                :name ':close
                                :title "Close"
                                :font (make-font :modern nil 16 '(:bold))
                                :box (make-box 0 0 (round (/ width 2)) 25)
                                :set-value-fn '(lambda (&rest x) (show-bp-weights) t))
                         (make-dialog-item :widget 'button
                                :title "Help"
                                :name ':help
                                :available-p nil
                                :font (make-font :modern nil 16 '(:bold))
                                :box (make-box (round (/ width 2)) 0 width 25)))
                      'bpw-net-dialog *bp-main-window*
                      :pop-up-p nil
                      :user-closable nil :user-scrollable nil :user-resizable t
                      :title title
                      :visible-box (make-box 0 0 width (+ 60 height))))
      (setf (w-disp graphics)
                (open-dialog () 'bpw-bitmap-window (ww-disp graphics)
                      :user-closable nil :user-scrollable t
                      :user-movable nil :user-resizable nil :user-resizable nil
                      :window-exterior (make-box 0 25
                                                               (w-disp-width graphics)
                                                               (+ 60 (w-disp-height graphics)))))
      (show-weights graphics)
      (ww-disp graphics))



(defun find-definition (node graphics)
      (dolist (layers (a-positions graphics))
            (let ((def (dolist (def layers)
                                   (when (equal (third def) node)
                                          (return def)))))
                (when def
                       (return def)))))



(defmethod show-activities ((graphics net-graphics)
                                                       &key (arrows-p t))
      (let* ((box-width (a-box-width graphics))
                (box-middle (/ box-width 2))
                (max (a-max graphics))
                (disp (a-disp graphics))
                (net-counter 0)
                (old-colorb (background-color disp))
                (old-color (foreground-color disp)))
          (erase-contents-box disp (visible-box disp))
          (draw-string-in-box disp "input" 0 5
               (make-box 0 5 (a-disp-width graphics) 25)
               :center :top nil)
          (draw-string-in-box disp "output" 0 6
               (make-box 0
                      (- (a-disp-height graphics) 10)
                      (a-disp-width graphics)
                      (+ (a-disp-height graphics) 10))
               :center :top nil)
          (dolist (layers (a-positions graphics))
                (dolist (def layers)
                      (let* ((x (round (first def)))
                                (y (+ 10 (round (second def))))
                                (activity (activation (third def)))
                                (width (round (* (sqrt (/ activity max)) box-width)))
                                (overflow nil))
                          (when (> width box-width)
                                 (setf width box-width)
                                 (setf overflow t))
                          (incf net-counter)
                          (when (eq def (first layers))
                                 (draw-string-in-box disp (write-to-string net-counter)
                                      0 (length (write-to-string net-counter))
                                      (make-box (- x 30) y (- x 10) (+ y (max 12 box-width)))
                                      :right :center nil))
                          (when (eq def (car (last layers)))
                                 (draw-string-in-box disp (write-to-string net-counter)
                                      0 (length (write-to-string net-counter))
                                      (make-box (+ x box-width 10) y (+ x box-width 30) (+ y (max 12 box-width)))
                                      :left :center nil))
                          (draw-box disp (make-box x y (+ x box-width) (+ y box-width)))
                          (setf (foreground-color disp) grey)
                          (fill-box disp (make-box (1+ x) (1+ y) (+ x width) (+ y width)))
                          (setf (foreground-color disp) old-color)
                          (when overflow
                                 (draw-circle disp
                                      (make-position
                                             (+ x box-middle)
                                             (+ y box-middle))
                                      3)))))
          (when arrows-p
                 (dolist (layers (a-positions graphics))
                       (when (eq layers (second (a-positions graphics)))
                              (setf (foreground-color disp) red))
                       (when (eq layers (third (a-positions graphics)))
                              (setf (foreground-color disp) blue))
                       (dolist (def layers)
                             (when (in-connections (third def))
                                    (let* ((x2 (round (+ (first def) box-middle)))
                                              (y2 (+ 10 (round (second def)))))
                                        (dolist (in-node (get-from-nodes (third def)))
                                              (let* ((definition (find-definition in-node graphics))
                                                        (x1 (round (+ (first definition) box-middle)))
                                                        (y1 (+ 10 (round (+ (second definition) box-width)))))
                                                  (draw-line disp
                                                       (make-position x1 y1)
                                                       (make-position x2 y2)))))))
                       (setf (foreground-color disp) old-color)))
          (show-activities-net-specifics graphics (net graphics))))



(defmethod event :after ((pane bp-bitmap-pane)
                                                 (event (eql mouse-left-down))
                                                 (shift t) (data t) (time t))
      (let ((width (a-box-width *net-graphics*)))
          (dolist (layers (a-positions *net-graphics*))
                (dolist (def layers)
                      (let* ((x (round (first def)))
                                (y (+ 10 (round (second def))))
                                (n (third def)))
                          (when (inside-box-p
                                              (cursor-position pane)
                                              (make-box x y (+ x width) (+ y width)))
                                 (node-info n)
                                 (return)))))))



(defmethod show-activities-net-specifics ((graphics net-graphics) (net bp-net-class))
      (let ((width (+ (a-box-width graphics) 4)))
          (dolist (seq-name (rest (get-node-seq-names net)))
                (let ((def (find-definition (first (get-node-seq net seq-name)) graphics)))
                    (draw-box (a-disp graphics)
                         (make-box 
                                (round (- (first def) 2))
                                (round (- (+ 10 (second def)) 2))
                                (+ (round (- (first def) 2)) width)
                                (+ (round (- (+ 10 (second def)) 2)) width)))))))



(defmethod show-weights ((graphics net-graphics))
      (let* ((box-width (w-box-width graphics))
                (box-middle (round (/ box-width 2)))
                (max (w-max graphics))
                (origin (- (border graphics) box-width 3))
                (origin+1 (1+ origin))
                (origin-1 (1- origin))
                (origin-3 (- origin 3))
                (disp (w-disp graphics))
                (old-color (foreground-color disp))
                (actual-color))
          (erase-contents-box disp (visible-box disp))
          (draw-line disp
               (make-position 60 15)
               (make-position 60 (+ 20 (* (matrix-len graphics) 20))))
          (draw-line disp
               (make-position 60 (+ 20 (* (matrix-len graphics) 20)))
               (make-position
                      (+ 70 (* (matrix-len graphics) 20)) 
                      (+ 20 (* (matrix-len graphics) 20))))
          (draw-string-in-box disp "To"
               0 2
               (make-box
                      10
                      (round (/ (w-disp-height graphics) 2))
                      30
                      (+ (round (/ (w-disp-height graphics) 2)) 20))
               :left :top nil)                                            
          (draw-string-in-box disp "From"
               0 4
               (make-box
                      (round (/ (w-disp-width graphics) 2))
                      (- (w-disp-height graphics) 30)
                      (+ (round (/ (w-disp-width graphics) 2)) 50)
                      (- (w-disp-height graphics) 10))
               :left :bottom nil)                    
          (dotimes (i (matrix-len graphics))
                (dotimes (j (matrix-len graphics))
                      (let ((def (aref (w-positions graphics) i j)))
                          (when (= i 0)
                                 (draw-string-in-box disp
                                      (write-to-string (1+  j))
                                      0 (length (write-to-string (1+  j)))
                                      (make-box
                                             (+ 70 (* j 20))
                                             (+ 30 (* (matrix-len graphics) 20))
                                             (+ 88 (* j 20))
                                             (+ 50 (* (matrix-len graphics) 20)))
                                      :center :bottom nil))                                            
                          (when (= j 0)
                                 (draw-string-in-box disp
                                      (write-to-string (1+  i))
                                      0 (length (write-to-string (1+  i)))
                                      (make-box
                                             0
                                             (+ 15 (* i 20))
                                             50
                                             (+ 35 (* i 20)))
                                      :right :top nil))                                            
                          (when def
                                 (let* ((value (weight (third def)))
                                           (width (round (* (/ (abs value) max) box-width)))
                                           (overflow nil))
                                     (when (> width box-width)
                                            (setf overflow t)
                                            (setf width box-width))
                                     (if (member
                                                 (from-node (third def))
                                                 (second (node-seqs *current-net*)))
                                        (setf (foreground-color disp) red)
                                        (setf (foreground-color disp) blue))
                                     (if (minusp value)
                                        (progn
                                             (draw-box disp
                                                  (make-box
                                                         (first def)
                                                         (second def)
                                                         (+ (first def) width)
                                                         (+ (second def) width)))
                                             (when overflow
                                                    (draw-circle disp
                                                         (make-position
                                                                (+ (first def) box-middle)
                                                                (+ (second def) box-middle))
                                                         3)))
                                        (progn
                                             (fill-box disp
                                                  (make-box
                                                         (first def)
                                                         (second def)
                                                         (+ (first def) width)
                                                         (+ (second def) width)))
                                             (when overflow
                                                    (setq actual-color (foreground-color disp))
                                                    (setf (foreground-color disp) white)
                                                    (draw-circle disp
                                                         (make-position  ; en blanco !!!!!
                                                                (+ (first def) box-middle)
                                                                (+ (second def) box-middle))
                                                         3)
                                                    (setf (foreground-color disp) actual-color))))
                                     (setf (foreground-color disp) old-color)))))))) ;2



(defmethod event :after ((pane bpw-bitmap-pane)
                                                 (event (eql mouse-left-down))
                                                 (shift t) (data t) (time t))
      (let* ((width (w-box-width *net-graphics*))
                (box-width (a-box-width *net-graphics*))
                (box-middle (/ box-width 2)))
          (dotimes (i (matrix-len *net-graphics*))
                (dotimes (j (matrix-len *net-graphics*))
                      (let ((def (aref (w-positions *net-graphics*) i j)))
                          (when def
                                 (let* ((x (first def))
                                           (y (second def))
                                           (c (third def)))
                                           (when (inside-box-p
                                                             (cursor-position pane)
                                                             (make-box x y (+ x width) (+ y width)))
                                                  (when *show-topology*
                                                  (let ((in-node (find-definition (from-node c) *net-graphics*)))
                                                      (dolist (layers (a-positions *net-graphics*))
                                                            (dolist (def2 layers)
                                                                  (dolist (in-c (in-connections (third def2)))
                                                                        (when (eq in-c c)
                                                                               (let* ((out-node (find-definition (third def2) *net-graphics*))
                                                                                         (old-color (foreground-color (a-disp *net-graphics*)))
                                                                                         (x2 (round (+ (first out-node) box-middle)))
                                                                                         (y2 (+ 10 (round (second out-node))))
                                                                                         (x1 (round (+ (first in-node) box-middle)))
                                                                                         (y1 (+ 10 (round (+ (second in-node) box-width)))))
                                                                                   (when (eq layers (second (a-positions *net-graphics*)))
                                                                                          (setf (foreground-color (a-disp *net-graphics*)) blue))
                                                                                   (when (eq layers (third (a-positions *net-graphics*)))
                                                                                          (setf (foreground-color (a-disp *net-graphics*)) red))
                                                                                   (draw-line (a-disp *net-graphics*)
                                                                                        (make-position x1 y1)
                                                                                        (make-position x2 y2))
                                                                                   (setf (foreground-color (a-disp *net-graphics*)) old-color)
                                                                                   (return))))))))
                                                  (connection-info c)
                                                  (return)))))))))



(defmethod event :after ((pane bpw-bitmap-pane)
                                                 (event (eql mouse-left-up))
                                                 (shift t) (data t) (time t))
      (when *show-topology*
      (let* ((width (w-box-width *net-graphics*))
                (box-width (a-box-width *net-graphics*))
                (box-middle (/ box-width 2))
                (old-color (foreground-color (a-disp *net-graphics*))))
          (dotimes (i (matrix-len *net-graphics*))
                (dotimes (j (matrix-len *net-graphics*))
                      (let ((def (aref (w-positions *net-graphics*) i j)))
                          (when def
                                 (let* ((x (first def))
                                           (y (second def))
                                           (c (third def)))
                                           (when (inside-box-p
                                                             (cursor-position pane)
                                                             (make-box x y (+ x width) (+ y width)))
                                                  (let ((in-node (find-definition (from-node c) *net-graphics*)))
                                                      (dolist (layers (a-positions *net-graphics*))
                                                            (dolist (def2 layers)
                                                                  (dolist (in-c (in-connections (third def2)))
                                                                        (when (eq in-c c)
                                                                               (let* ((out-node (find-definition (third def2) *net-graphics*))
                                                                                         (x2 (round (+ (first out-node) box-middle)))
                                                                                         (y2 (+ 10 (round (second out-node))))
                                                                                         (x1 (round (+ (first in-node) box-middle)))
                                                                                         (y1 (+ 10 (round (+ (second in-node) box-width)))))
                                                                                   (when (eq layers (second (a-positions *net-graphics*)))
                                                                                          (setf (foreground-color (a-disp *net-graphics*)) red))
                                                                                   (when (eq layers (third (a-positions *net-graphics*)))
                                                                                          (setf (foreground-color (a-disp *net-graphics*)) blue))
                                                                                   (draw-line (a-disp *net-graphics*)
                                                                                        (make-position x1 y1)
                                                                                        (make-position x2 y2))
                                                                                   (setf (foreground-color (a-disp *net-graphics*)) old-color)
                                                                                   (return)))))))
                                                  (return))))))))))


(defun node-info (node)
      (format-display *bp-output-window*
           "~%Activation is ~a~%"
           (activation node)))



(defun toggle-node (node)
      (setf (activation node) (- 1.0 (activation node)))
      (setf (output node) (compute-output node)))



(defun connection-info (connection)
      (format-display *bp-output-window*
           "~%Weight is ~a~%"
           (weight connection)))


;;; ========================================================================
;;; END OF FILE
;;; ========================================================================
