;;; -*- Mode: LISP; Package: bp; Syntax: Common-lisp; -*-
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   bp-init.lisp
;;; Short Desc: general user interface for the  bptool
;;;            
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   4. april 1992 - PC
;;; Author(s):  Paolo Cattaneo
;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;; 
;;; 
;;; --------------------------------------------------------------------------

(in-package :bp)

(defun bp()
     (setq pail-lib::*bp-module-loaded* t)
     (in-package :bp)
     (create-bp-window)
     (set-bp-menubar)
     ;  (set-help-bp)
     )



(defun set-help-bp ()
  (set-help :general "bp\\help\\bp-desc.hlp"))
            


(defun create-bp-window ()
      (let* ((*number-of-buttons* 4)           
                (box (clipping-box *lisp-main-window*))
                (h-indent (round (* 0.2 (box-width box))))
                (v-indent (round (* 0.2 (- (box-height box) 20))))
                (h-size (- (box-width box) (* 2 h-indent)))
                (button-width (round (/ h-size *number-of-buttons*)))
                (button-height 25)
                (out-dialog nil)
                (height (box-height (clipping-box *lisp-main-window*)))
                (width (box-width (clipping-box *lisp-main-window*))))
          (unless *bp-main-window*
              (setq *bp-main-window*
                   (open-dialog ()
                        'bp-main-dialog *lisp-main-window* :pop-up-p nil
                        :title "BP Main" :name ':bp-main
                        :background-color (make-rgb :red 0 :green 128 :blue 128) 
                        :window-exterior (clipping-box *lisp-main-window*))))
         (add-to-window-menu
               (stream-title *bp-main-window*)
               (object-name *bp-main-window*))
      (setq out-dialog (setq *out-dialog*
            (open-dialog
                  (list
                           (make-dialog-item :widget 'button
                                 :title "Help"
                                  :available-p nil
                                 :font (make-font :modern nil 16 '(:bold))
                                 :set-value-fn '(lambda (item new old) (bp-help))
                                 :box (make-box
                                       0
                                       0
                                       button-width
                                       button-height))
                           (make-dialog-item :widget 'button
                                 :title "Reinitialize"
                                 :available-p nil
                                 :name ':reinitialize
                                 :font (make-font :modern nil 16 '(:bold))
                                 :set-value-fn '(lambda (item new old) (reinitialize))
                                 :box (make-box
                                       (round (/ (- (box-width (window-interior *bp-main-window*)) (* 2 h-indent)) 4))
                                       0
                                       (* 2 (round (/ (- (box-width (window-interior *bp-main-window*)) (* 2 h-indent)) 4)))
                                       button-height))
                           (make-dialog-item :widget 'button
                                 :title "Learn"
                                 :name ':learn
                                 :available-p nil
                                 :font (make-font :modern nil 16 '(:bold))
                                 :set-value-fn '(lambda (item new old) (start-stop-learn))
                                 :box (make-box
                                       (* 2 (round (/ (- (box-width (window-interior *bp-main-window*)) (* 2 h-indent)) 4)))
                                       0
                                       (* 3 (round (/ (- (box-width (window-interior *bp-main-window*)) (* 2 h-indent)) 4)))
                                       button-height))
                           (make-dialog-item :widget 'button
                                 :title "Training Set"
                                 :name ':load-training-set
                                 :available-p t
                                 :font (make-font :modern nil 16 '(:bold))
                                 :set-value-fn '(lambda (item new old) (load-training-set))
                                 :box (make-box
                                       (* 3 (round (/ (- (box-width (window-interior *bp-main-window*)) (* 2 h-indent)) 4)))
                                       0
                                       (- (box-width (window-interior *bp-main-window*)) (* 2 h-indent))
                                       button-height)))
                  'dialog *bp-main-window*
                  :pop-up-p nil
                  :title "BP: Output"
                  :user-closable nil
                  :user-shrinkable t
                  :user-resizable nil
                  :user-scrollable nil
                  :user-movable t
                  :window-border :dialog-box
                  :window-interior
                  (make-box 
                         h-indent 
                         v-indent
                         (- (box-width (window-interior *bp-main-window*)) h-indent)
                         (- (box-height (window-interior *bp-main-window*)) v-indent)))))
         (setq *bp-output-window*
               (open-stream 'text-edit-window out-dialog :output
                     :title "Neural Networks: Back Propagation"
                     :user-closable nil :user-resizable nil
                     :user-scrollable t :user-movable nil :user-shrinkable nil 
                     :font (make-font :modern nil 14)
                     :name ':bp-output
                     :window-exterior
                     (make-box
                             0 25
                             (box-width (visible-box out-dialog))
                             (box-height (visible-box out-dialog)))))))



(defvar *bp-file-menu* nil)

(defun bp-new ()
     (:new *bp-main-window*))


(defun bp-close ()
     (let ((window (front-window *bp-main-window*)))
         (if window (window-close window)
            (window-close *bp-main-window*))))

(defun bp-print ()
     (:print (front-window *bp-main-window*)))

(defun bp-open ()
      (:open *bp-main-window*))                  
             
(defun bp-save ()
      (:save *bp-main-window*))                  
             
(defun bp-save-as ()
      (:save-as *bp-main-window*))                


(setq *bp-file-menu*
     (make-menu-item :title "~File" :value
           (open-menu 
                (list 
                   (make-menu-item :title "~New"
                         :value 'bp-new :available-p t
                         :selected-p nil :font nil :event-synonym 
                         '(control-key #\N))
                   (make-menu-item :title "~Open"
                         :value 'bp-open :available-p t
                         :selected-p nil :font nil :event-synonym 
                         '(control-key #\O))
                   (make-menu-item :title "~Close"
                         :value 'bp-close :available-p t
                         :selected-p nil :font nil)
                   menu-separator
                   (make-menu-item :title "New Training Set"
                         :value 'new-training-set :available-p t
                         :name ':new-training-set
                         :selected-p nil :font nil)
                   (make-menu-item :title "Load Training Set..."
                         :value 'load-training-set :available-p t
                         :selected-p nil :font nil)
                   (make-menu-item :title "Save Training Set As..."
                          :name ':save-training-set
                         :value 'save-training-set :available-p t
                         :selected-p nil :font nil)
                   menu-separator
                   (make-menu-item :title "~Save"
                         :value 'bp-save :available-p t
                         :selected-p nil :font nil :event-synonym 
                         '(control-key #\S))
                   (make-menu-item :title "Save ~As"
                         :value 'bp-save-as :available-p t
                         :selected-p nil :font nil)
                   menu-separator
                   (make-menu-item :title "~Print"
                         :value 'bp-print :available-p t
                         :selected-p nil :font nil :event-synonym 
                         '(control-key #\S))
                   menu-separator
                   (make-menu-item :name :help :title "~Help"
                         :value 'bp-file-help :available-p nil
                         :selected-p nil :font nil :event-synonym 
                         '(control-key #\H))
                   (make-menu-item :title "E~xit from BP"
                         :value 'bp-exit :available-p t
                         :selected-p nil :font nil :event-synonym 
                         '(control-key #\X)))
                'pop-up-menu *lisp-main-window* :name '*bp-file-menu* :title '"" 
                :selection-function 'funcall-menu-item)))
     
     
(defun bp-exit ()
     (window-close *bp-main-window*))

(defun quit-bp ()
     (setq pail-lib::*bp-module-loaded* nil)
     (make-available :bp)
     (select-window pail-lib::*pail-main-window*)
     (in-package :pail-lib))




(defun set-menu-after-load ()
      (set-menu-item-available-p
            (find-named-object ':save-training-set *bp-file-menu*) t)
      (set-menu-item-available-p
            (find-named-object ':learn *bp-back-propagation-menu*) t)
      (set-menu-item-available-p
            (find-named-object ':reinitialize *bp-back-propagation-menu*) t)
      (set-dialog-item-available-p
            (find-named-object ':learn *out-dialog*) t)
      (set-dialog-item-available-p
            (find-named-object ':reinitialize *out-dialog*) t))
      
       
       

(defun set-menu-before-load ()
      (set-menu-item-available-p
            (find-named-object ':save-training-set *bp-file-menu*) nil)
      (set-menu-item-available-p
            (find-named-object ':learn *bp-back-propagation-menu*) nil)
      (set-menu-item-available-p
            (find-named-object ':reinitialize *bp-back-propagation-menu*) nil)
      (set-dialog-item-available-p
            (find-named-object ':learn *out-dialog*) nil)
      (set-dialog-item-available-p
            (find-named-object ':reinitialize *out-dialog*) nil))



(defvar *bp-back-propagation-menu* nil)

(setq *bp-back-propagation-menu*
      (make-menu-item :title "~Back Propagation" :value
             (open-menu 
                   (list 
                      (make-menu-item :title "Learn"
                             :name ':learn
                             :value 'start-stop-learn :available-p nil
                             :selected-p nil :font nil)
                      (make-menu-item :title "Reinitialize"
                             :name ':reinitialize
                             :value 'reinitialize :available-p nil
                             :selected-p nil :font nil)
                      menu-separator
                      (make-menu-item :title "Set Parameters"
                             :name ':set-parameters
                             :value 'bp-parameters :available-p t
                             :selected-p nil :font nil)
                      menu-separator
                      (make-menu-item :title "Environment Info"
                             :name ':environment-info
                             :value 'environment-info :available-p nil
                             :selected-p nil :font nil)
                      (make-menu-item :title "Help"
                             :available-p nil
                             :value 'parser-help))
                   'pop-up-menu *lisp-main-window* :name '*bp-back-propagation-menu* :title '"" 
                   :selection-function 'funcall-menu-item)))



(defun start-stop-learn ()
      (let ((d-item (find-named-object :learn *out-dialog*))
              (m-item (find-named-object :learn *bp-back-propagation-menu*)))
          (if (string= (dialog-item-title d-item) "Learn")
             (progn
                  (set-dialog-item-title d-item "Stop")
                  (set-menu-item-title m-item "Stop")
                  (start-learn))
             (progn
                  (set-dialog-item-title d-item "Learn")
                  (set-menu-item-title m-item "Learn")
                  (stop-learn)))))
              
                               
                            
(defvar *bp-network-menu* nil)

(setq *bp-network-menu*
      (make-menu-item :title "~Network" :value
             (open-menu 
                   (list 
                      (make-menu-item :title "Show Network Topology"
                             :name ':show-network-topology
                             :value 'show-network-topology :available-p t
                             :selected-p nil :font nil)
                      (make-menu-item :title "Show Weights"
                             :name ':show-weights
                             :value 'show-bp-weights :available-p t
                             :selected-p nil :font nil)
                      (make-menu-item :title "Show Error"
                             :name ':show-error
                             :value 'show-error :available-p t
                             :selected-p nil :font nil)
                      menu-separator
                      (make-menu-item :title "Show All"
                             :name ':show-all
                             :value 'show-all :available-p t
                             :selected-p nil :font nil))
                   'pop-up-menu *lisp-main-window* :name '*bp-network-menu* :title '"" 
                   :selection-function 'funcall-menu-item)))



(defun show-network-topology ()
      (if *show-topology*
         (progn
              (setq *show-topology* nil)
              (set-menu-item-selected-p
                      (find-named-object ':show-network-topology *bp-network-menu*)
                      nil)
              (set-menu-item-selected-p
                      (find-named-object ':show-all *bp-network-menu*)
                      nil)
              (when (not (or *show-topology* *show-errors* *show-weights*))              
                     (setq *graphics* nil))
              (when (windowp *topology-window*)
                     (close *topology-window*)))
         (progn
              (setq *show-topology* t)
              (set-menu-item-selected-p
                      (find-named-object ':show-network-topology *bp-network-menu*)
                      t)
              (when (and *show-topology* *show-errors* *show-weights*)
                     (set-menu-item-selected-p
                            (find-named-object ':show-all *bp-network-menu*)
                             t))
              (setq *graphics* t)
                     (when (not (windowp *topology-window*))
                            (setq *topology-window* (open-activation-display *net-graphics*))))))

                 

(defun show-bp-weights ()
      (if *show-weights*
         (progn
              (setq *show-weights* nil)
              (set-menu-item-selected-p
                      (find-named-object ':show-weights *bp-network-menu*)
                      nil)
              (set-menu-item-selected-p
                      (find-named-object ':show-all *bp-network-menu*)
                      nil)
              (when (not (or *show-topology* *show-errors* *show-weights*))              
                     (setq *graphics* nil))
              (when (windowp *weights-window*)
                     (close *weights-window*)))
         (progn
              (setq *show-weights* t)
              (set-menu-item-selected-p
                      (find-named-object ':show-weights *bp-network-menu*)
                      t)
              (when (and *show-topology* *show-errors* *show-weights*)
                     (set-menu-item-selected-p
                            (find-named-object ':show-all *bp-network-menu*)
                             t))
              (setq *graphics* t)
              (when *current-net*
                     (when (not (windowp *weights-window*))
                            (setq *weights-window* (open-weight-display *net-graphics*)))))))



(defun show-error ()
      (if *show-errors*
         (progn
              (setq *show-errors* nil)
              (set-menu-item-selected-p
                      (find-named-object ':show-error *bp-network-menu*)
                      nil)
              (set-menu-item-selected-p
                      (find-named-object ':show-all *bp-network-menu*)
                      nil)
              (when (not (or *show-topology* *show-errors* *show-weights*))              
                     (setq *graphics* nil))
              (when (windowp *errors-window*)
                     (close *errors-window*)))
         (progn
              (setq *show-errors* t)
              (set-menu-item-selected-p
                      (find-named-object ':show-error *bp-network-menu*)
                      t)
              (when (and *show-topology* *show-errors* *show-weights*)
                     (set-menu-item-selected-p
                            (find-named-object ':show-all *bp-network-menu*)
                             t))
              (setq *graphics* t)
              (when *current-net*
                     (when (not (windowp *errors-window*))
                            (setq *errors-window* (open-error-display)))))))



(defun show-all ()
      (if (menu-item-selected-p (find-named-object ':show-all *bp-network-menu*))
         (progn
              (show-network-topology)
              (show-bp-weights)
              (show-error))
         (progn
              (unless *show-topology* (show-network-topology))
              (unless *show-weights* (show-bp-weights))
              (unless *show-errors* (show-error)))))



(defvar *bp-demo-menu* nil)

(setq *bp-demo-menu*
     (make-menu-item :title "~Demos" :value
           (open-menu 
                (list 
                   (make-menu-item :title "Demo 1"
                         :available-p t
                         :value 'demo-1)
                   (make-menu-item :title "Demo 2"
                         :available-p nil
                         :value 'demo-1)
                   (make-menu-item :title "Demo 3"
                         :available-p nil
                         :value 'demo-1))
                'pop-up-menu *lisp-main-window* :name '*bp-parser-menu* :title '"" 
                :selection-function 'funcall-menu-item)))



(defun demo-1 (&rest nulla)
  (declare (ignore nulla))
  (start-demo-1))


(defun demo-2 (&rest nulla)
  (declare (ignore nulla))
  (start-demo-2))

(defun demo-3 (&rest nulla)
  (declare (ignore nulla))
  (start-demo-3))


                                                  

(defun set-bp-menubar ()
;;;      (setq *lisp-menu-bar*
;;;           (open-stream 'menu-bar *lisp-main-window* :io))
     (clean-up-menubar)
     (add-to-menu *lisp-menu-bar*
          (make-menu-item
                :title '~Tools
                :value *pail-tool-menu*))
     (add-to-menu *lisp-menu-bar*
          *bp-file-menu*)
     (add-to-menu *lisp-menu-bar*
          (make-menu-item
                :title '~Edit
                :value *pail-edit-menu*))
     (add-to-menu *lisp-menu-bar*
          *bp-back-propagation-menu*)
     (add-to-menu *lisp-menu-bar*
          *bp-network-menu*)
     (add-to-menu *lisp-menu-bar*
          *bp-demo-menu*)
     (add-to-menu *lisp-menu-bar*
          *pail-window-menu*)  
    ; (set-window-menu *bp-main-window* *lisp-menu-bar*)
     )


