(in-package :bp)

(defparameter bp-parameters nil)

(defun make-bp-parameters ()
      (setq bp-parameters 
            (let (dialog)
                (setq dialog 
                      (open-dialog 
                            (list 
                               (make-dialog-item :widget 'lisp-text :groupstart t 
                                      :tabstop t :box #.(make-box 150 18 210 42)
                                      :value (if *current-net*
                                                      (l-rate *current-net*)
                                                      *default-l-rate*)
                                      :font (make-font nil :courier\ new 16 nil)
                                      :name :l-rate)
                               (make-dialog-item :widget 'lisp-text :groupstart t
                                      :tabstop t :box #.(make-box 150 58 210 82)
                                      :value (if *current-net*
                                                      (momentum *current-net*)
                                                      *default-momentum*)
                                      :font (make-font nil :courier\ new 16 nil)
                                      :name :momentum)
                               (make-dialog-item :widget 'lisp-text :groupstart t 
                                      :tabstop t :box #.(make-box 150 98 210 122) 
                                      :value *tolerance* :font 
                                      (make-font nil :courier\ new 16 nil) :name 
                                      :tolerance)
                               (make-dialog-item :widget 'lisp-text :groupstart t 
                                      :tabstop t :box #.(make-box 150 138 210 162) 
                                      :value *hidden-neurons*
                                      :font (make-font nil :courier\ new 16 nil)
                                      :name :hidden-neurons)
                               (make-dialog-item :widget 'lisp-text :groupstart t 
                                      :tabstop t :box #.(make-box 370 18 430 42) :value 
                                      *max-trials* :font 
                                      (make-font nil :courier\ new 16 nil) :name 
                                      :max-trials)
                               (make-dialog-item :widget 'lisp-text :groupstart t 
                                      :tabstop t :box #.(make-box 370 58 430 82) :value 
                                      *a-max* :font 
                                      (make-font nil :courier\ new 16 nil) :name 
                                      :a-max)
                               (make-dialog-item :widget 'lisp-text :groupstart t 
                                      :tabstop t :box #.(make-box 370 98 430 122) :value 
                                      *w-max* :font 
                                      (make-font nil :courier\ new 16 nil) :name 
                                      :w-max)
                               (make-dialog-item :widget 'static-text :groupstart t 
                                      :tabstop nil :background-color t :box 
                                      #.(make-box 225 100 360 120) :value "Max. disp. weight" :font 
                                      (make-font nil :arial 16 '(:bold)))
                               (make-dialog-item :widget 'static-text :groupstart t 
                                      :tabstop nil :background-color t :box 
                                      #.(make-box 225 60 360 80) :value "Max. disp. activation" :font 
                                      (make-font nil :arial 16 '(:bold)))
                               (make-dialog-item :widget 'static-text :groupstart t 
                                      :tabstop nil :background-color t  
                                      :box #.(make-box 225 20 360 40) :value "Max. trials" :font 
                                      (make-font nil :arial 16 '(:bold)))
                               (make-dialog-item :widget 'static-text :groupstart t 
                                      :tabstop nil :background-color t :box 
                                      #.(make-box 20 140 140 160) :value "Hidden neurons" 
                                      :font (make-font nil :arial 16 '(:bold)))
                               (make-dialog-item :widget 'static-text :groupstart t 
                                      :tabstop nil :background-color t :box 
                                      #.(make-box 20 100 140 120) :value 
                                      "Output tolerance" :font 
                                      (make-font nil :arial 16 '(:bold)))
                               (make-dialog-item :widget 'static-text :groupstart t 
                                      :tabstop nil :background-color t :box 
                                      #.(make-box 20 60 140 80) :value 
                                      "Momentum" :font 
                                      (make-font nil :arial 16 '(:bold)))
                               (make-dialog-item :widget 'static-text :groupstart t 
                                      :tabstop nil :background-color t :box 
                                      #.(make-box 20 20 140 40) :value "Learning rate" 
                                      :font (make-font nil :arial 16 '(:bold)))
                               (make-dialog-item :widget 'default-button :groupstart nil 
                                      :tabstop nil :box #.(make-box 370 195 430 220) 
                                      :set-value-fn 'save-bp-parameters
                                      :font (make-font nil :arial 16 '(:bold)) :name :ok 
                                      :title "OK")
                               (make-dialog-item :widget 'button :groupstart nil 
                                      :tabstop nil :box #.(make-box 270 195 330 220) 
                                      :set-value-fn 'set-bp-default-values
                                      :font (make-font nil :arial 16 '(:bold)) :name :default
                                      :title "Default")
                               (make-dialog-item :widget 'button :groupstart nil 
                                      :tabstop nil :box #.(make-box 170 195 230 220) 
                                      :font (make-font nil :arial 16 '(:bold)) :name 
                                      :help :title "Help"))
                            'dialog *bp-main-window* :name :bp-parameters
                            :title "BP parameters"
                            :font (make-font :swiss :system 20 '(:bold))
                            :user-movable t :user-resizable nil :user-closable nil
                            :user-shrinkable nil :user-scrollable nil 
                            :window-border :dialog-box
                            :background-color (make-rgb :red 0 :green 128 :blue 128) 
                            :pop-up-p nil :visible-box #.(make-box 0 0 450 230))))))



(defun bp-parameters ()
    (make-bp-parameters))



(defun save-bp-parameters (widget new-value old-value)
      (setf *l-rate*
          (dialog-item-value (nth 0 (dialog-items bp-parameters))))
      (setf *momentum*
          (dialog-item-value (nth 1 (dialog-items bp-parameters))))
      (setf *tolerance*
          (dialog-item-value (nth 2 (dialog-items bp-parameters))))
      (setf *hidden-neurons*
          (dialog-item-value (nth 3 (dialog-items bp-parameters))))
      (setf *max-trials*
          (dialog-item-value (nth 4 (dialog-items bp-parameters))))
      (setf *a-max*
          (dialog-item-value (nth 5 (dialog-items bp-parameters))))
      (setf *w-max*
          (dialog-item-value (nth 6 (dialog-items bp-parameters))))
      (close bp-parameters)
      (when *current-net*
             (unless (equal *hidden-neurons* (1- (length (fourth (node-seqs *current-net*)))))
                   (when (windowp *topology-window*)
                          (close *topology-window*))
                   (when (windowp *weights-window*)
                          (close *weights-window*))
                   (when (windowp *errors-window*)
                          (close *errors-window*))
                   (create-net-topology))
             (setf (l-rate *current-net*) *l-rate*)
             (setf (momentum *current-net*) *momentum*)
             (when (windowp *topology-window*)
                    (setf (a-max *net-graphics*) *a-max*)
                    (show-activities *net-graphics*))
             (when (windowp *weights-window*)
                    (setf (w-max *net-graphics*) *w-max*)
                    (show-weights *net-graphics*)))
      t)

      
      
      
(defun set-bp-default-values (widget new-value old-value)
      (bp-default-values)
      (set-dialog-item-value (nth 0 (dialog-items bp-parameters)) *l-rate*)
      (set-dialog-item-value (nth 1 (dialog-items bp-parameters)) *momentum*)
      (set-dialog-item-value (nth 2 (dialog-items bp-parameters)) *tolerance*)
      (set-dialog-item-value (nth 4 (dialog-items bp-parameters)) *max-trials*)
      (set-dialog-item-value (nth 5 (dialog-items bp-parameters)) *a-max*)
      (set-dialog-item-value (nth 6 (dialog-items bp-parameters)) *w-max*)
      (when *current-net*
             (setf (l-rate *current-net*) *l-rate*)
             (setf (momentum *current-net*) *momentum*)
             (when (windowp *topology-window*)
                    (setf (a-max *net-graphics*) *a-max*)
                    (show-activities *net-graphics*))
             (when (windowp *weights-window*)
                    (setf (w-max *net-graphics*) *w-max*)
                    (show-weights *net-graphics*))))          



(defun bp-default-values ()
      (setq *l-rate* *default-l-rate*)
      (setq *momentum* *default-momentum*)
      (setq *tolerance* *default-tolerance*)
      (setq *max-trials* *default-max-trials*)
      (setq *a-max* *default-a-max*)
      (setq *w-max* *default-w-max*))
      


(defun change-bp-parameter  (widget new-value old-value)
       (set-dialog-item-value widget (eval new-value)))
