

(in-package :bp)



(defclass bp-error-dialog (dialog)
       ())



(defun open-error-display ()
      (let* ((error-dialog
                      (open-dialog
                            (list
                               (make-dialog-item :widget 'button
                                      :name ':close
                                      :title "Close"
                                      :font (make-font :modern nil 16 '(:bold))
                                      :box (make-box 0 0 200 25)
                                      :set-value-fn '(lambda (&rest x) (show-error) t))
                               (make-dialog-item :widget 'button
                                      :title "Help"
                                      :name ':help
                                      :available-p nil
                                      :font (make-font :modern nil 16 '(:bold))
                                      :box (make-box 200 0 400 25)))
                            'bp-error-dialog *bp-main-window*
                            :pop-up-p nil
                            :title "Performance and error functions"
                            :user-resizable nil :user-closable nil
                            :user-scrollable nil
                            :window-border :dialog-box
                            :visible-box (make-box 0 0 400 300))))
          (open-stream 'bitmap-window error-dialog :output
                :window-exterior
                (make-box 0 25
                       (box-width (window-interior error-dialog))
                       (box-height (window-interior error-dialog)))
                :user-closable nil :user-scrollable nil
                :user-resizable nil :user-movable nil)
          (init-window error-dialog)
          error-dialog))



(defun my-floor (n)
      (max 1 (floor (/ *max-trials* 10))))



(defmethod init-window ((w bp-error-dialog))
      (let* ((disp (first (windows w)))
                (width (box-width (window-interior disp)))
                (height (box-height (window-interior disp)))
                (perf-list '(0.2 0.4 0.6 0.8 1))
                (step (/ (- height 60.0) (length perf-list)))
                (old-color (foreground-color disp)))
          (erase-contents-box disp (visible-box disp))
          (setq *init-x* 30)
          (setq *init-y* (- height 30))
          (setq *init-y-err* 30)
          (setq *last-position* nil)
          (setq *last-position-err* nil)
          (setq *step-x* (/ (- width 60.0) *max-trials*))
          (setq *step-y* (/ (- height 60.0) (length (rows *target-set*))))
          (setq *step-y-err* (/ (- height 60.0) (/ (length (rows *target-set*)) 2)))
          (dotimes (n (1+ (floor (/ *max-trials* (my-floor 10)))))
                (unless (= n 0)
                      (draw-line disp
                           (make-position
                                  (round (+ *init-x* (* *step-x* (* n (my-floor 10)))))
                                  (- height 32))
                           (make-position
                                  (round (+ *init-x* (* *step-x* (* n (my-floor 10)))))
                                  (- height 28))))
                (draw-string-in-box disp
                     (write-to-string (* (my-floor 10) n))
                     0 (length (write-to-string (* (my-floor 10) n)))
                     (make-box
                            (round (+ *init-x* -25 (* *step-x* (* n (my-floor 10)))))
                            (- height 25)
                            (round (+ *init-x* 25 (* *step-x* (* n (my-floor 10)))))
                            (- height 5))
                     :center :top nil))
          (draw-line disp
               (make-position 30 (- height 30))
               (make-position (- width 30) (- height 30)))
          (setf (foreground-color disp) blue)
          (dotimes (n (/ (length (rows *target-set*)) 2))
                (draw-line disp
                     (make-position 28 (round (- *init-y* (* *step-y-err* (1+ n)))))
                     (make-position 32 (round (- *init-y* (* *step-y-err* (1+ n))))))
                (draw-string-in-box disp
                     (write-to-string (1+ n))
                     0 (length (write-to-string (1+ n)))
                     (make-box
                            5 (round (- *init-y* 7 (* *step-y-err* (1+ n))))
                            25 (round (- *init-y* -7 (* *step-y-err* (1+ n)))))
                     :right :center nil))
          (draw-string-in-box disp
               "Error function"
               0 14
               (make-box 0 5 170 25)
               :right :top nil)
          (draw-line disp
               (make-position 30 20)
               (make-position 30 (- height 30)))
          (setf (foreground-color disp) red)
          (dotimes (n (length perf-list))
                (draw-line disp
                     (make-position (- width 32) (round (- *init-y* (* step (1+ n)))))
                     (make-position (- width 28) (round (- *init-y* (* step (1+ n))))))
                (draw-string-in-box disp
                     (write-to-string (nth n perf-list))
                     0 (length (write-to-string (nth n perf-list)))
                     (make-box
                            (- width 25) (round (- *init-y* 7 (* step (1+ n))))
                            (- width 2) (round (- *init-y* -7 (* step (1+ n)))))
                     :left :center nil))
          (draw-string-in-box disp
               "Performance"
               0 11
               (make-box 230 5 400 25)
               :left :top nil)
          (draw-line disp
               (make-position (- width 30) 20)
               (make-position (- width 30) (- height 30)))
          (setf (foreground-color disp) old-color)))



(defmethod disp-performance ((w bp-error-dialog) position)
      (let* ((disp (first (windows w)))
                (old-color (foreground-color disp)))
          (setf (foreground-color disp) red)
          (when *last-position*
                 (draw-line disp
                      *last-position*
                      position))
          (setq *last-position* position)
          (setf (foreground-color disp) old-color)))



(defmethod disp-error ((w bp-error-dialog) position)
      (let* ((disp (first (windows w)))
                (old-color (foreground-color disp)))
          (setf (foreground-color disp) blue)
          (when *last-position-err*
                 (draw-line disp
                      *last-position-err*
                      position))
          (setq *last-position-err* position)
          (setf (foreground-color disp) old-color)))
      