
(in-package :bp)


(defconstant *cell-size* (make-position 50 20))


(defun new-training-set ()
     (when (or *input-set-editor* *target-set-editor*)
          (close-set-tables))
     (setq *input-set*
          (make-table
                :table-name "Untitled Input Set"
                :attributes (list )
                :rows   (list)))
     (setq *target-set*
          (make-table
                :table-name "Untitled Target Set"
                :attributes (list)
                :rows   (list))) 
     (setq *input-set-editor*
          (table-to-editor *input-set* *bp-main-window*
              (list 'add-i-example 'delete-i-example
                 'add-i-attribute 'delete-i-attribute 'close-set-tables)
              (make-position 200 70)))
     (setq *target-set-editor*
          (table-to-editor *target-set* *bp-main-window*
              (list 'add-t-example 'delete-t-example
                 'add-t-attribute 'delete-t-attribute 'close-set-tables)
              (make-position 200 70)))
     (setq *current-set-file* "Untitled.set")
     (format-display *bp-output-window*
         "~%Creating new network ...~%")                        
     ;   (create-net-topology)
     (set-menu-after-load))    
     

(defun load-training-set ()
      (let ((file 
                       (ask-user-for-existing-pathname
                        "Load training set"
                        :stream  *bp-main-window*
                        :allowed-types '(("Training sets" . "*.set")("All Files"  . "*.*"))
                        :host (concatenate 'string *pail-directory* "bp\\networks\\")
                        )))
          (when file
                (setq load-ok t)
                 (when *input-set*
                        (setq load-ok (close-set-tables)))
                 (when load-ok
                        (format-display *bp-output-window*
                             "~%Loading ~A ...~%" file)                        
                        (load file)
                        (setq *input-set-editor*
                              (table-to-editor *input-set* *bp-main-window*
                                   (list 'add-i-example 'delete-i-example
                                      'add-i-attribute 'delete-i-attribute 'close-set-tables)
                                   *cell-size*))
                        (setq *target-set-editor*
                              (table-to-editor *target-set* *bp-main-window*
                                   (list 'add-t-example 'delete-t-example
                                      'add-t-attribute 'delete-t-attribute 'close-set-tables)
                                   *cell-size*))
                        (setq *current-set-file* (file-namestring file))
                        (format-display *bp-output-window*
                             "~%Creating network ...~%" file)                        
                        (create-net-topology)
                        (set-menu-after-load)))))



(defun close-set-tables (&optional item)
      (let ((save (if (table-needs-saving-p *input-set-editor*)
                              (ask-save-changes *input-set-editor*)
                              (if (table-needs-saving-p *target-set-editor*)
                                 (ask-save-changes *target-set-editor*)
                                 :no))))
          (unless (equal save :cancel)
                (progn
                     (when (equal save :yes)
                            (progn
                                 (setq *input-set* (editor-to-table *input-set-editor*))
                                 (setq *target-set* (editor-to-table *target-set-editor*))
                                 (dump-tables-to-file
                                       (list *input-set* *target-set*)
                                       (concatenate 'string 
                                             *pail-directory*
                                             "bp\\networks\\"
                                             *current-set-file*))))
                     (close *input-set-editor*)
                     (close *target-set-editor*)
                     (when (windowp *topology-window*)
                            (close *topology-window*))
                     (when (windowp *weights-window*)
                            (close *weights-window*))
                     (when (windowp *errors-window*)
                            (close *errors-window*))
                     (setq *hidden-neurons* nil)
                     (setq *input-set* nil)
                     (setq *target-set* nil)
                     (setq *input-set-editor* nil)
                     (setq *target-set-editor* nil)
                     (setq *current-set-file* nil)
                     (setq *current-net* nil)
                     (set-menu-before-load)
                     t))))



(defun save-training-set ()
      (let ((current-table-name (name-trim (table-name *input-set-editor*))))
          (multiple-value-bind (new-name old-name value)
                  (ask-user-for-string
                        "Please, type in the new training set name"
                        current-table-name "OK" "Cancel")
                      (when (string= value "OK")
                             (let ((new-file (pop-up-save-file-dialog
                                                             *bp-main-window*
                                                             (make-pathname :host nil :name *pail-directory*)
                                                             "Save training set as"
                                                             "Please, type in the new training file."
                                                             (file-namestring *current-set-file*)
                                                             "bp\\networks\\")))
                                 (when new-file
                                        (progn
                                             (setf (table-name *input-set-editor*)
                                                       (concatenate 'string
                                                             new-name
                                                             ": Input Set"))
                                             (setf (stream-title *input-set-editor*)
                                                       (concatenate 'string
                                                             new-name
                                                             ": Input Set"))
                                             (setf (table-name *target-set-editor*)
                                                       (concatenate 'string
                                                             new-name
                                                             ": Target Set"))
                                             (setf (stream-title *target-set-editor*)
                                                       (concatenate 'string
                                                             new-name
                                                             ": Target Set"))
                                             (setf *input-set* (editor-to-table *input-set-editor*))
                                             (setf *target-set* (editor-to-table *target-set-editor*))
                                             (setf *current-set-file* (file-namestring new-file))
                                             (setf (table-needs-saving-p *input-set-editor*) nil)
                                             (setf (table-needs-saving-p *target-set-editor*) nil)
                                            (create-net-topology)
                                             (dump-tables-to-file
                                                   (list *input-set* *target-set*)
                                                   new-file)
                                             t)))))))




(defun name-trim (str)
      (let ((l (coerce str 'list))
              (result nil))
          (dolist (ch l)
                (if (equal ch #\:)
                   (return)
                   (push ch result)))
          (coerce (reverse result) 'string)))



(defmethod dump-tables-to-file (tables &optional (filename t))
      (let (table)
      (with-open-file
           (out filename 
                 :direction :output 
                 :if-does-not-exist :create
                 :if-exists :supersede)
           (format out ";;; -*- Mode: LISP; Package :BP; Syntax: Common-lisp; -*-~%~%")
           (format out "(in-package :bp)~%~%~%")
           (setq table (first tables))
           (format out ";;;")
           (format out (table-name table))
           (format out "~%~%(setf *readable* t)~%~%")
           (format out "(setq *input-set*~%")
           (format out "      (make-table~%")
           (format out "            :table-name ~S~%" (table-name table))
           (format out "            :attributes~22T'(~{~13a~})~%" (attributes table))
           (format out "            :rows~20T'(~{~%~18T(~{~13a~})~})))~%~%" (rows table))
           (setq table (second tables))
           (format out ";;;")
           (format out (table-name table))
           (format out "~%~%(setq *target-set*~%")
           (format out "      (make-table~%")
           (format out "            :table-name ~S~%" (table-name table))
           (format out "            :attributes~22T'(~{~13a~})~%" (attributes table))
           (format out "            :rows~20T'(~{~%~18T(~{~13a~})~})))" (rows table)))))



(defun add-t-attribute ()
      (setq *target-set-editor*
            (insert-new-attribute *target-set-editor* *bp-main-window*))
     (setq *target-set* (editor-to-table *target-set-editor*)))

(defun add-i-attribute ()
      (setq *input-set-editor*
            (insert-new-attribute *input-set-editor* *bp-main-window*))
     (setq *input-set* (editor-to-table *input-set-editor*)))

(defun delete-t-attribute ()
      (let* ((list-of-attributes (cdar (contents *target-set-editor*)))
                (del-attribute (select-item-from-list
                                                *bp-main-window*
                                                list-of-attributes 
                                                "Choose attribute to delete")))
          (when del-attribute
                 (setq *target-set-editor*
                       (get-rid-of-attribute 
                             *target-set-editor* 
                             del-attribute 
                             *bp-main-window*))
               (setq *target-set* (editor-to-table *target-set-editor*)))))

(defun delete-i-attribute ()
      (let* ((list-of-attributes (cdar (contents *input-set-editor*)))
                (del-attribute (select-item-from-list
                                                *bp-main-window*
                                                list-of-attributes 
                                                "Choose attribute to delete")))
          (when del-attribute
                 (setq *input-set-editor*
                       (get-rid-of-attribute 
                             *input-set-editor* 
                             del-attribute 
                             *bp-main-window*))
               (setq *input-set* (editor-to-table *input-set-editor*)))))



(defun add-i-example ()
      (setq *input-set-editor*
            (insert-new-row
                *input-set-editor*
                *bp-main-window*
                *cell-size*))
     (setq *input-set* (editor-to-table *input-set-editor*)))

(defun add-t-example ()
      (setq *target-set-editor*
            (insert-new-row
                *target-set-editor*
                *bp-main-window*
                *cell-size* ))
      (setq *target-set* (editor-to-table *target-set-editor*)))



(defun delete-i-example ()
      (let* ((lista nil)
                (list-of-examples
                   (dolist (item (cdr (contents *input-set-editor*)) (reverse lista))
                         (push (car item) lista)))
                (del-example (select-item-from-list
                                                *bp-main-window*
                                                list-of-examples 
                                                "Choose example to delete")))
          (when del-example
                 (setq *input-set-editor*
                       (when del-example
                              (get-rid-of-row 
                                    *input-set-editor* 
                                    del-example 
                                    *bp-main-window*
                                    *cell-size*)))
               (setq *input-set* (editor-to-table *input-set-editor*)))))

(defun delete-t-example ()
      (let* ((lista nil)
                (list-of-examples
                   (dolist (item (cdr (contents *target-set-editor*)) (reverse lista))
                         (push (car item) lista)))
                (del-example (select-item-from-list
                                                *bp-main-window*
                                                list-of-examples 
                                                "Choose example to delete")))
          (when del-example
                 (setq *target-set-editor*
                       (when del-example
                              (get-rid-of-row 
                                    *target-set-editor* 
                                    del-example 
                                    *bp-main-window*
                                    *cell-size*)))
               (setq *target-set* (editor-to-table *target-set-editor*)))))


          



(defmethod number-of-nodes ((tab table))
      (length (attributes tab)))




(defclass training-data-class ()
       ((input-patterns 
             :initform (make-table :attributes nil :rows nil)
             :initarg :input-patterns
             :accessor input-patterns
             :type pail-lib:table)
        (target-patterns
             :initform (make-table :attributes nil :rows nil)
             :initarg :target-patterns
             :accessor target-patterns
             :type pail-lib:table))
      (:documentation "Collection of two tables (input-patterns and target-patterns)"))