;;; -*- Mode: LISP; Package: bp; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   bp-ex1.cl
;;; Short Desc: 1st demo for bp
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   6.5.91 - TW
;;; Author:     Thomas Wehrle
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History: 
;;; 
;;;	
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :bp)



(defun start-demo-1 ()
      (when 
               (create-demo-dialog  
                :window-title "BP Demos"
                :title "Rule Based Systems"
                :subtitle "A First Demo"
                :helpfile "bp\\help\\bp-d1.asc"
                :window *bp-main-window*)
             (progn
                  (setq *bp-demo-running* t)
                  (catch 'stop-demo (main-demo-1))
                  (setq *bp-demo-running* nil))))


(defun main-demo-1 ()
      (let ((load-ok t))
      (format-demo "This is the first BP demo.

")
      
      (demo-loop)
      (format-demo "First we load the Input and Target Sets.

")

      (demo-loop)
      (when *input-set*
             (setq load-ok (close-set-tables)))
      (setq *max-trials* 60)
      (when load-ok
             (format-display *bp-output-window*
                  "~%Loading ~A ...~%"
                  (concatenate 'string
                        *pail-directory*
                        "bp\\networks\\fourcode.set"))                        
             (load (concatenate 'string
                        *pail-directory*
                        "bp\\networks\\fourcode.set"))
             (setq *input-set-editor*
                   (table-to-editor *input-set* *bp-main-window*
                        (list 'add-example 'delete-example
                           'add-attribute 'delete-attribute 'close-set-tables)
                        *cell-size*))
             (setq *target-set-editor*
                   (table-to-editor *target-set* *bp-main-window*
                        (list 'add-example 'delete-example
                           'add-attribute 'delete-attribute 'close-set-tables)
                        *cell-size*))
             (setq *current-set-file*
                   (file-namestring (concatenate 'string
                                                         *pail-directory*
                                                         "bp\\networks\\fourcode.set")))
             (format-display *bp-output-window*
                  "~%Creating network ...~%")
             (create-net-topology)
             (set-menu-after-load))

      (demo-loop)
      (format-demo "We can see the error and performance functions

")
      (unless *show-errors* (show-error))
      
      (demo-loop)
      (format-demo "We call the learning procedure.

")

      (demo-loop)
      (start-stop-learn)
      (demo-loop)
      
      (format-demo "We can look at topology ot the network.

")
      
      (demo-loop)
      
      (unless *show-topology* (show-network-topology))
      (format-demo "Clicking in the neurons, we can see their activations.

")

      (demo-loop)
      
      (format-demo "We can also look weights of neurons.

")
      
      (demo-loop)
      
      (unless *show-weights* (show-bp-weights))
      (format-demo "Clicking in the connections, we can see their weight values.

")

      (demo-loop)
      (format-demo "End of Demo")
      (demo-loop)
      
      (close-set-tables)))
            
