;;; -*- Mode: LISP; Package: cky; Syntax: Common-lisp; -*-



(in-package :cky)



(defvar *cky-browsers* nil)



(defclass parse-tree (tree)
       ())

(defclass cky-browser (browser)
       ())



(defmethod label ((tree  parse-tree))
      (content tree))



(defun sexpr-to-parse-tree (sexpr)
      (if (atom sexpr)
         (make-instance 'parse-tree :content sexpr)
         (make-instance 'parse-tree
                :content (car sexpr)
                :descendants (mapcar (function sexpr-to-parse-tree) (cdr sexpr)))))



(defun prtree (cky-table)
      (let ((n 0))
          (setq *open-browsers* nil)
          (mapcar 
                 #'(lambda (parse)
                         (incf n)
                         (push
                               (open-dialog () 'cky-browser *cky-main-window* :pop-up-p nil
                                     :user-scrollable nil :user-closable nil :user-resizable t
                                     :title (format nil "Parse ~D" n)
                                     :starting-tree (sexpr-to-parse-tree parse))
                               *cky-browsers*))
                 cky-table)))
