;;; -*- Mode: LISP; Package: cky; Syntax: Common-lisp; -*-



(in-package :cky)



(defun row-c (r)
       (+ *chart-button-height*
           *further-info-height*
           (* *chart-height* r)))

(defun col-c (c)
       (* *chart-width* (1- c)))





(defun further-inform (string)
      (set-dialog-item-value *further-info-button* string))




(defmethod resize-window :after ((w cky-chart-dialog) position)
      (when (cell-array w)
             (let* ((pos 0)
                       (n-items (length (scan-string *current-sentence*)))
                       (chart-width (position-x position))
                       (chart-height (- (position-y position) *further-info-height* *chart-button-height*))
                       (chart-size-x (if (> chart-width (* n-items *chart-width*))
                                                   (round (/ chart-width n-items))
                                                   *chart-width*))
                       (chart-size-y (if (> chart-height (* n-items *chart-height*))
                                                    (round (/ chart-height n-items))
                                                    *chart-height*)))
                 (set-dialog-item-box (second *close-help-buttons*)
                       (make-box (- chart-width 60) 0 chart-width *further-info-height*))
                 (set-dialog-item-box *further-info-button*
                       (make-box 70 0 (- chart-width 70) *further-info-height*))
                 (dolist (ch-button (subseq (dialog-items w) 0 n-items))
                       (set-dialog-item-box ch-button
                             (make-box
                                    (* chart-size-x pos)
                                    *further-info-height*
                                    (* chart-size-x (1+ pos))
                                    (+ *chart-button-height* *further-info-height*))
                             (incf pos)))
                 (dolist (cell (cell-array w))
                       (setf (window-exterior cell)
                                 (make-box
                                        (* chart-size-x (1- (col cell)))
                                        (+ *chart-button-height* *further-info-height* (* chart-size-y (row cell)))
                                        (* chart-size-x (col cell))
                                        (+ *chart-button-height* *further-info-height* (* chart-size-y (1+ (row cell))))))))))
                       
                   
                   
                   
(defun layout-buttons (wchart)
      (let* ((position 0)
                (chart-width (box-width (window-interior wchart)))
                (sentence (scan-string *current-sentence*))
                (button-width (round (/ chart-width (length sentence))))
                (button-bottom 30))
          (setq *close-help-buttons*
                (list
                   (make-dialog-item :widget 'button
                          :title "Help"
                          :font (make-font nil :arial 16 '(:bold))
                          :box (make-box 0 0 60 *further-info-height*)
                          :available-p nil)
                   (make-dialog-item :widget 'button
                          :title "Close"
                          :font (make-font nil :arial 16 '(:bold))
                          :box (make-box (- chart-width 60) 0 chart-width *further-info-height*)
                          :set-value-fn #'(lambda (item new old)
                                                           (close *chart-window*)
                                                           (setq *chart-window* nil)
                                                           t))))
          (setq *further-info-button*
                (make-dialog-item :widget 'static-text
                       :background-color t
                       :box (make-box 70 0 (- chart-width 70) *further-info-height*)
                       :value ""))
          (setq *button-list*
                (mapcar 
                       #'(lambda (word)
                               (incf position)
                               (make-dialog-item :widget 'cky-chart-button-dialog-item
                                      :title word
                                      :set-value-fn #'(lambda (new old item)
                                                                       (setq *chart-button-pushed-p* t))
                                      :font (make-font nil :arial 16 '(:bold))
                                      :box (make-box
                                                      (* *chart-width* (1- position))
                                                      *further-info-height*
                                                      (+ (* *chart-width* (1- position)) button-width)
                                                      (+ *chart-button-height* *further-info-height*))
                                      :available-p nil))
                       sentence))
          (update-dialog wchart (append
                                                            *button-list*
                                                            (list *further-info-button*)
                                                            *close-help-buttons*))))
  


(defun graph-chart-init ()
      (let ((n (length (scan-string *current-sentence*)))
              (screen-width (round (* 0.9 (box-width (visible-box *cky-main-window*)))))
              (screen-height (round (* 0.9 (box-height (visible-box *cky-main-window*))))))
          (setq *cell-array* (make-array (list n n)))
          (setf *chart-window*
                    (open-dialog () 'cky-chart-dialog *cky-main-window* :pop-up-p nil
                          :background-color (make-rgb :red 0 :green 128 :blue 128) 
                          :title "CKY: Chart Window"
                          :user-scrollable t :user-closable nil :user-resizable t
                          :user-shrinkable nil
                          :visible-box (make-box 0 0
                                                        (min screen-width (* n *chart-width*))
                                                        (min screen-height (+ (* n *chart-height*)
                                                                                                  *chart-button-height*
                                                                                                  *further-info-height*)))))
          (layout-buttons *chart-window*)
          (do ((r 0 (+ r 1)))
                 ((> r  n))
                (do ((c  (1+ r) (+ c 1)))
                       ((>  c n  ))
                      (push
                            (open-stream 'cky-chart-cell *chart-window* :output
                                  :col c
                                  :row r
                                  :font (make-font :modern nil 14)
                                  :window-border :dialog-box
                                  :user-scrollable t :user-closable nil :user-movable nil
                                  :user-resizable nil :user-shrinkable nil
                                  :window-exterior (make-box
                                                                           (col-c c)
                                                                           (row-c r)
                                                                           (+ (col-c c) *chart-width*)
                                                                           (+ (row-c r) *chart-height*)))
                            (cell-array *chart-window*))))))



(defun chart-inform (str)
      (when *show-chart*
             (dolist (display (cell-array *chart-window*))
                   (when (and (eql (row display) *current-row*)
                                          (eql (col display) *current-col*))
                          (format-display display str)
                          (return)))))



(defun goto-graph-chart (pos1 pos2)
      (when *show-chart*
             (further-inform (concatenate 'string
                                                 "Now processing chart cell "
                                                 (write-to-string pos1)
                                                 " "
                                                 (write-to-string pos2)
                                                 "."))
             (setf *current-row* pos1)
             (setf *current-col* pos2)))
