;;; -*- Mode: LISP; Package: cky; Syntax: Common-lisp; -*-



(defclass scrolling-window-scroller (text-edit-window)
       ())



(defvar *lexicon* nil)
(defvar *grammar* nil)

(defvar *lexicon-dialog* nil)
(defvar *grammar-dialog* nil)

(defvar *grammar-filename* nil)
(defvar *lexicon-filename* nil)
(defvar *open-cky-windows* nil)
(defvar *out-dialog* nil)



(defclass cky-dialog (dialog)
       ())

(defclass cky-fred-window (text-edit-window)
       ())

(defclass cky-main-dialog (cky-dialog)
       ())



(defclass cky-grammar-window (sequence-window) 
  ())

(defmethod bring-window-to-front :after ((cd cky-main-dialog))
        (in-package :cky)
        (set-cky-menubar)
     (setf (stream-title *lisp-main-window*) "PAIL - Chart Parsing module"))
(defclass cky-lexicon-window (sequence-window)
  ())



(defmethod initialize-instance :after ((cd cky-dialog) &rest whatever)
  (declare (ignore whatever))
  (push cd *open-cky-windows*))



(defmethod window-close ((cd cky-dialog))
      (close cd)
      )

(defmethod window-close ((cd cky-main-dialog))
      (when (yes-or-no-p "Do you really want to
quit the CKY module")
          (remove-from-window-menu (object-name *cky-main-window*))
          (close cd)
          (setf cd nil)
          (quit-cky)))


;;; (defmethod window-select :after ((cgw cky-grammar-window))
;;;   (set-help :general "cky:help:grammar-help.gen"
;;;             :technical "cky:help:grammar-help.tec"))
;;; 
;;; (defmethod window-select :after ((cgl cky-lexicon-window))
;;;   (set-help :general "cky:help:lexicon-help.gen"
;;;             :technical "cky:help:lexicon-help.tec"))
;;; 



(defmethod window-close ((clw cky-lexicon-window))
      (catch 'cancel
            (when (save-p (wsequence clw))
                   (let ((save (ask-save-changes *cky-main-window*)))
                       (when (eql save :cancel) (throw 'cancel nil))
                       (when (eql save :yes)
                              (unless (save-lexicon *lexicon-dialog*) (throw 'cancel nil)))))
            (close clw)))



(defmethod window-close ((cgw cky-grammar-window))
      (catch 'cancel
            (when (save-p (wsequence cgw))
                   (let ((save (ask-save-changes *cky-main-window*)))
                       (when (eql save :cancel) (throw 'cancel nil))
                       (when (eql save :yes)
                              (unless (save-grammar *grammar-dialog*) (throw 'cancel nil)))))
            (close cgw)))



(defmethod save-grammar ((cgw cky-grammar-window))
      (let ((filename (pop-up-save-file-dialog
                                        *cky-main-window*
                                        (make-pathname :host nil :name *pail-directory*)
                                        "Save Grammar File"
                                        "Please, type in the new grammar file."
                                        (file-namestring *grammar-filename*)
                                        "cky\\grammars\\")))
          (when filename
               (setq *grammar-filename* filename)
               (savesyn filename))))



(defmethod save-lexicon ((clw cky-lexicon-window))
      (let ((filename (pop-up-save-file-dialog
                                        *cky-main-window*
                                        (make-pathname :host nil :name *pail-directory*)
                                        "Save Lexicon File"
                                        "Please, type in the new lexicon file."
                                        (file-namestring *lexicon-filename*)
                                        "cky\\lexicae\\")))
          (when filename
               (setf *lexicon-filename* filename)
               (setf *current-lex-file* filename)
               (perform-save-lexicon clw filename))))



(defvar *w-percentage* 0.7)
(defvar *bars* 60)
(defvar *w-indent* 50)
(defvar *w-o-percentage* 0.7)
(defvar *w-m-percentage* (- 1 *w-o-percentage*))
(defvar *w-size* 0)



(defvar *cky-main-window* nil)
(defvar *cky-msg-disp*)
(defvar *cky-subdisp*)



;;; Instead of using the following variables
;;; *using-parser-cky* *using-parser-ckydot* *using-parser-ckyre*
;;; *using-parser-ckypr* *using-parser-ckyla* *using-parser-ckypl*
;;; I defined *parser*a string that can take up the following values
;;; "cky" "ckydot" "ckyre" "ckypr" "ckyla" "ckypl"



(defvar *parser* "cky")
(defvar *grammar-tool*)  
(defvar *new-sentence*)
(defvar *parse-sentence*)     
(defvar *options*)     
(defvar *help-parser*)  
(defvar *env-info*)   
(defvar *open-browsers*)

(defvar *sentence-but-list* )
(defvar *button-count*)
(defvar *button-step*)

(defvar *sentence-list*)
(defvar *sentence-list* nil)

(defvar *lexicon* '(()))
(defvar *grammar* nil)

(defvar *grammar-filename* nil)
(defvar *lexicon-filename* nil)

(defvar *show-trees* nil)
(defvar *trace* nil)
(defvar *show-chart* nil)
(defvar *verbose* nil)

(defvar *current-sentence* "")

(defvar *cky-file-menu* nil)
(defvar *cky-parser-menu* nil)
(defvar *cky-lexicon-menu* nil)
(defvar *cky-grammar-menu* nil)
(defvar *cky-demo-menu* nil)
(defvar *cky-menubar* nil)

(defvar *syn-features* nil)
(defvar lookahead) 

(defvar *rules* nil)
(defvar *chart* nil)
(defparameter *initial* '(S))


(defvar *separators*  '(#\, #\-  #\  #\= #\~ #\< #\> #\& #\+ #\( #\) #\[ #\]   #\|  #\: ))
(defvar *recgn-separators*  '(#\* #\( #\) #\| ))



;;; =======================================================================
;;; Chart variables definition                                            =
;;; =======================================================================


(defvar *chart-height* 125)
(defvar *chart-width* 125)
(defvar *further-info-height* 30)
(defvar *chart-button-height* 30)

(defvar *chart-t-height* (- *chart-height* 15))
(defvar *chart-t-width* (- *chart-width* 15))

(defvar *chart-window* nil)
(defvar *cell-array* nil)
(defvar *button-list* nil)
(defvar *current-row* 0)
(defvar *current-col* 0)
(defvar *further-info-button* nil)
(defvar *chart-button-pushed-p* nil)
(defvar *close-help-buttons* nil)


(defclass cky-chart-dialog (dialog)
       ((cell-array
             :initarg :cell-array
             :initform nil
             :accessor cell-array)))

(defclass cky-chart-button-dialog-item (button)
       ())

(defclass cky-chart-cell (text-edit-window)
       ((col
             :initarg :col
             :initform nil
             :accessor col)
        (row
             :initarg :row
             :initform nil
             :accessor row)))
        


(defvar *chart-step* nil)