;;; -*- Mode: LISP; Package: cky; Syntax: Common-lisp; -*- 
 
(in-package :cky) 
 
;;; ************************************************************************ 
;;; 
;;; PORTABLE AI LAB - IDSIA LUGANO 
;;; 
;;; ************************************************************************ 
;;; 
;;; Filename:   cky-init.lisp 
;;; Short Desc: general user interface for the  CKY tool 
;;;             
;;; Version:    1.0 
;;; Status:     New 
;;; Last Mod:   13 January 1993 - PC 
;;; Author(s):  Paolo Cattaneo 
;;; 
;;; -------------------------------------------------------------------------- 
;;; Change History: 
;;;  
;;;  
;;; -------------------------------------------------------------------------- 
 




 
(defun options () 
      (let ((current-dialog nil) trace-button show-chart-button)
          (declare (special trace-button show-chart-button step-chart-button))
          ;;;           (set-help :general "cky:help:options-help.gen" 
          ;;;            :technical "cky:help:options-help.tec") 
          (setq current-dialog 
                (open-dialog 
                      (list
                         (make-dialog-item :widget 'static-text 
                                :tabstop nil :background-color t 
                                :box #.(make-box 25 10 200 26)
                                :font (make-font nil :arial 16 '(:bold))
                                :name :text0 :value "CKY Parser Tool Options:")
                         (make-dialog-item :widget 'static-text 
                                :tabstop nil :background-color t 
                                :box #.(make-box 15 23 200 39)
                                :font (make-font nil :arial 16 '(:bold))
                                :name :text1 :value "-----------------------------------------------")
                         (make-dialog-item :widget 'check-box
                                :tabstop nil :background-color t 
                                :box #.(make-box 15 45 195 65)
                                :font (make-font nil :arial 16 '(:bold))
                                :set-value-fn
                                '(lambda (item new old)
                                     (setq *verbose* (not *verbose*)) t)
                                :name :verbose :title "Verbose Output"
                                :value *verbose*)
                         (setq trace-button
                               (make-dialog-item :widget 'check-box
                                      :tabstop nil :background-color t 
                                      :box #.(make-box 15 75 200 95)
                                      :font (make-font nil :arial 16 '(:bold))
                                      :set-value-fn
                                      '(lambda (item new old)
                                           (setq *trace* (not *trace*))
                                           (unless *trace*
                                                 (set-dialog-item-value show-chart-button nil))
                                           t)
                                      :name :trace :title "Trace Execution"
                                      :value *trace*))
                         (setq show-chart-button
                               (make-dialog-item :widget 'check-box
                                      :tabstop nil :background-color t 
                                      :box #.(make-box 15 105 200 125)
                                      :font (make-font nil :arial 16 '(:bold))
                                      :set-value-fn
                                      '(lambda (item new old)
                                           (setq *show-chart* (not *show-chart*))
                                           (if *show-chart*
                                              (progn
                                                   (set-dialog-item-value trace-button t)
                                                   (set-dialog-item-available-p step-chart-button t))
                                              (progn
                                                   (set-dialog-item-value step-chart-button nil)
                                                   (set-dialog-item-available-p step-chart-button nil)))
                                           t)
                                      :name :show-chart :title "Show Graphics Chart"
                                      :value *show-chart*))
                         (setq step-chart-button
                               (make-dialog-item :widget 'check-box
                                      :tabstop nil :background-color t 
                                      :box #.(make-box 15 135 200 155)
                                      :available-p *show-chart*
                                      :font (make-font nil :arial 16 '(:bold))
                                      :set-value-fn
                                      '(lambda (item new old)
                                           (setq *chart-step* (not *chart-step*)) t)
                                      :name :show-trees :title "Step Through Chart Cells "
                                      :value *chart-step*))
                         (make-dialog-item :widget 'check-box
                                :tabstop nil :background-color t 
                                :box #.(make-box 15 165 200 185)
                                :font (make-font nil :arial 16 '(:bold))
                                :set-value-fn
                                '(lambda (item new old)
                                     (setq *show-trees* (not *show-trees*)) t)
                                :name :show-trees :title "Show Parse Trees"
                                :value *show-trees*)
                         (make-dialog-item :widget 'cancel-button :groupstart t 
                                :tabstop nil :background-color nil :box 
                                #.(make-box 70 195 130 220) :title "Help" 
                                :available-p nil
                                :font (make-font nil :arial 16 '(:bold))
                                :set-value-fn 
                                '(lambda (item new old) (cky-options-help))
                                :name :help-button)
                         (make-dialog-item :widget 'default-button :groupstart t 
                                :tabstop nil :background-color nil :box 
                                #.(make-box 140 195 200 220) :title "OK" 
                                :font (make-font nil :arial 16 '(:bold))
                                :set-value-fn 
                                #'(lambda (item new old) (values t t))
                                :name :default-button))
                      'dialog *cky-main-window* :name :cky-options
                      :title "CKY Options" :font (make-font :swiss :system 16 '(:bold)) 
                      :window-state nil :user-movable t :user-resizable nil 
                      :user-closable nil :user-shrinkable nil :user-scrollable nil 
                      :window-border :dialog-box
                      :pop-up-p t :visible-box (make-box 0 0 210 230)))
          (pop-up-dialog current-dialog)
          (close current-dialog)))

 

(defun select-algorithm () 
      (let ((current-dialog 
                    (open-dialog 
                          (list
                             (make-dialog-item :widget 'static-text 
                                    :tabstop nil :background-color t 
                                    :box #.(make-box 130 10 400 26)
                                    :font (make-font nil :arial 16 '(:bold))
                                    :name :text0 :value "Available Parsing Algorithms")
                             (make-dialog-item :widget 'static-text 
                                    :tabstop nil :background-color t 
                                    :box #.(make-box 15 23 475 39)
                                    :font (make-font nil :arial 16 '(:bold))
                                    :name :text1 :value "---------------------------------------------------------------------------------------------------------------------")
                             (make-dialog-item :widget 'radio-button
                                    :tabstop nil :background-color t 
                                    :box #.(make-box 20 50 200 70)
                                    :font (make-font nil :arial 16 '(:bold))
                                    :set-value-fn
                                    '(lambda (item new old) 
                                         (setq *parser* "cky")
                                         (setf (stream-title *cky-subdisp*)
                                                   (concatenate 'string
                                                         "CKY Main Window - Using Parser: "
                                                         *parser*)))
                                    :name :cky :title "Basic CKY Parser"
                                    :cluster 0 :value (equal *parser* "cky"))
                             (make-dialog-item :widget 'radio-button
                                    :tabstop nil :background-color t 
                                    :box #.(make-box 20 80 200 100)
                                    :font (make-font nil :arial 16 '(:bold))
                                    :set-value-fn
                                    '(lambda (item new old) 
                                         (setq *parser* "ckydot")
                                         (setf (stream-title *cky-subdisp*)
                                                   (concatenate 'string
                                                         "CKY Main Window - Using Parser: "
                                                         *parser*)))
                                    :name :ckydot :title "With Dotted Rules"
                                    :cluster 0 :value (equal *parser* "ckydot"))
                             (make-dialog-item :widget 'radio-button
                                    :tabstop nil :background-color t 
                                    :box #.(make-box 20 110 480 130)
                                    :font (make-font nil :arial 16 '(:bold))
                                    :set-value-fn
                                    '(lambda (item new old) 
                                         (setq *parser* "ckyre")
                                         (setf (stream-title *cky-subdisp*)
                                                   (concatenate 'string
                                                         "CKY Main Window - Using Parser: "
                                                         *parser*)))
                                    :name :ckyre
                                    :title "With Dotted Rules and Regular Expressions on the Right Hand Side"
                                    :cluster 0 :value (equal *parser* "ckyre"))
                             (make-dialog-item :widget 'radio-button
                                    :tabstop nil :background-color t 
                                    :available-p nil
                                    :box #.(make-box 20 140 300 160)
                                    :font (make-font nil :arial 16 '(:bold))
                                    :set-value-fn
                                    '(lambda (item new old) 
                                         (setq *parser* "ckypr")
                                         (setf (stream-title *cky-subdisp*)
                                                   (concatenate 'string
                                                         "CKY Main Window - Using Parser: "
                                                         *parser*)))
                                    :name :ckypr
                                    :title "With Earley Style Predictions"
                                    :cluster 0 :value (equal *parser* "ckypr"))                             
                             (make-dialog-item :widget 'radio-button
                                    :tabstop nil :background-color t 
                                    :available-p nil
                                    :box #.(make-box 20 170 480 190)
                                    :font (make-font nil :arial 16 '(:bold))
                                    :set-value-fn
                                    '(lambda (item new old) 
                                         (setq *parser* "ckyla")
                                         (setf (stream-title *cky-subdisp*)
                                                   (concatenate 'string
                                                         "CKY Main Window - Using Parser: "
                                                         *parser*)))
                                    :name :ckyla
                                    :title "With Earley Style Predictions and Lookahead"
                                    :cluster 0 :value (equal *parser* "ckyla"))                             
                             (make-dialog-item :widget 'cancel-button :groupstart t 
                                    :tabstop nil :background-color nil :box 
                                    #.(make-box 350 200 410 225) :title "Help" 
                                    :available-p nil
                                    :font (make-font nil :arial 16 '(:bold))
                                    :set-value-fn 
                                    '(lambda (item new old) (parser-help))
                                    :name :help-button)
                             (make-dialog-item :widget 'default-button :groupstart t 
                                    :tabstop nil :background-color nil :box 
                                    #.(make-box 420 200 480 225) :title "OK" 
                                    :font (make-font nil :arial 16 '(:bold))
                                    :set-value-fn 
                                    #'(lambda (item new old) (values t t))
                                    :name :default-button))
                          'dialog *cky-main-window* :name :cky-parser
                          :title "CKY Parser" :font (make-font :swiss :system 16 '(:bold)) 
                          :window-state nil :user-movable t :user-resizable nil 
                          :user-closable nil :user-shrinkable nil :user-scrollable nil 
                          :window-border :dialog-box
                          :pop-up-p t :visible-box (make-box 0 0 490 235))))
          (pop-up-dialog current-dialog)
          (close current-dialog)))
      
      

 
(defun display-information () 
      (let ((current-dialog 
                    (open-dialog 
                          (list
                             (make-dialog-item :widget 'static-text 
                                    :tabstop nil :background-color t 
                                    :box #.(make-box 120 10 400 26)
                                    :font (make-font nil :arial 16 '(:bold))
                                    :value "Information on CKY Settings")
                             (make-dialog-item :widget 'static-text 
                                    :tabstop nil :background-color t 
                                    :box #.(make-box 15 23 415 39)
                                    :font (make-font nil :arial 16 '(:bold))
                                    :value "---------------------------------------------------------------------------------------------------------------------")
                             (make-dialog-item :widget 'static-text 
                                    :tabstop nil :background-color t 
                                    :box #.(make-box 15 45 150 65)
                                    :font (make-font nil :arial 16 '(:condensed))
                                    :value "Parsing Algorithm")
                             (make-dialog-item :widget 'static-text 
                                    :tabstop nil :background-color t 
                                    :box #.(make-box 15 75 150 95)
                                    :font (make-font nil :arial 16 '(:condensed))
                                    :value "Current Grammar")
                             (make-dialog-item :widget 'static-text 
                                    :tabstop nil :background-color t 
                                    :box #.(make-box 15 105 150 125)
                                    :font (make-font nil :arial 16 '(:condensed))
                                    :value "Current Lexicon")
                             (make-dialog-item :widget 'static-text 
                                    :tabstop nil :background-color t 
                                    :box #.(make-box 15 135 150 155)
                                    :font (make-font nil :arial 16 '(:condensed))
                                    :value "Current Sentence")
                             (make-dialog-item :widget 'static-text 
                                    :tabstop nil :background-color t 
                                    :box #.(make-box 15 165 150 185)
                                    :font (make-font nil :arial 16 '(:condensed))
                                    :value "Parse Tree Display")
                             (make-dialog-item :widget 'static-text 
                                    :tabstop nil :background-color t 
                                    :box #.(make-box 15 195 150 215)
                                    :font (make-font nil :arial 16 '(:condensed))
                                    :value "Tracing")
                             (make-dialog-item :widget 'static-text 
                                    :tabstop nil :background-color t 
                                    :box #.(make-box 15 225 150 245)
                                    :font (make-font nil :arial 16 '(:condensed))
                                    :value "Graphic Chart")
                             (make-dialog-item :widget 'static-text 
                                    :tabstop nil :background-color t 
                                    :box #.(make-box 160 45 420 65)
                                    :font (make-font nil :arial 16 '(:condensed :bold))
                                    :value (cond
                                                            ((equal *parser* "cky") "Basic CKY parser") 
                                                            ((equal *parser* "ckydot") "CKY with Dotted Rules") 
                                                            ((equal *parser* "ckyre") "Dotted Rules + Regular Expressions rhs") 
                                                            ((equal *parser* "ckypr") "CKY with Earley-style prediction") 
                                                            ((equal *parser* "ckyla") "CKY with Lookahead") 
                                                            ((equal *parser* "ckypl") "Earley-style + Lookahead")))
                             (make-dialog-item :widget 'static-text 
                                    :tabstop nil :background-color t 
                                    :box #.(make-box 160 75 400 95)
                                    :font (make-font nil :arial 16 '(:condensed :bold))
                                    :value (if *grammar*
                                                    (enough-namestring *grammar-filename*)
                                                    "None"))
                             (make-dialog-item :widget 'static-text 
                                    :tabstop nil :background-color t 
                                    :box #.(make-box 160 105 400 125)
                                    :font (make-font nil :arial 16 '(:condensed :bold))
                                    :value (if *lexicon*
                                                    (enough-namestring *lexicon-filename*)
                                                    "None"))
                             (make-dialog-item :widget 'static-text 
                                    :tabstop nil :background-color t 
                                    :box #.(make-box 160 135 400 155)
                                    :font (make-font nil :arial 16 '(:condensed :bold))
                                    :value (if (string= "" *current-sentence*)
                                                    "None"
                                                    *current-sentence*))
                             (make-dialog-item :widget 'static-text 
                                    :tabstop nil :background-color t 
                                    :box #.(make-box 160 165 400 185)
                                    :font (make-font nil :arial 16 '(:condensed :bold))
                                    :value (if *show-trees* "Enabled" "Disabled"))
                             (make-dialog-item :widget 'static-text 
                                    :tabstop nil :background-color t 
                                    :box #.(make-box 160 195 400 215)
                                    :font (make-font nil :arial 16 '(:condensed :bold))
                                    :value (if *trace* "Enabled" "Disabled"))
                             (make-dialog-item :widget 'static-text 
                                    :tabstop nil :background-color t 
                                    :box #.(make-box 160 225 400 245)
                                    :font (make-font nil :arial 16 '(:condensed :bold))
                                    :value (if *show-chart* "Enabled" "Disabled"))
                             (make-dialog-item :widget 'default-button :groupstart t 
                                    :tabstop nil :background-color nil :box 
                                    #.(make-box 360 255 420 280) :title "OK" 
                                    :font (make-font nil :arial 16 '(:bold))
                                    :set-value-fn 
                                    #'(lambda (item new old) (values t t))
                                    :name :default-button))
                          'dialog *cky-main-window* :name :cky-parser
                          :title "Environment Info" :font (make-font :swiss :system 16 '(:bold)) 
                          :window-state nil :user-movable t :user-resizable nil 
                          :user-closable nil :user-shrinkable nil :user-scrollable nil 
                          :window-border :dialog-box
                          :pop-up-p t :visible-box (make-box 0 0 430 290))))
          (pop-up-dialog current-dialog)
          (close current-dialog)))
         
         
          
 
(defun s-t-str (l) 
      (trunk-string 
          (string-trim "()" (format nil  "~A" l )) 25)) 
 


(defun trunk-string (s n) 
      (let ((sl (coerce s 'list))) 
          (if (> (length s) n) 
             (concatenate 'string 
                   (coerce (trunc-stl sl (- n 3)  nil) 'string)
                   "...") 
             (coerce (trunc-stl sl n  nil) 'string)))) 
  


(defun trunc-stl (sl n result) 
      (if (or (null sl) (zerop n)) 
         (reverse result) 
         (trunc-stl (cdr sl) (1- n) (cons (car sl) result)))) 

