;;; -*- Mode: LISP; Package: cky; Syntax: Common-lisp; -*-

(in-package :cky)



(defun ordered-insert (elem list)
      (if list
         (if (string< elem (car list))
            (cons elem list)
            (cons (car list) (ordered-insert elem (cdr list))))
         (list elem)))



(defun ordered-insert1 (elem list)
      (if list
         (if (string< (car elem) (caar list))
            (cons elem list)
            (rplacd list (ordered-insert1 elem (rest list))))
         (list elem)))



#|

(defun dest-insert (elem list)
      (cond ((null list) (list elem))
                  (t (d-insert elem list) list)))


 
(defun d-insert (elem list)
      (cond ((null (cdr list))
                   (cond  ((not (string< (car elem) (car (car list))))
                                 (setf (cdr list)(list elem)))
                               (t (setf (cdr list)(list (car list)))
                                  (setf (car list) elem))))
                  ((g-alphalessp (car elem) (car (cadr list)))
                   (setf (cdr list) (copy-tree list))
                   (setf (car list) elem))
                  (t (d-insert elem (cdr list)))))


(defun assq (x y)
      (assoc x y :test #'eq))



(defun aexplodec (a)
      (coerce (string a) 'list))



(defun ucons (element set)
      (cond ((member element set)
                   set)
                  (t (cons element set))))



(defun alphalessp (x y) 
      (char< x y))
     
|#



(defun scan-string (st)
      (delall-cky   "" (scan-aux-cky (coerce st 'list) nil)))

(defun delall-cky (x l)
      (cond ((null l) nil)
                  ((string=  x (car l)) (delall-cky x (cdr l)))
                  (t (cons (car l) (delall-cky x (cdr l))))))



(defun word-cky (lch)
      (trim-word-cky lch nil))

(defun trim-word-cky (lch  aux)
      (cond ((null lch)
                   (list (coerce (reverse aux) 'string)))
                  ((member (car lch)  *separators*)		
                   (cons (coerce (reverse aux) 'string) (cdr lch )))
                  (t (trim-word-cky (cdr lch) (cons (car lch) aux)))))



(defun scan-aux-cky (lch aux)
      (cond ((null lch) (reverse aux))
                  (t (let (( next-token  (word-cky lch)))
                          (scan-aux-cky (cdr next-token) 
                           (cons (car next-token) aux))))))



(defun no-blanks (s)
      (coerce (remove #\ (coerce s 'list)) 'string))


