;;; -*- Mode: LISP; Package: cky; Syntax: Common-lisp; -*-

(in-package :cky)


;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   cky-demo1.cl
;;; Short Desc: First demo on chart parsing
;;;            
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   8.9.91 - FB
;;; Author:     Fabio Baj 
;;; Modified by: Paolo Cattaneo
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================

(in-package :cky)

;;=====================================================================
;; The definition of demo1
;;=====================================================================

(defun start-demo-1 ( )
      (when 
               (create-demo-dialog  
                :window-title "CKY Demos"
                :title "Chart Parsing"
                :subtitle "Simple CKY"
                :window *cky-main-window*)
             (progn
                  (setq *cky-demo-running* t)
                  (catch 'stop-demo (main-demo-1))
                  (setq *cky-demo-running* nil))))
      
      

(defun main-demo-1 ()
      (setq *parser* "cky")
      (format-demo "This is the first CKY demo based 
on the example given in
\"Preliminary Analysis of a Breadth-First 
Parsing algorithm: Theoritical and 
Experimental Results\" by
Martin, Church, and Patil.

")
      (demo-loop)
      (format-demo "A CKY parser is a context-free parser
which takes as input a grammar and a 
sentence and produces as output a 
chart of labeled phrases.

")
      (demo-loop)
      (format-demo "A labeled phrase is a sequence of words
delimited by two brackets and labeled
with a category symbol. Let the triple 
<i,j,c> denote a phrase of category
c spanning the words between
ith position and the jth position.
This triple will be represented in a
two-dimensional matrix in which the entry
i,j contains the category symbol c.

")
      (demo-loop)
      (format-demo "Let's try the CKY out.
First, we make the Chart Parser main window
active for a moment. You notice there are two
display areas one for the main events and one
for timid comments on not so relevant operations.

")
      (demo-loop)
      (format-demo "The sentence we want to parse is 
\"They are flying planes\".
To parse a sentence we have
to load a grammar first.
We do this by pulling down the
<<Grammar>> menu and selecting
<<Load Grammar>>.
")
      (demo-loop)
      (format-demo"We load the grammar stored
in the file g0.

")
      (demo-loop)
      (when (windowp *grammar-dialog*)
             (close-cky-grammar-window t))
      (loadsyn (concatenate 'string
                             *pail-directory*
                             "cky\\grammars\\gram-0."))
      (set-grammar-menu-after-load)
      (demo-loop)                          
      (format-demo "In much the same way we load
lexicon l0. We do this by pulling down
the lexicon menu and choosing
the appropriate lexicon. 
Note that the lexicon provides a mapping
between words and categories.

")
      (demo-loop)
      (when (windowp *lexicon-dialog*)
             (close-cky-lexicon-window t))
      (loadlex (concatenate 'string
                            *pail-directory*
                            "cky\\lexicae\\lex-0."))
      (set-lexicon-menu-after-load)
      (demo-loop)
      (format-demo "Remember that if you want to make any
changes to the lexicon file 
you should use the lexicon menu.
For convinience you can use the highligh 
and delete directly from the lexicon list.

")
      (demo-loop)
      (format-demo "As you may suspect there are a few
options to set. Options like <<Show Parse Trees>>
or <<Show Graphic Chart>> should facilitate the
understanding of the parser inner workings. 

")
      (demo-loop)
      (setq *show-trees* nil)
      (setq *trace* nil)
      (setq *show-chart* nil)
      (setq *verbose* nil)
      (setq *chart-step* nil)
      (format-demo "Click on <<Show Graphic Chart>>
for graphics display of the chart parser
and <<Show Parse Trees>> for a graphics
display of the output and then click on 
<<Step Through Chart>> to gain control
over the algorithm.

")
      (options)
      (format-demo "We are now ready to test
run our sentence. You could either select <<Parse Sentence>>
from the <<Parser>> menu or <<Repeat Last Parse>>
from the same menu. We will run the 
algorithm for you.

")
      (demo-loop)
      (setq *current-sentence* '"they are flying planes")
      (setq *show-trees* t)
      (setq *trace* nil)
      (setq *show-chart* t)
      (setq *verbose* nil)
      (setq *chart-step* t)
      (format-demo "The algorithm will hang
waiting for you to click on the first active button
of the Chart Window.
Go ahead and click on the buttons until you reach
the end of the sentence. On the scrollable
parser tool window you will see the trace of 
the matching activity. The chart window will 
contain a graphical representation of
the matrix. Each cell contains the possible
reductions. The results, if any, will be 
displayed in the cell chart[0,length of string],
in this case then in cell chart[0,4].

Do not forget to guide the algorithm by clicking
on the active words.

After clicking on the last word the parser
returns two solutions which are then diplayed
in the form of a parse tree. Both
the chart cells and scrollable display
show the possible combinations of the
substrings (subsentences).

")
      (repeat-last-parse)
      (demo-loop)
      (format-demo "That's all folks!!! Thank you for using
the Chart Parser.

")
      (demo-loop)
      (when *chart-window*
             (close *chart-window*)
             (setq *chart-window* nil))
      (when *grammar-dialog*
             (close-cky-grammar-window t))
      (when *lexicon-dialog*
             (close-cky-lexicon-window t))
      (dolist (tree *cky-browsers*)
            (when (windowp tree) (close tree)))
      (setq *cky-browsers* nil))
			  




