;;; -*- Mode: LISP; Package: cky; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   cky-demo2.cl
;;; Short Desc: Second demo on chart parsing
;;;            
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   20.4.93
;;; Author:     Paolo Cattaneo & Fabio Baj
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================
(in-package :cky)


;;=====================================================================
;; The definition of demo1
;;=====================================================================

(defun start-demo-2 ( )
      (when 
               (create-demo-dialog  
                :window-title "CKY Demos"
                :title "Chart Parsing"
                :subtitle "Dotted CKY"
                :window *cky-main-window*)
             (progn
                  (setq *cky-demo-running* t)
                  (catch 'stop-demo (main-demo-2))
                  (setq *cky-demo-running* nil))))
      

 
(defun main-demo-2 ()
      (setq *parser* "cky")
      (format-demo 
           "This is the second CKY demo. The algorithm used
for this example is (again) based on
\"Preliminary Analysis of a Breadth-First 
Parsing algorithm: Theoritical and Experimental Results\" by
Martin, Church, and Patil.
")
      (demo-loop)
      (format-demo 
           "The original CKY algorithm used in demo 1
restricts right hand side categories to be
of length two at most, which is often an inconvenience.
To  get around  this  restriction  we  modify the 
basic CKY strategy by introducing a new
kind of object called a dotted rule.

")
      (demo-loop)
      (format-demo 
           "For this demo we will use
a grammar with some right-hand-sides greater than 2. It is important
to choose the right parser strategy before loading the grammar.
We choose the parser by clicking on the <<Choose Parser>> button
and by selecting the <<CKY with dotted rules>> algorithm.

")
      (demo-loop)
      (setq *parser* "ckydot")
      (select-algorithm)
      (format-demo 
           "The type of sentences
we want to parse are numbers in string form. 
A typical sentence for this example would be
\"nine hundred and twenty-one\"...Don\'t worry that should be clear
once the lexicon and the grammar are loaded.

")
      (demo-loop)
      (when (windowp *grammar-dialog*)
             (close-cky-grammar-window t))
      (loadsyn (concatenate 'string
                             *pail-directory*
                             "cky\\grammars\\gram-nb."))
      (set-grammar-menu-after-load)
      (format-demo 
           "We load the grammar stored
in the file gram-nb by using the grammar tool.

")
      (demo-loop)
      (format-demo 
           "As you can see there are grammar
rules of lenght 3 and 4 which could not be used in
the \"regular\" CKY algorithm.

")
      (demo-loop)
      (format-demo 
           "We then load the lexicon
which provides a mapping between words and categories.

")
      (demo-loop)
      (when (windowp *lexicon-dialog*)
             (close-cky-lexicon-window t))
      (loadlex (concatenate 'string
                            *pail-directory*
                            "cky\\lexicae\\lex-nb."))
      (set-lexicon-menu-after-load)
      (format-demo
           "We load the lexicon stored in the file lex-nb.

")
      (demo-loop)
      (format-demo
           "As you may have noticed the current
grammar and lexicon are intended to recognize syntactally correct numbers
up to 999 in string (character) form.

")
      (demo-loop)
      (format-demo
           "It is time now to select a few options for the parser
so that we can get a better feeling for the parsing activity.

")
      (demo-loop)
      (setq *show-trees* nil)
      (setq *trace* nil)
      (setq *show-chart* nil)
      (setq *verbose* nil)
      (setq *chart-step* nil)
      (options)
      (setq *show-trees* t)
      (setq *trace* nil)
      (setq *show-chart* t)
      (setq *verbose* nil)
      (setq *chart-step* nil)
      (format-demo
            "We are now ready to parse a
number... 921 as we have said before.
On the scrollable parser tool window you will see the
trace of the matching activity. The chart 
window will contain a graphical representation of
the matrix. Each cell contains the possible reductions.

You will guide the algorithm by clicking on the active words.

After clicking on the last word the parser returns two solutions
which are then diplayed in the form of a parse tree. Both
the chart cells and scrollable display show the possible
combinations of the substrings (subsentences).

")
      (demo-loop)
      (setq *current-sentence* "nine hundred and twenty b one")
      (repeat-last-parse)
      (format-demo
           "It is not advisable to use the same grammar with the
standard CKY algorithm. It just would not work. If you try you
will get messages of the kind \"Illegal Rule...\".

We recommend that you read the general help for the parsing
algorithms to understand the difference between the standard
and the dotted rule algorithm.

")
      (demo-loop)
      (format-demo 
           "You may want to enhance the grammar and lexicon to
accept larger numbers.

That's it. Have fun using CKY.

")
      (demo-loop)
      (when *chart-window*
             (close *chart-window*)
             (setq *chart-window* nil))
      (when *grammar-dialog*
             (close-cky-grammar-window t))
      (when *lexicon-dialog*
             (close-cky-lexicon-window t))
      (dolist (tree *cky-browsers*)
            (when (windowp tree) (close tree)))
      (setq *cky-browsers* nil))
			