 
(in-package :csp)



;;;=========================================================
;; Global Variables
;;;=========================================================

(defvar *queue*)
(defvar *all-distinct-values*)
(defvar *current-net*)



;; ==========================================
;; Class Definition CONSTRAINT-NETWORK
;; ==========================================

(defclass node ()
       ((name  
              :initarg :name
              :accessor name 
              :initform nil)
        (domain     
              :initarg :domain 
              :accessor domain
              :initform nil)
        (neighbors      
              :initarg :neighbors 
              :accessor neighbors
              :initform nil)
        (possible-values  
              :initarg :possible-values
              :accessor possible-values
              :initform nil)
        (view-container
            :initarg :view-container
            :accessor view-container
            :initform nil)         
        (graphic-node     
             :initarg :graphic-node
             :accessor graphic-node
             :initform nil)
        ;; --------------------------------------These are slot for drawing graphics
        (xpos           
             :initarg :xpos
             :accessor xpos
             :initform nil)      ; its x and y coordinates
        (ypos         
              :initarg  :ypos
              :accessor ypos
              :initform nil)     ; its x and y coordinates
        (radpos        
             :initarg  :radpos
             :accessor radpos
             :initform nil)      ; its position in radians on the loop
        (domain-button 
              :initarg :domain-button
              :accessor domain-button 
              :initform nil)))



(defmethod display ((n node))
      (format-display
           *csp-output-window*
           (display-string n)))
    


(defmethod display-string ((n node)) 
      (format nil
           " Node  ~a:  [~{~A ~}]   ~A" 
           (name n)
           (mapcar #'name (neighbors n))
           (if (> (number-of-values n) 10)
              (format nil
                   "Number of values: ~D" (number-of-values n))
              (format nil
                   "Poss. values: ~a" (possible-values n)))))



(defmethod number-of-values ((n node))
      (length (possible-values n)))
   


(defmethod make-copy ((nd node))
      (make-instance 'node 
             :name (name  nd) 
             :domain (domain nd)
             :possible-values  (possible-values nd)
             :neighbors (neighbors nd)))



(defmethod impossible-p ((n node))
      (null (possible-values n)))



(defmethod ambiguous-p ((n node))
      (> (number-of-values  n) 1))



;; ==========================================
;; Class Definition CONSTRAINT-NETWORK
;; ==========================================

(defclass constraint-network ()
       ((nodes
              :initarg :nodes
              :accessor nodes
              :initform nil)
        (main-networkp
               :accessor main-networkp
               :initarg :main-networkp
               :initform nil)
        (cnwindow
             :initarg :cnwindow 
             :accessor cnwindow 
             :initform nil)
        ))



(defmethod display ((net constraint-network))
      (format-display
           *csp-output-window*
           (display-string net)))



(defmethod display-string ((net constraint-network))
      (format nil "------------------------------------~%~{~A~%~}~%"
           (mapcar #' display-string (nodes net))
           (let ((n (reduce #'* (mapcar #'number-of-values
                                                      (nodes net )))))
               (if (> n 1)
                  (format nil "~&For ~:d possible solution~:p.~%" n)
                  ""))))



(defmethod impossible-p ((network constraint-network))
      "An impossible network is one with an impossible vertex."
      (some #'impossible-p (nodes network)))



(defmethod make-copy ((net constraint-network))
      (let ((newnet (make-instance 'constraint-network)))
          (setf (nodes newnet) 
                    (mapcar #'make-copy (nodes net)))
          ;; Put in the neighbors for each  node
          (dolist (n (nodes newnet)) 
                (setf (neighbors n)
                          (mapcar #'(lambda (neighbor)
                                                   (find-node (name neighbor) newnet))
                                 (neighbors n))))
          (when *graphics* 
                 (draw-graph newnet))
          newnet))

