;;; -*- Mode: LISP; Package: csp; Syntax: Common-lisp; -*-
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   csp-init.lisp
;;; Short Desc: general user interface for the  csp tool
;;;            
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   4. april 1992 - PC
;;; Author(s):  Paolo Cattaneo
;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;; 
;;; 
;;; --------------------------------------------------------------------------

(in-package :csp)



(defvar *CSP-MAIN-WINDOW* nil)
(defvar *CSP-OUTPUT-WINDOW* nil)
(defvar *open-csp-windows* nil)
(defvar *got-step-command* nil)
(defvar *csp-main-running* nil)
(defvar *csp-options* nil)
(defvar *current-csp-file* nil)
(defvar *single-step* nil)
(defvar *csp-main-menu* nil)
(defvar *stepper-text* "Enable stepper")
(defvar *csp-demo-running* nil)
(defvar *csp-buttons* nil)



(defclass csp-dialog (dialog)
       ())

(defclass csp-main-dialog (csp-dialog)
       ())

(defmethod bring-window-to-front :after ((cd csp-main-dialog))
        (in-package :csp)
        (set-csp-menubar)
     (setf (stream-title *lisp-main-window*) "PAIL - Constraint Propagation Module"))

(defmethod window-close ((cd csp-dialog))
      (close cd)
      (setf cd nil))

(defmethod window-close ((cd csp-main-dialog))
      (close cd)
      (setq *open-csp-windows* nil))



(defparameter *number-of-demos* 2)
(defvar *verbose-disp* nil)
(defvar *execution-terminated* nil)
(defvar *demo-in-execution*)

(defvar *verbose* t)



;;--------------------------------

(defvar *domain-loaded*)
(defvar *open-windows* nil)



;;-----------------------------This holds the main network

(defvar *main-network* nil)



;;-----------------------------This holds the current net during search

(defvar  *searching-network*)



;;-----------------------------This is useful to close everything

(defvar *open-displays-list* nil)
(defvar *open-display-nets* nil)



;;------------------------------variables for radio buttons

(defvar *graphics* nil)



;;------------------------------variables for stepping

(defvar *stop-at-arc* nil)
(defvar *stop-at-sol* nil)
(defvar *stop-at-prop* nil)
(setq *all-distinct-values* nil)
(defvar *aborted* nil)
(defvar *paused* nil)
(defvar *solutions* nil)

(defvar *nodesize* 30)


