(in-package :csp)
 


(defclass constraint-network-window (dialog)
       ((c-network
             :initarg :c-network
             :accessor c-network 
             :initform nil)
        (internal-win
             :initarg :internal-win
             :accessor internal-win
             :initform nil)))

(defclass internal-dialog (dialog)
       ((c-network 
             :initarg :c-network
             :accessor c-network 
             :initform nil)))


 
(defclass values-button-dialog-item (button)
       ((cnw-node 
              :initarg :cnw-node
              :accessor cnw-node
              :initform nil)))



(defmethod draw-graph ((n constraint-network))
      (let ((side-length (round (+ *nodesize* (* 1.5 *nodesize* (length (nodes n))))))
              (new-window nil))
          (placenodes n
              (truncate side-length 2)
              (truncate side-length 2)
              (net-radius n))
          (setf new-window 
                    (open-dialog ()
                          'constraint-network-window
                          *csp-main-window* :pop-up-p nil
                          :user-closable nil :user-resizable t
                          :title (if (main-networkp n)
                                       "CSP: Main Network"
                                       "CSP: Searching Network")
                          :visible-box
                          (make-box 0 0
                                 (min
                                      (+ 20 side-length)
                                      (round (* 0.75 (box-width (window-interior *csp-main-window*)))))
                                 (min
                                      (+ 50 side-length)
                                      (round (* 0.75 (box-height (window-interior *csp-main-window*))))))
                          :c-network n))
          (install-buttons new-window)
          (setf (cnwindow n) new-window)))



(defmethod install-buttons ((cnw constraint-network-window))
      (update-dialog cnw
            (list
               (make-dialog-item :widget 'button
                      :title "Help"
                      :available-p nil
                      :set-value-fn '(lambda (&rest x) (net-help))
                      :font (make-font nil :arial 16 '(:bold))
                      :box (make-box
                                      0
                                      0
                                      (round (/ (box-width (window-interior cnw)) 2))
                                      30))
               (make-dialog-item :widget 'button
                      :title "Close"
                      :set-value-fn `(lambda (&rest x)
                                                     (close ,cnw) t)
                      :font (make-font nil :arial 16 '(:bold))
                      :box (make-box
                                      (round (/ (box-width (window-interior cnw)) 2))
                                      0
                                      (box-width (window-interior cnw))
                                      30))))
      (setf (internal-win cnw)
                (open-dialog () 'internal-dialog cnw :pop-up-p nil
                      :window-exterior
                      (make-box
                             0 30
                             (box-width (window-interior cnw))
                             (box-height (window-interior cnw)))
                      :user-scrollable t :user-movable nil
                      :user-shrinkable nil :user-closable nil
                      :user-resizable nil))
      (setf (c-network (internal-win cnw)) (c-network cnw))
      (dolist (nd (nodes (c-network cnw)))
            (let ((h (xpos nd))
                    (v (ypos nd))
                    (button nil))
                (setf button
                          (make-dialog-item :widget 'values-button-dialog-item
                                 :box (make-box
                                                 (- h 20)
                                                 (- v (truncate *nodesize* 6))
                                                 (+ h 20)
                                                 (+ (- v (truncate *nodesize* 6)) 20))
                                 :set-value-fn #'(lambda (item new old)
                                                                  (display-values (cnw-node item)) t)
                                 :title (write-to-string (number-of-values nd))
                                 :font (make-font nil :arial 16 '(:bold))
                                 :cnw-node nd))
                (open-dialog-item button (internal-win cnw))
                (open-dialog-item
                      (make-dialog-item :widget 'static-text
                             :box (make-box
                                             (- h (round (* 3.5 (length (write-to-string (name nd))))))
                                             (- v (truncate *nodesize* 1.4))
                                             (+ h (round (* 3.5 (length (write-to-string (name nd))))))
                                             (+ (- v (truncate *nodesize* 1.4)) 14))
                             :value (write-to-string (name nd))
                             :font (make-font :modern nil 14 '(:bold)))
                      (internal-win cnw))
                (setf (view-container nd) (internal-win cnw))
                (setf (graphic-node nd) button)))
                (paint-constraint-network cnw))


  
(defmethod redisplay-window :after ((cnw internal-dialog) &optional box)
      (when (c-network cnw)
             (dolist (nd (nodes (c-network cnw)))
                   (paint nd cnw)
                   (dolist (source-nd (nodes (c-network cnw)))
                         (dolist (target-nd (neighbors source-nd))
                               (offsetarrow cnw 
                                    (xpos source-nd) (ypos source-nd )
                                    (xpos target-nd) (ypos target-nd )))))))


(defmethod resize-window :after ((cnw constraint-network-window) position)
      (when (dialog-items cnw)
             (set-dialog-item-box (first (dialog-items cnw))
                   (make-box
                          0 0
                          (round (/ (box-width (window-interior cnw)) 2))
                          30))
             (set-dialog-item-box (second (dialog-items cnw))
                   (make-box
                          (round (/ (box-width (window-interior cnw)) 2))
                          0
                          (box-width (window-interior cnw))
                          30))
             (setf (window-exterior (internal-win cnw))
                       (make-box
                              0 30
                              (box-width (window-interior cnw))
                              (box-height (window-interior cnw))))))


(defmethod paint-constraint-network ((cnw dialog))
      (dolist (nd (nodes (c-network cnw)))
            (paint nd (internal-win cnw))
            (draw-arrows cnw)))



(defun net-disp-width (n)
      (round (* 2.5 (net-radius n))))



(defun placenodes (net cx cy rad)
      (let ((step (/ (* 2 pi) (length (nodes net))))
              (r (- pi))
              (x 0)
              (y 0))
          (dolist (nd (nodes net))
                (setq x (+ (* (cos r) rad   ) cx))
                (setq y (+ (* (sin r) rad ) cy))
                (setf (xpos nd) (floor x))
                (setf (ypos nd) (floor y))
                (setq r (+ r step)))))

 

(defmethod paint ((nd node) disp)
      (let ((h (xpos nd))
              (v (ypos nd)))
          (draw-circle disp (make-position h v) *nodesize*)))



(defmethod draw-arrows ((cnw dialog))
      (dolist (source-nd (nodes (c-network cnw)))
            (dolist (target-nd (neighbors source-nd))
                  (offsetarrow (internal-win cnw) 
                       (xpos source-nd) (ypos source-nd )
                       (xpos target-nd) (ypos target-nd )))))
   
    

(defmethod offsetarrow ((cnw dialog) x1 y1 x2 y2)
      (let* ((posangle (if (= x1 x2)
                                         (if (> y1 y2) (- (/ pi 2)) (/ pi 2))
                                         (atan (/ (- y2 y1) (- x2 x1)))))
                (angle (if (> x1 x2)
                                 (+ pi posangle) posangle))
                (sx1 (round (+ x1 (* (cos angle) *nodesize*))))
                (sx2 (round (- x2 (* (cos angle) *nodesize*))))
                (sy1 (round (+ y1 (* (sin angle) *nodesize*))))
                (sy2 (round (- y2 (* (sin angle) *nodesize*)))))
          (move-to cnw (make-position sx1 sy1))
          (draw-to cnw (make-position sx2 sy2))
          (draw-arrow cnw sx1 sy1 sx2 sy2)))



(defun net-radius (net)
      (let*
              ((nnd (length (nodes net)))
               (2R (/ (* 1.5 *nodesize*)
                         (sin (/ pi nnd)))))
          (round 2R)))



(defun highlight-node (node)
      (let ((win (view-container node)))
          (when win
                 (fill-circle win 
                    (make-position (xpos node) (ypos node))
                    (1- *nodesize*))
                 (sleep 0.5))))



(defun erase-node (node)
      (let ((win (view-container node)))
          (when win
                 (erase-contents-circle win 
                      (make-position (xpos node) (ypos node))
                      (1- *nodesize*))
                 (sleep 0.5))))



(defmethod display-values ((nd node))
      (message (format nil
                               "Domain of Node  ~A: "
                               (write-to-string (name nd))))
      (message (format nil
                               "~{~A ~}~%" 
                               (possible-values nd))))



(defvar *arrowtheta* (/ pi 7))
(defvar *arrowx* 7)
(defvar *arrowy* 7)



(defun draw-arrow (win x1 y1 x2 y2)
      (let* ((angle (if (= x1 x2) 
                                 (if (< y1 y2) (- (/ pi 2)) (/ pi 2))
                                 (atan (/ (- y2 y1) (- x2 x1)))))
                (posangle (cond
                                                ((> y2 y1) (if (> x2 x1)
                                                                     (+ angle pi)
                                                                     angle))
                                                ((> x2 x1) (+ angle pi))
                                                (t angle)))
                (angle-near (- posangle *arrowtheta*))
                (angle-far (+ posangle *arrowtheta*))
                (sx1 (+ x2 (round (* (cos angle-near) *arrowx*))))
                (sy1 (+ y2 (round (* (sin angle-near) *arrowx*))))
                (sx2 (+ x2 (round (* (cos angle-far) *arrowx*))))
                (sy2 (+ y2 (round (* (sin angle-far) *arrowx*)))))
          (move-to win (make-position x2 y2))
          (draw-to win (make-position sx1 sy1))
          (move-to win (make-position x2 y2))
          (draw-to win (make-position sx2 sy2))))

    
