;;; -*- Mode: LISP; Package: csp; Syntax: Common-lisp; -*-
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   csp-init.lisp
;;; Short Desc: general user interface for the  csp tool
;;;            
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   4. april 1992 - PC
;;; Author(s):  Paolo Cattaneo
;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;; 
;;; 
;;; --------------------------------------------------------------------------

(in-package :csp)



(defun csp ()
      (setq pail-lib::*csp-module-loaded* t)
      (in-package :csp)
      (create-csp-window)
;;;       (set-help-csp)
     )



;;; (defun set-help-csp ()
;;;   (set-help :general "csp\\help\\csp-desc.hlp"))
            



;;; OKKIO set button sizes correctly

(defun create-csp-window ()
      (unless (windowp *csp-main-window*)
            (progn
                 (setq *csp-main-window*
                       (open-dialog () 'csp-main-dialog *lisp-main-window* :pop-up-p nil
                             :title "CSP Main"
                             :name ':csp-main
                             :user-closable nil
                             :background-color (make-rgb :red 0 :green 128 :blue 128) 
                             :window-exterior (clipping-box *lisp-main-window*)))
                 (set-csp-menubar)
                 (add-to-window-menu
                       (stream-title *csp-main-window*)
                       (object-name *csp-main-window*))
                 (create-csp-dialogs))))


            
(defun create-csp-dialogs ()
      (let* ((*number-of-buttons* 4)           
                (box (window-interior *csp-main-window*))
                (h-indent (round (* 0.2 (box-width box))))
                (v-indent (round (* 0.2 (- (box-height box) 20))))
                (h-size (- (box-width box) (* 2 h-indent)))
                (button-width (round (/ h-size *number-of-buttons*)))
                (button-height 25)
                (help-button nil)
                (out-dialog nil))
          (setq out-dialog
                (open-dialog () 'dialog *csp-main-window*
                      :pop-up-p nil
                      :title "CSP: Output"
                      :user-closable nil
                      :user-shrinkable t
                      :user-resizable nil
                      :user-scrollable nil
                      :user-movable t
                      :window-border :dialog-box
                      :window-interior
                      (make-box 
                             h-indent 
                             (+ v-indent button-height)
                             (- (box-width box) h-indent)
                             (- (box-height box) v-indent))))
          (setq *csp-output-window*
                (open-stream
                      'text-edit-window out-dialog :output
                      :name ':csp-output
                      :user-closable nil
                      :user-shrinkable nil
                      :user-resizable nil
                      :user-scrollable t
                      :user-movable nil
                      :font (make-font :modern nil 14)
                      :window-exterior
                      (make-box
                             0 25
                             (box-width (visible-box out-dialog))
                             (box-height (visible-box out-dialog)))))
          (setq help-button
                (make-dialog-item :widget 'button
                       :title "Help"
                       :set-value-fn #'(lambda (&rest x) (stepper-help))
                       :font (make-font nil :arial 16 '(:bold))
                       :available-p nil
                       :box (make-box
                                       0 0 (round (/ (box-width (visible-box out-dialog)) *number-of-buttons*)) 25)))
          (push
                (make-dialog-item :widget 'button
                       :title "Exit"
                       :set-value-fn #'(lambda (&rest x) (csp-stepper-exit))
                       :font (make-font nil :arial 16 '(:bold))
                       :available-p nil
                       :box (make-box
                                       (round (/ (box-width (visible-box out-dialog)) *number-of-buttons*)) 0
                                       (round (/ (* 2 (box-width (visible-box out-dialog))) *number-of-buttons*)) 25))
                *csp-buttons*)
           (push
                (make-dialog-item :widget 'button
                       :title "Skip"
                       :set-value-fn #'(lambda (&rest x) (csp-stepper-continue))
                       :font (make-font nil :arial 16 '(:bold))
                       :available-p nil
                       :box (make-box
                                       (round (/ (* 2 (box-width (visible-box out-dialog))) *number-of-buttons*)) 0
                                       (round (/ (* 3 (box-width (visible-box out-dialog))) *number-of-buttons*)) 25))
                *csp-buttons*)
           (push
                (make-dialog-item :widget 'button
                       :title "Step"
                       :set-value-fn #'(lambda (&rest x) (csp-stepper-step))
                       :font (make-font nil :arial 16 '(:bold))
                       :available-p nil
                       :box (make-box
                                       (round (/ (* 3 (box-width (visible-box out-dialog))) *number-of-buttons*)) 0
                                       (box-width (visible-box out-dialog)) 25))
                *csp-buttons*)
          (update-dialog out-dialog (cons help-button *csp-buttons*))))
                     
       

;;; (defun stepper-help ()
;;;       (make-instance 'help-window
;;;              :filename (concatenate 'string
;;;                                       *pail-directory*
;;;                                       "csp:help:csp-stepper.help")
;;;              :view-size #@(350 250)
;;;              :direction :output
;;;              :grow-icon-p t
;;;              :window-title "CSP: Stepper HELP"
;;;              :view-font
;;;              '("Helvetica" 12 :srccopy :bold)))



(defun csp-stepper-continue ()
      (setq *got-step-command* :go))



(defun csp-stepper-step ()
      (setq *got-step-command* :next-step))



(defun enable-stepper ()
      (dolist (button *csp-buttons*)
            (set-dialog-item-available-p button t)))



(defun disable-stepper ()
      (dolist (button *csp-buttons*)
            (set-dialog-item-available-p button nil)))



(defun csp-stepper-exit (&rest nulla)
      (declare (ignore nulla))
      (set-stepper)
      (setq *got-step-command* nil)
      (when *csp-main-running*
             (throw 'aborted nil))
      t)

(defun csp-new ()
     (:new *csp-main-window*))


(defun csp-close ()
     (let ((window (front-window *csp-main-window*)))
     (:close window)))

(defun csp-print ()
     (:print (front-window *csp-main-window*)))

(defun csp-open ()
      (pail-open *csp-main-window*))                  
             
(defun csp-save ()
      (pail-save *csp-main-window*))                  
             
(defun csp-save-as ()
      (pail-save-as *csp-main-window*))                


(defvar *csp-file-menu* nil)

(setq *csp-file-menu*
      (make-menu-item :title "~File" :value
             (open-menu 
                   (list 
                      (make-menu-item :title "~New"
                             :value 'csp-new :available-p t
                             :selected-p nil :font nil :event-synonym 
                             '(control-key #\N))
                      (make-menu-item :title "~Open"
                             :value 'csp-open :available-p t
                             :selected-p nil :font nil :event-synonym 
                             '(control-key #\O))
                      (make-menu-item :title "~Close"
                             :value 'csp-close :available-p t
                             :selected-p nil :font nil)
                      menu-separator
                      (make-menu-item :title "Load CS Problem..."
                             :name ':load-csp-problem
                             :value 'load-csp-problem :available-p t
                             :selected-p nil :font nil)
                      (make-menu-item :title "View Current Problem"
                             :name ':view-current-problem
                             :value 'view-current-problem :available-p nil
                             :selected-p nil :font nil)
                      menu-separator
                      (make-menu-item :title "~Save"
                             :value 'csp-save :available-p t
                             :selected-p nil :font nil :event-synonym 
                             '(control-key #\S))
                      (make-menu-item :title "Save ~As"
                             :value 'pail-save :available-p t
                             :selected-p nil :font nil)
                      menu-separator
                      (make-menu-item :title "~Print"
                             :value 'csp-print :available-p t
                             :selected-p nil :font nil :event-synonym 
                             '(control-key #\S))
                      menu-separator
                      (make-menu-item :name :help :title "~Help"
                             :value 'csp-file-help :available-p nil
                             :selected-p nil :font nil :event-synonym 
                             '(control-key #\H))
                      (make-menu-item :title "E~xit from CSP"
                             :value 'quit-csp :available-p t
                             :selected-p nil :font nil :event-synonym 
                             '(control-key #\X)))
                   'pop-up-menu *lisp-main-window* :name ':*csp-file-menu* :title '"" 
                   :selection-function 'funcall-menu-item)))



(defun quit-csp ()
      (remove-from-window-menu (object-name *csp-main-window*))
      (window-close *csp-main-window*)
      (setq *csp-main-window* nil)
      (setq *csp-buttons* nil)
      (setq *current-csp-file* nil)
      (setq pail-lib::*csp-module-loaded* nil)
      (make-available :csp))



(defun load-csp-problem ()
      (let ((file 
                       (ask-user-for-existing-pathname
                        "Constraint satisfaction problem to load"
                        :stream  *csp-main-window*
                        :allowed-types '(("CSP files" . "*.csp")("All Files"  . "*.*"))
                        :host (concatenate 'string *pail-directory* "csp\\problems\\")
                        )))
          (when file
                 (process-pending-events)
                 (setq *domain-loaded* file)
                 (setf *current-csp-file* file)
                 (acl::clear-page *csp-output-window*)
                 (format-display *csp-output-window*
                      (format nil "Loading file: ~A~%~%" file))
                 (reset-custom-functions)
                 (if (load file)
                    (progn
                         (if *main-network* 
                            (progn
                                 (display *main-network*)
                                 (possible-solutions-message)
                                 (format-display *csp-output-window*
                                      (format nil
                                           "~A succesfully loaded.~%~%"
                                           file)))
                            (problems-during-loading file))
                         (set-menu-after-load))
                    (problems-during-loading file)))))


(defun set-menu-after-load ()
;;;       (set-menu-item-available-p
;;;             (find-named-object ':load-csp-problem *csp-file-menu*) nil)
;;;       (set-menu-item-available-p
;;;             (find-named-object ':load-csp-problem *csp-main-menu*) nil)
      (set-menu-item-available-p
            (find-named-object ':run-csp *csp-main-menu*) t)
      (when *main-network*
            (set-menu-item-available-p
                   (find-named-object ':view-current-problem *csp-file-menu*) t)))
             
            
       
(defun set-menu-before-load ()
      (set-menu-item-available-p
            (find-named-object ':load-csp-problem *csp-file-menu*) t)
      (set-menu-item-available-p
            (find-named-object ':load-csp-problem *csp-main-menu*) t)
      (set-menu-item-available-p
            (find-named-object ':run-csp *csp-main-menu*) nil)
      (set-menu-item-available-p
            (find-named-object ':view-current-problem *csp-file-menu*) nil))

            
              
(defun view-current-problem ()
      (te::load-file
             (open-stream
                   'text-edit-window
                   *csp-main-window*
                   :io)
             *current-csp-file*))



(setq *csp-main-menu*
      (make-menu-item :title "CS ~Main" :value
             (open-menu 
                   (list 
                      (make-menu-item :title "Load CS Problem ..."
                             :name ':load-csp-problem
                             :value 'load-csp-problem :available-p t)
                      (make-menu-item :title "Run Constraint Propagation"
                             :name ':run-csp
                             :value 'run-csp :available-p nil)
                      (make-menu-item :title "Display Solutions"
                             :name ':display-solutions
                             :value 'display-solutions :available-p nil)
                      menu-separator
                      (make-menu-item :title *stepper-text*
                             :name ':set-stepper
                             :value 'set-stepper :available-p t)
                      (make-menu-item :title "CSP Options..."
                             :name ':csp-options
                             :value 'csp-options :available-p t)
                      menu-separator
                      (make-menu-item :title "Environment Info"
                             :name ':display-environment
                             :value 'display-environment :available-p nil))
                   'pop-up-menu *lisp-main-window* :name ':*csp-main-menu* :title '"" 
                   :selection-function 'funcall-menu-item)))



(defun run-csp ()
      (when *graphics* 
             (when *open-display-nets*
                    (dolist (item *open-display-nets*)
                          (when (windowp (window item))
                                 (close (window item))
                                 (setf (window item) nil)))
                    (setq *open-display-nets* nil))
             (when *aborted*
                    (close (window *main-network*))
                    (setf (window *main-network*) nil))
             (process-pending-events)
             (when (not (windowp (window *main-network*)))
                    (draw-graph *main-network*)))
      (setq *aborted* nil)
      (setq *paused* nil)
      (setq *csp-main-running* t)
      (acl::clear-page *csp-output-window*)
      (catch 'aborted (csp-main *main-network*))
      (setq *csp-main-running* nil)
      (set-menu-item-available-p
            (find-named-object ':display-solutions *csp-main-menu*) t))
      




(defun set-stepper ()
      (if *single-step*
         (progn
              (set-menu-item-title
                    (find-named-object ':set-stepper *csp-main-menu*)
                    *stepper-text*)
              (disable-stepper)
              (setq *stop-at-arc* nil)
              (setq *single-step* nil))
         (progn
              (set-menu-item-title
                    (find-named-object ':set-stepper *csp-main-menu*)
                    "Disable Stepper")
              (enable-stepper)
              (setq *stop-at-arc* t)
              (setq *single-step* t))))





(defun csp-options ()
      (let ((current-dialog nil))
;;;           (set-help :general "cky\\help\\opt-help.gen"
;;;            :technical "cky\\help\\opt-help.tec")
          (setq current-dialog
                (open-dialog 
                      (list
                         (make-dialog-item :widget 'static-text 
                                :tabstop nil :background-color t 
                                :box #.(make-box 25 10 260 26)
                                :font (make-font nil :arial 16 '(:bold))
                                :name :text0 :value "Constraint Propagation Tool Options")
                         (make-dialog-item :widget 'static-text 
                                :tabstop nil :background-color t 
                                :box #.(make-box 15 23 265 39)
                                :font (make-font nil :arial 16 '(:bold))
                                :name :text1 :value "----------------------------------------------------------------")
                         (make-dialog-item :widget 'check-box
                                :tabstop nil :background-color t 
                                :box #.(make-box 15 45 195 65)
                                :font (make-font nil :arial 16 '(:bold))
                                :set-value-fn
                                '(lambda (item new old)
                                     (setq *verbose* (not *verbose*)) t)
                                :name :verbose :title "Verbose Output"
                                :value *verbose*)
                         (make-dialog-item :widget 'check-box
                                :tabstop nil :background-color t 
                                :box #.(make-box 15 75 195 95)
                                :font (make-font nil :arial 16 '(:bold))
                                :set-value-fn
                                '(lambda (item new old)
                                     (setq *graphics* (not *graphics*)) t)
                                :name :verbose :title "Graphics"
                                :value *graphics*)
                         (make-dialog-item :widget 'check-box
                                :tabstop nil :background-color t 
                                :box #.(make-box 15 105 195 125)
                                :font (make-font nil :arial 16 '(:bold))
                                :set-value-fn
                                '(lambda (item new old)
                                     (setq *all-distinct-values* (not *all-distinct-values*)) t)
                                :name :verbose :title "All Distinct Values"
                                :value *all-distinct-values*)
                         (make-dialog-item :widget 'check-box
                                :tabstop nil :background-color t 
                                :box #.(make-box 15 135 265 155)
                                :font (make-font nil :arial 16 '(:bold))
                                :set-value-fn
                                '(lambda (item new old)
                                     (setq *stop-at-prop* (not *stop-at-prop*)) t)
                                :name :verbose :title "Stop After Constraint Propagation"
                                :value *stop-at-prop*)
                         (make-dialog-item :widget 'check-box
                                :tabstop nil :background-color t 
                                :box #.(make-box 15 165 195 185)
                                :font (make-font nil :arial 16 '(:bold))
                                :set-value-fn
                                '(lambda (item new old)
                                     (setq *stop-at-sol* (not *stop-at-sol*)) t)
                                :name :verbose :title "Stop At Every Solution"
                                :value *stop-at-sol*)
                         (make-dialog-item :widget 'cancel-button :groupstart t 
                                :tabstop nil :background-color nil :box 
                                #.(make-box 140 195 200 220) :title "Help" 
                                :available-p nil
                                :font (make-font nil :arial 16 '(:bold))
                                :set-value-fn 
                                '(lambda (item new old) (csp-options-help))
                                :name :help-button)
                         (make-dialog-item :widget 'default-button :groupstart t 
                                :tabstop nil :background-color nil :box 
                                #.(make-box 210 195 270 220) :title "OK" 
                                :font (make-font nil :arial 16 '(:bold))
                                :set-value-fn 
                                #'(lambda (item new old) (values t t))
                                :name :default-button))
                      'dialog *csp-main-window* :name :cky-options
                      :title "CSP Options" :font (make-font :swiss :system 16 '(:bold)) 
                      :window-state nil :user-movable t :user-resizable nil 
                      :user-closable nil :user-shrinkable nil :user-scrollable nil 
                      :window-border :dialog-box
                      :pop-up-p t :visible-box (make-box 0 0 280 230)))
          (pop-up-dialog current-dialog)
          (close current-dialog)))
                
                

(defvar *csp-demo-menu* nil)

(setq *csp-demo-menu*
      (make-menu-item :title "~Demos" :value
             (open-menu 
                   (list 
                      (make-menu-item :title "Demo 1"
                             :value 'csp-demo-1 :available-p t)
                      (make-menu-item :title "Demo 2"
                             :value 'csp-demo-2 :available-p nil)
                      (make-menu-item :title "Demo 3"
                             :value 'csp-demo-3 :available-p nil))
                   'pop-up-menu *lisp-main-window* :name '*csp-demo-menu* :title '"" 
                   :selection-function 'funcall-menu-item)))
      
      
      
(defun csp-demo-1 (&rest nulla)
      (declare (ignore nulla))
      (start-demo-1))



(defun csp-demo-2 (&rest nulla)
      (declare (ignore nulla))
      (start-demo-2))



(defun csp-demo-3 (&rest nulla)
      (declare (ignore nulla))
      (start-demo-3))


                                                   
(defun set-csp-menubar ()
     (clean-up-menubar)
;;;       (setq *lisp-menu-bar*
;;;             (open-stream 'menu-bar *lisp-main-window* :io))
      (add-to-menu *lisp-menu-bar*
            (make-menu-item
                   :title '~Tools
                   :value *pail-tool-menu*))
      (add-to-menu *lisp-menu-bar*
            *csp-file-menu*)
      (add-to-menu *lisp-menu-bar*
            (make-menu-item
                   :title '~Edit
                   :value *pail-edit-menu*))
      (add-to-menu *lisp-menu-bar*
            *csp-main-menu*)
      (add-to-menu *lisp-menu-bar*
            *csp-demo-menu*)
     (add-to-menu *lisp-menu-bar*
          *pail-window-menu*)  
      ;(set-window-menu *csp-main-window* *lisp-menu-bar*)
     )



(defun load-checking (file)
      (multiple-value-bind (a b)
              (ignore-errors (load file))))


