;;OKKIO
(in-package :csp)



(defun terminates-with (substr str)
      (string= substr str
           :start2 (- (length str) (length substr))))



(defun init-flags () 
      (setq *domain-loaded* nil)
      (setq *open-display-nets* nil)
      (setq *open-displays-list* nil)
      (setq *graphics* nil)
      (setq *paused* nil)
      (setq *aborted* nil)
      (setq *csp-interface* t)
      (setq *stop-at-arc* nil)
      (setq *stop-at-sol* nil)
      (setq *stop-at-prop* nil)
      (setq *verbose* nil)
      (setq *quiet1* t)
      (setq *queue* nil)
      (setq *all-distinct-values* nil)
      (setq *solutions* nil)
      (setq *main-network* nil)
      (setq *searching-network* nil))
  


(defun reset-custom-functions ()
      (eval (read-from-string
                      "(defun csp::DOMAIN-DEPENDENT-SHOW-SOLUTION (s) nil)"))
      (eval (read-from-string
                     "(defun csp::p-1 (var value) t)"))
      (eval (read-from-string
                     "(defun csp::p-2 (var value var1 value1) t)"))
      (eval (read-from-string
                     "(defun csp::variable-domain (domain) nil)"))
      (compile (eval (read-from-string
                                     "(defun csp::equal-value (v1 v2) (equal v1 v2))"))))



(defun net-too-big ()
      (> (length (nodes *main-network*)) 40))



(defun test-net-too-big ()
      (when (net-too-big)
             (pop-up-message-dialog
                   *csp-main-window*
                   nil
                   "The network is too big to be displayed.
Turning off graphics!"
                   nil "OK")
             (setf *graphics* nil)))



(defun problems-during-loading (file)
      (declare (ignore file)))



(defun process-interrupts () 
      nil)
  


(defun process-interrupts-for-stepper ()
      (when *single-step*
             (when (not *got-step-command*)
                    (loop until *got-step-command*
                        collect (process-pending-events))
                    (when (eql *got-step-command* :next-step)
                           (setq *got-step-command* nil)))))



(defun more-solutions ()
      (if *stop-at-sol*
         (yes-or-no-p "More solutions ? ")
         t))

