;;; -*- Mode: LISP; Package: csp; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   csp-demo2.cl
;;; Short Desc: Second demo on Constraint Propagation
;;;            
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   8.3.93 - FB
;;; Author:     Fabio Baj
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================
(in-package :csp)


;;=====================================================================
;; The definition of demo2
;;=====================================================================

(defun demo-2 ( )
  (setq *open-windows* nil)
  (setq *demo-in-execution* 1)
  (format-display-fill demo-text-disp  (format nil
					       "In this demo we will use Crossword Puzzles
as a tutorial example of the concepts of constraint satisfaction."))
  (when (wait)
    (format-display-fill demo-text-disp (format nil
						"First of all we load the Constraint Satisfaction Module."))
    (when (wait)
	(cspw)
	(push *csp-main-window* *open-windows*)
	(protect-display *csp-main-window* t)
	(format-display-fill demo-text-disp (format nil  "Now we load a file containing
the description of the problem to be solved."))
	  (when (wait)
	    (load-csp-demo  (namestring(add-path *csp-path* "demo2")))
	    (format-display-fill demo-text-disp (format nil  "Now you should see a puzzle on the
screen. To simplify the presentation assume that one is required to find in the given word list
the eleven words that correspond to 1across, 2down and so on.
We consider 1across, 2down as variables to be assigned values from a domain of 
possible words. The solution is a combination of
 words  taken from: 'start' 'eel' 'rabbi' 'cadre' 'ear' 'ran' 'exist'
'tea' 'albeit' 'nay' 'thy' 'aldrin' 
'thirty' 'tomato' 'treaty' 'twenty' 'twisty' 'secret' 
"))
	   (when (wait)
	       (format-display-fill demo-text-disp (format nil
 "You should try to solve this easy CSP now, introspecting on the 
methods you use as you
go through the process of looking for a solution."))  
	          (when (wait)
	       (format-display-fill demo-text-disp (format nil "In effect, the problem given to the Constraint Satisfaction
 Module is slightly more difficult because it has to choose among 257 words.
You can see in the CSP:Standard Output window a description of the constraint network
corresponding to the crossword schema to be filled. "))  
	       (when (wait)
	       (format-display-fill demo-text-disp (format nil 
"Each word to be filled corresponds to a node in the network. Each node
is described by its name, the names of the neighbors, and the number of values
contained in its domain.  "))  
	        (when (wait)
	       (format-display-fill demo-text-disp (format nil 
"Even with a set of 257 possible words the search space (that is the number of potential
solutions) is huge. This implies that approaches like generate-and-test, or
depth first search with backtracking can not be used. Instead, the Constraint Propagation
techniques are able to reduce very effectively the search space. See the example file
'crossw2.csp' which solves the present puzzle with a starting dictionary of 25000
words instead of 257."))  
	       (when (wait)
	     (my-software-push *graph-button* *csp-main-window*)
	      (format-display-fill demo-text-disp (format nil  
"You are now seeing a graphical representation of
the constraint network. You should try to associate the structure of the
network with the structure of the crossword puzzle, to understand how it is constructed.
The the nodes are buttons labeled with the sizes of the associated domains.
Pushing on them you will display the content of the domain on the 
CSP:Standard Output window. Let us inspect one node.."))
	      (when (wait)
		(my-software-push (domain-button (car (nodes *main-network*)))
				  (window *main-network*))
		(format-display-fill demo-text-disp (format nil  
"This is the state of the network before starting the  computation. The first phase 
consists in making the net node-consistent. That is for each node we require
that a unary predicate is satisfied. In this case the unary predicate specifies the word lenght.
For instance we delete from the domain of 1down all the words with length different from 6."))
		(when (wait)
		    (show-node-consistency *main-network*)
		    (format-display-fill demo-text-disp  (format nil  
"The network is now Node-Consistent. You can inspect the nodes, to print out the domain
contents, and verify that now thw unary predicate about word lengths is satisfied
at each node."))
		    (when (wait) 
		        (format-display-fill demo-text-disp  (format nil  
"The binary constraints arise when a word across intersects a word down.
Each link between two nodes in the networks corresponds to to a binary
constraint to be satisfied. For example the link between 1across and 2down
corresponds to a binary predicate requiring the second letter of 
1across be the same of the first letter of 2down and so on. "))
			(when (wait) 
			  (format-display-fill demo-text-disp  (format nil  
								       "The binary predicates are used to compute Arc-Consistency. 
For each arc <i,j> in the network
the algorithm removes from the domain of i all the words which are not supported
by any word in the domain of j with respect to the binary predicate.
This reduction of domains is propagated from node to node, until the network becames stable,
that is Arc-Consistent. Now we kake the network arc-consistent.
The pairs of nodes under consideration will be higlited. 
")) 
			  (when (wait)
			  (show-arc-consistency *main-network*)
			  (format-display-fill demo-text-disp  (format nil  
"As you can see, the search space has been further reduced by arc-consistency
computiation. Hoever the number of potential solutions is still bigger than
the number of the true solutions (which is 2). There are still some ambiguous
nodes. At this point we combine backtracking search with constraint propagation."))
			  (when (wait)
			    (show-search-solutions *main-network*)
			    (format-display-fill demo-text-disp  
						 (format nil  "Here are the two solutions"))
			    (when (wait) 
			      (close-display *current-schema-disp*)
			      (my-software-push *solutions-button* *csp-main-window*)
			      (setf (bottom *current-schema-disp*)(+(bottom *current-schema-disp*)
								    (height *current-schema-disp*)))
			      (format-display-fill demo-text-disp  (format nil  "That's All Folks!!"))
			      (when (wait)
				(my-software-push *exit-button* *csp-main-window*)
				(close-display *csp-main-window*))))))))))))))))))
 (defun show-node-consistency(n)
   (csp-init)
   (message " Computing Node Consistency...")
   (node-consistency n) 
   (display n )(possible-solutions-message)
   (message  "--------->> The Network is Node Consistent"))

(defun show-arc-consistency(n)
   (fill-queue-with-arcs n)
 (message  " Propagating Constraints...")
  (propagate-constraints n)
   (display n )(possible-solutions-message)
 (message "--------->>  The Network is Arc Consistent"))

(defun show-search-solutions(n)
 (catch 'no-more-solutions (search-solutions n 0) )
   (number-of-solutions-message))