 
(in-package :csp)


(defvar *current-cw*)

(defvar *square-size*)
(setq  *square-size* 25)


(defclass crossword-window (bitmap-window)
       ((crossword-schema
             :accessor crossword-schema
             :initform nil
             :initarg :crossword-schema)))



(defmacro **ss (x)
      `(* *square-size* ,x))



(defun g-show-schema (schema)
      (when *graphics*
             (setq *current-cw*
                   (open-stream 'crossword-window *csp-main-window* :output
                         :title "Puzzle"
                         :user-scrollable nil :user-resizable nil
                         :user-shrinkable nil
                         :window-border :dialog-box
                         :font (make-font :modern nil 8)
                         :visible-box (make-box 0 0
                                                       (* *square-size* (- (cadr (array-dimensions schema)) 2))
                                                       (* *square-size* (- (car (array-dimensions schema)) 2)))
                         :crossword-schema schema))
             (view-draw-contents *current-cw*)
             *current-cw*))



(defmethod view-draw-contents ((cw crossword-window))
      (let ((current-schema (crossword-schema cw))
              (counter 0))
          (do ((col 1 (+ col 1)))
                 ((= col (1- (cadr (array-dimensions current-schema))))) 
                (do ((row 1 (+ row 1)))
                       ((= row (1- (car (array-dimensions current-schema)))))
                      (incf counter)
                      (if (eq '* (aref current-schema row col))
                         (fill-polygon cw
                            (list
                                 (make-position (**ss (1- col)) (**ss (1- row)))
                                 (make-position (**ss col) (**ss (1- row)))
                                 (make-position (**ss col) (**ss row))
                                 (make-position (**ss (1- col)) (**ss row))))
                         (draw-polygon cw
                              (list
                                 (make-position (**ss (1- col)) (**ss (1- row)))
                                 (make-position (1- (**ss col)) (**ss (1- row)))
                                 (make-position (1- (**ss col)) (1- (**ss row)))
                                 (make-position (**ss (1- col)) (1- (**ss row))))))
                      (when (numberp (aref current-schema row col))
                             (write-string-at-pos cw
                                   (write-to-string (aref current-schema row col))
                                   (+ (round (* 0.05 *square-size* ))
                                       (**ss (1- col)))
                                   (+ (round (* 0.05 *square-size* ))
                                       (**ss (1- row)))))))))




(defmethod write-string-at-pos ((cw crossword-window) string x y)
      (draw-string-in-box
           cw
           string
           0
           (length string)
           (make-box x y (+ x 25) (+ y 10))
           :left
           :top
           nil))



(defun display-word (word schema net schema-disp)
      (let* ((positions (reverse (all-positions word)))
                (node (find-node (variable-name word ) net))
                (word-value (car (possible-values node)))
                (chars (coerce (string word-value) 'list)))
          (mapc #'(lambda (pos char)
                               (draw-string-in-box
                                    schema-disp
                                    (string-upcase (string char))
                                    0
                                    1
                                    (make-box
                                           (- (g-col (cdr pos)) *square-size*)
                                           (- (g-row (car pos) schema-disp) *square-size*)
                                           (g-col (cdr pos))
                                           (g-row (car pos) schema-disp))
                                    :center
                                    :center
                                    nil))
                 positions chars)))



(defun g-row (row schema-disp)
      (* *square-size*  row))



(defun g-col (col)
      (* *square-size* col))



(defun fill-schema (schema net schema-disp)
      (let ((font (font schema-disp)))
          (setf (font schema-disp)
                    (make-font :modern nil 16 '(:bold)))
          (mapc #'(lambda (w)
                               (display-word w schema net schema-disp))
                 (reverse *words*))
          (setf (font schema-disp) font)))
          



(defun find-word (variable-name)
      (find-if #'(lambda (word)
                           (eq (variable-name word) variable-name))
         *words*))