(in-package :csp)



(defvar tower)
(defvar hang)
(defvar elle)
(defvar strange)
(defvar *current-picture*)



;;;----------------------------------------
;; Domain specific functions
;;
;;

(defun nbs (vert)
      (cddr vert))



(defun label-for (vert value)
      (cdr (find-if #'(lambda (pair)
                                    (eq (car pair) vert)) value)))



(defun find-nbs (vert pict)
      (nbs (find-if #'(lambda (x)
                                     (eq (car x) vert)) pict)))



(defun reverse-label (label)
      "Account for the fact that one vertex's right is another's left."
      (case label
            (L 'R)
            (R 'L)
            (otherwise label)))



(defun compose-domain (pv nb)
      (mapcar 'cons pv nb))



(defun consistent-labeling (l1 l2)
      (eq l1 (reverse-label l2)))

(defun preprocess-picture (picture)
      (mapcar #'change-domain-name picture))



(defun change-domain-name (node-des)
      (cons
            (car node-des) 
            (cons
                  (cons (cadr node-des) (car node-des))
                   (cddr node-des))))



;;----------------------------------------------------------

(setq elle
      '((A W-vert B H I) 
        (B L-vert A C) 
        (C L-vert D B) 
        (D L-vert C E)
        (E W-vert F D I)
        (F L-vert E G) 
        (G W-vert H F I) 
        (H L-vert G A)
        (I Y-vert G E A)))



(setq strange
      '((A L-vert H B) 
        (B W-vert C A I) 
        (C L-vert B D)
        (D W-vert E C I)
        (I Y-vert H D B)
        (H W-vert A G I)
        (G L-vert L H)
        (L T-vert M G F)
        (M L-vert L N)
        (N T-vert E M F)
        (E L-vert D N) 
        (F L-vert N L)))



(setq hang
      '((A W-vert B F R)
        (B L-vert A C) 
        (D L-vert C E) 
        (C W-vert D B R)
        (E W-vert F D P)
        (F L-vert E A)
        (G W-vert R Q H) 
        (H L-vert G I)
        (I L-vert L H)
        (L L-vert I M)
        (M W-vert N L Q)
        (N L-vert M O)
        (O W-vert P N Q) 
        (P L-vert E O)
        (Q Y-vert O M G) 
        (R Y-vert G C A)))



;======================================================================
;; Interface with the Contraint Propation Algorithm

(defun variable-domain (domain-name)
      "The list of possible labelings for a given vertex type."
;;;       In these labelings, R means an arrow pointing away from 
;;;       the vertex, L means an arrow pointing towards it.
      (let* ((starting-vertex (cdr domain-name))
                (vertex-type (car domain-name))
                (nbs (find-nbs starting-vertex *current-picture*))
                (possible-values 
                      (case vertex-type
                            ((L-vert) '((R L)   (L R)   (+ R)   (L +)   (- L)   (R -)))
                            ((Y-vert) '((+ + +) (- - -) (L R -) (- L R) (R - L)))
                            ((T-vert) '((R L +) (R L -) (R L L) (R L R)))
                            ((W-vert) '((L R +) (- - +) (+ + -))))))
          (mapcar
                 #'(lambda (pv)
                         (compose-domain nbs pv))
                 possible-values)))



(defun p-1 (var value) t)



(defun p-2 (var-vertex1 value-label1 var-vertex2 value-label2)
      (consistent-labeling 
            (label-for var-vertex1 value-label2)
            (label-for var-vertex2 value-label1)))


(defun construct-network-from-picture (picture)
      (setq
            *current-picture*
            (preprocess-picture picture))
      (construct-network  *current-picture*))
