;;; -*- Mode: LISP; Package: pail-lib; Syntax: Common-lisp; -*-

(in-package :pail-lib)
(export '(create-demo-dialog
          demo-exit
          demo-continue
          demo-help
          format-demo
          demo-loop
          stop-demo))

(defvar *demo-window-title* nil)
(defvar *demo-title* nil)
(defvar *demo-dialog-item* nil)
(defvar *demo-subtitle* nil)
(defvar *demo-text* "")
(defvar *demo-continue* nil)
(defvar *demo-exit* nil)
(defvar *demo-display* nil)
(defvar *current-demo-helpfile* nil)


(defclass demo-window (dialog)
  ())

      
      
(defun create-demo-dialog (&key (window-title " ") (title "") (subtitle " ")
                                                           (helpfile nil) (window *screen*))
      (setq *demo-exit* nil)
      (setq *demo-continue* nil)
      (setq *demo-text* "")
      (setq *current-demo-helpfile* helpfile)
      (if (not (windowp *demo-dialog-item*))
             (progn
                  (setq *demo-dialog-item*
                        (open-dialog ()
                              'demo-window window :pop-up-p nil
                              :title window-title :user-closable nil
                              :window-border :dialog-box
                              :window-interior
                              (make-box
                                     (- (box-width (clipping-box *screen*)) 500) 50
                                     (- (box-width (clipping-box *screen*)) 50) 400)
                              :font (make-font nil :system 12 '(:bold))))
                  (update-dialog *demo-dialog-item*
                        (list
                           (make-dialog-item :widget 'button
                                  :title "Exit"
                                  :set-value-fn '(lambda (item new old) (demo-exit))
                                  :font (make-font :swiss nil 16 '(:bold))
                                  :name :demo-exit-button
                                  :box (make-box
                                                  0 0
                                                  (round (/ (box-width (window-interior *demo-dialog-item*)) 3))
                                                  30))
                           (make-dialog-item :widget 'button
                                  :title "Help"
                                  :set-value-fn '(lambda (item new old) (demo-help))
                                  :font (make-font :swiss nil 16 '(:bold))
                                  :name :demo-help-button :available-p nil
                                  :box (make-box
                                                  (round (/ (box-width (window-interior *demo-dialog-item*)) 3))
                                                  0
                                                  (round (* (/ (box-width (window-interior *demo-dialog-item*)) 3) 2))
                                                  30))
                           (make-dialog-item :widget 'default-button
                                  :title "Continue"
                                  :set-value-fn '(lambda (item new old) (demo-continue))
                                  :font (make-font :swiss nil 16 '(:bold))
                                  :name :demo-continue-button
                                  :box (make-box
                                                  (round (* (/ (box-width (window-interior *demo-dialog-item*)) 3) 2))
                                                  0
                                                  (box-width (window-interior *demo-dialog-item*))
                                                  30))
                           (make-dialog-item :widget 'static-text
                                  :value subtitle
                                  :font (make-font :swiss nil 16 '(:bold))
                                  :box (make-box 140 315 340 335))))
                  (setq *demo-display*
                        (open-stream 'text-edit-window *demo-dialog-item* :output
                              :window-exterior (make-box 10 40 440 300)
                              :window-border :dialog-box
                              :title *demo-text*
                              :font (make-font :modern nil 14)
                              :user-closable nil :user-movable nil
                              :user-resizable nil)))
         (progn
              (pop-up-message-dialog 
                    window nil
                    "Demo is running in another module
Close it first" nil "OK")
              nil)))




               

(defun demo-exit (&rest nulla)
     (declare (ignore nulla))
     (setq *demo-exit* t)
     (window-close *demo-display*)
     (window-close *demo-dialog-item*))


(defun demo-continue (&rest nulla)
     (declare (ignore nulla))
     (setq *demo-continue* t)
     (set-dialog-item-available-p
        (find-named-object :demo-continue-button *demo-dialog-item*) nil))


;(defun demo-help (&rest nulla)
;     (declare (ignore nulla))
;     (when *current-demo-helpfile* (open-gen-help-file)))


(defmethod add-text-to-dialog-item ((d text-edit-window) text)
     (format-display d text))

;(defmethod window-select ((dw demo-window))
;     (call-next-method)
;     (when *current-demo-helpfile* (set-help :general *current-demo-helpfile*)))


(defun format-demo (text)
     (format-display *demo-display* text)
     (format-display *demo-display* (format nil "~%"))
;     (invalidate-view *demo-display*)
     )

(defun demo-loop ()
     (set-dialog-item-available-p
       (find-named-object :demo-continue-button *demo-dialog-item*) t)
     (select-window *demo-dialog-item*)
     (loop while (and (not *demo-exit*) (not *demo-continue*))
          do (process-pending-events))                               
     (when *demo-exit* (throw 'stop-demo nil))
     (setq *demo-continue* nil))



