;;; -*- Mode: LISP; Package: csp; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   ga-demo1.lisp
;;; Short Desc: First demo on Genetic Algorithms
;;;            
;;; Version:    1.0
;;; Status:     
;;; Last Mod:   
;;; Author:     
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================
(in-package :ga)


;;=====================================================================
;; The definition of demo1
;;=====================================================================

(defun demo-1 (&aux w)
     (catch 'stop-demo
         (setq *verbose-mode* t)
         (create-demo-dialog :window-title "GA: First Demo"
             :title "GA"
             :subtitle "Parameter optimization")
         ;                          :helpfile "ga:help:csp-demo2.asc")
         (format-demo "This demo shows some basic aspects of the Genetic Algorithms Module.
The demo will proceed in steps. For starting a new step you must push the <Continue> button.")
         (demo-loop)
         (format-demo						
             " This version of a parameter optimizing GA  takes a
set of parameter as an  argument  (the range of the
parameter that will  be  optimized)  and a function
that accepts these  parameters as input and returns
a   fitness   measure, that   corresponds   to  the
usefulness of the parameter-set.")
         (demo-loop)
         (format-demo "First of all you have to introduce a fitness function. For this you may
select from a list of functions or you can load a new function from a file. Let us select
one function:")
         (demo-loop)
         (setq *current-function*
              (car (select-item-from-list  *known-functions*
                          :window-title "Fitness Functions"
                          :selection-type :single
                          :table-print-function #'sf-print-function)))
         (format-demo "Now you may choose the interval in which the values of the
function will take values (min-f,max-f), the interval for the parameters (lower-bound,upper-bound),
the number of parameters, the number of bits per parameter. Default parameters are provided.")
         (demo-loop)
         (fitness-function-dialog *current-function*)
         (setup-globals *current-function*)
         (setq *generations-to-evolve* 10)
         (dialog-item-enable (view-named 'start *ga-main-window*))
         (format-demo "Now we can start an evolution process. Usually, this is done by pushing the
Start button. On the screen will be oppened a window in which the graph of the fitness function
will be plotted, one in which the values of the fitness of the individuals are plotted and
a window with some parameters of the evolution.")
         (demo-loop)
         (setq *current-generation* nil)
         (open-monitor)
         (demo-loop)
         (start-evolving)
         (demo-loop)
         (format-demo "You may see the chromozomes of the current and previous generations. Usually,
this obtained by pushing the Analyze button.")
         (demo-loop)
         (setq w (car (open-analyze-display 0)))
         (demo-loop)
         (window-close w)
         (format-demo "That's all!")))
