(in-package :ga)


;;; ==========================================================================
;;; GLOBAL VARIABLE DECLARATIONS
;;; ==========================================================================


(defvar *open-ga-windows* nil)
(defvar *ga-main-window* nil)
(defvar *ga-output-window* nil)


(defvar *defined-f*	nil)
(defvar *new-f*		nil)
(defvar *parameter-done* nil)


(defvar *window-list*	nil)
(defvar *button-list*	nil)


(defvar *verbose-mode*  t)

(defvar *main-display*	nil)
(defvar *analyze-display*	nil)
(defvar *schemata-display*	nil)
(defvar *t-display*	nil)
(defvar *param-display*	nil)
(defvar *monitor-disp*	nil)
(defparameter *perf-disp*	nil)
(defparameter *i-disp*        nil)


(defvar *start-button-label* " Start ")
(defvar *start-button*	nil)
(defvar *stop-button*	nil)
(defvar *analyze-button* nil)
(defvar *gs-button*	nil)
(defvar *monitor-button*  nil)





;;; ==========================================================================
;;; G A     D I A L O G
;;; ==========================================================================

(defclass ga-dialog (dialog) ())

(defmethod initialize-instance :after ((gd ga-dialog) &rest whatever)
     (push gd *open-ga-windows*))

(defmethod window-close ((gd ga-dialog))
     (close gd))

(defclass ga-main-dialog (ga-dialog)
      ())

(defmethod bring-window-to-front :after ((gd ga-main-dialog))
        (in-package :ga)
        (set-ga-menubar)
     (setf (stream-title *lisp-main-window*) "PAIL - Genetic Algorithms module"))

(defclass ga-bitmap-pane (bitmap-pane) nil)



;;; (defmethod window-select :before ((id ga-dialog))
;;;   (unless (eq *current-module* :ga)
;;;     (window-show *button-bar*)
;;;     (in-package :ga)
;;;     (set-ga-menubar)
;;;     (set-help-ga)
;;;     (setf *current-module* :ga)))

;;; (defmethod view-click-event-handler :before ((id ga-dialog) where)
;;;      (declare (ignore where))
;;;      (unless (eq *current-module* :ga)
;;;           (window-show *button-bar*)
;;;           (in-package :ga)
;;;           (set-ga-menubar)
;;;           (set-help-ga)
;;;           (setf *current-module* :ga)))

(defmethod initialize-instance :after ((cd ga-dialog) &rest whatever)
  (declare (ignore whatever))
  (push cd *open-ga-windows*))

;;; (defmethod view-draw-contents ((self ga-dialog))
;;;   (call-next-method))

;;; (defmethod close ((cd ga-dialog))
;;;  (setq *open-ga-windows* (delete cd *open-ga-windows*))
;;;   (call-next-method))


(defclass ga-fred-window (text-edit-window)
      ())

(defmethod initialize-instance :after ((gfw ga-fred-window) &rest whatever)
     (push gfw *open-ga-windows*))

(defmethod window-close ((gfw ga-fred-window))
     (close gfw))


;;; ==========================================================================
;;; G A     M A I N   D I A L O G
;;; ==========================================================================


(defclass ga-option (ga-dialog option-dialog) ())

(defclass ga-info (ga-dialog info-dialog) ())

(defclass ga-demo (ga-dialog demo-window) ())




;;; ==========================================================================
;;; Constants of the GA
;;; ==========================================================================


(defparameter *population-size*       30)	; must be even!
(defparameter *crossover-probability* 0.6)
(defparameter *mutation-probability*  0.00433)
(defparameter *mutations-p*	      t)
(defparameter *inversion-probability* 0.0)      ; unused
(defparameter *generation-gap*        1.0)      ; unused
(defparameter *mutation-events*       0)
(defparameter *normalize-fitness-p*   t)
(defparameter *scale-fitness-p*	      t)	; for fitness-scaling
(defparameter *fitness-multiple*      2)
(defparameter *scale-a*               1.0)
(defparameter *scale-b*               0.0)
(defparameter *allele-type*	     '(nil t))	; the possible-values of the genotype
(defparameter *acc*		      0.0)	; this is a hack.
(defparameter *generations-to-evolve* 10)
(defparameter *current-generation*    nil)
(defparameter *proceed*		      t)	; if set to nil the evolving stops.
(defparameter *running*               nil)
(defparameter *current-function* nil)


;;; ==========================================================================
;;; Constants of the parameter encoding scheme
;;; ==========================================================================

(defvar *fitness-function* nil)
(defvar *parameter* nil)
(defvar *bits-per-parameter* 8)
(defvar *precision* 0)
(defvar *max-allele* 0)
(defvar *lower-bound* 0)
(defvar *upper-bound* 1)
(defvar *itervall-length* 0)
(defvar *gray-coding* nil)
(defun degray1 (l) l)			; use this definition if you don't want gray coding to be used.
;;;(defun degray1 (l) (degray l))	; use this otherwise.


;;; ==========================================================================
;;; GA Specific Classes
;;; ==========================================================================

(defclass ga-function ()
  ((nparameter		:type integer :initform 1
                        :initarg :nparameter
                        :accessor nparameter)
   (bits-per-parameter	:type integer :initform 8
                        :initarg :bits-per-parameter
                        :accessor bits-per-parameter)
   (fitness-function	:initarg :fitness-function
                        :accessor fitness-function)
   (max-f		:type float :initform 1.0 :initarg :max-f :accessor max-f)
   (min-f		:type float :initform 0.0 :initarg :min-f :accessor min-f)
   (lower-bound		:type float :initform 0.0
                        :initarg :lower-bound :accessor lower-bound)
   (upper-bound		:type float :initform 1.0
                        :initarg :upper-bound :accessor upper-bound)
   (max-allele		:type integer :accessor max-allele)
   (itervall-length	:type float :accessor itervall-length)
   (precision		:type integer :accessor precision)
   (gray-coded		:initform nil :initarg :gray-coded :accessor gray-coded))
  (:documentation "definition of a function to be optimized by the GA"))


;;; ==================================================================

(defclass generation ()
  ((mutation-events :type integer :initform 0
                    :initarg :mutations
                    :accessor mutations)
   (total-number :type integer :initform 0
                 :initarg :total-number
                 :accessor total-number)
   (online :type list :initform nil
           :initarg :online-performance
           :accessor online-performance) ; the convergence (best individuals)
   (offline :initform nil
            :initarg :offline-performance ; the evolving average since the start of the ga
            :accessor offline-performance) ; (list of fitness values)
   
   (populations :type list :initform nil
                :initarg :populations
                :accessor populations))
  (:documentation "An evolving set of populations"))


;;; ==================================================================

(defclass population ()
  ((minimum-fitness :type float :initform 0
                    :accessor minimum-fitness)
   (average-fitness :type float :initform 0
                    :accessor average-fitness)
   (maximum-fitness :type float :initform 0
                    :accessor maximum-fitness)
   (total-fitness :type float :initform 0
                  :accessor total-fitness)
   (size :type integer
         :initarg :size
         :accessor size)
   (population :type list
               :initarg :population
               :accessor population))
  (:documentation "a set of indiviuals at time t."))


;;; ==================================================================

(defclass individual ()
  ((fitness :type float
            :initform 0  
            :accessor fitness-value)
   (genotype :type list
             :initarg :genotype
             :accessor genotype))
  (:documentation "A generic parameter-optimization genotype."))
