(defmethod fitness-function-dialog ((g ga-function))
     (setq *ff-dialog*
          (open-dialog 
               (list 
                  (make-dialog-item :widget 'button :groupstart nil 
                        :tabstop nil :box #.(make-box 40 270 120 295) 
                        :font (make-font nil :arial 16 '(:bold)) :name 
                        :ga-help :title "Help")
                  (make-dialog-item :widget 'static-text :groupstart t 
                        :tabstop nil :background-color t :box 
                        #.(make-box 40 30 200 50) :value 
                        "Function" :font 
                        (make-font nil :arial 16 '(:bold)) :name 
                        :xxx)
                  (make-dialog-item :widget 'static-text :groupstart t 
                        :tabstop nil :background-color t :box 
                        #.(make-box 220 28 280 52) :value 
                       (fitness-function g)
                        :set-value-function 'change-ff-parameter
                         :font (make-font nil :arial 16 '(:bold)) :name 
                        :ff-fun) 
                  (make-dialog-item :widget 'static-text :groupstart t 
                        :tabstop nil :background-color t :box 
                        #.(make-box 40 60 200 80) :value 
                        "Maximum Value" :font 
                        (make-font nil :arial 16 '(:bold)) :name 
                        :xxx)
                  (make-dialog-item :widget 'lisp-text :groupstart t 
                        :tabstop t :set-value-function 'change-ff-parameter :box 
                        #.(make-box 220 58 280 82) :value  (max-f g)
                        :font (make-font nil :courier\ new 16 nil) :name 
                        :ff-max)
                  (make-dialog-item :widget 'static-text :groupstart t 
                        :tabstop nil :background-color t :box 
                        #.(make-box 40 90 200 120) :value 
                        "Minimum Value" :font 
                        (make-font nil :arial 16 '(:bold)) :name 
                        :xxx)
                  (make-dialog-item :widget 'lisp-text :groupstart t 
                        :tabstop t :set-value-fn 'change-ff-parameter :box 
                        #.(make-box 220 88 280 112) :value (min-f g)
                        :font (make-font nil :courier\ new 16 nil) :name 
                        :ff-min)
                  (make-dialog-item :widget 'static-text :groupstart t 
                        :tabstop nil :background-color t :box 
                        #.(make-box 40 120 200 140) :value 
                        "Number of Parameters" :font 
                        (make-font nil :arial 16 '(:bold)) :name 
                        :xxx)
                  (make-dialog-item :widget 'lisp-text :groupstart t 
                        :tabstop t :set-value-fn 'change-ff-parameter :box 
                        #.(make-box 220 118 280 142) :value (nparameter g)
                        :font (make-font nil :courier\ new 16 nil) :name 
                        :ff-num)
                  (make-dialog-item :widget 'static-text :groupstart t 
                        :tabstop nil :background-color t :box 
                        #.(make-box 40 150 200 170) :value 
                        "Lower Bound" :font 
                        (make-font nil :arial 16 '(:bold)) :name 
                        :xxx)
                  (make-dialog-item :widget 'lisp-text :groupstart t 
                        :tabstop t :set-value-fn 'change-ff-parameter :box 
                        #.(make-box 220 148 280 172) :value (lower-bound g)
                        :font (make-font nil :courier\ new 16 nil) :name 
                        :ff-low)
                  (make-dialog-item :widget 'static-text :groupstart t 
                        :tabstop nil :background-color t :box 
                        #.(make-box 40 180 200 200) :value 
                        "Upper Bound" :font 
                        (make-font nil :arial 16 '(:bold)) :name 
                        :xxx)
                  (make-dialog-item :widget 'lisp-text :groupstart t 
                        :tabstop t :set-value-fn 'change-ff-parameter :box 
                        #.(make-box 220 178 280 202) :value (upper-bound g)
                        :font (make-font nil :courier\ new 16 nil) :name 
                        :ff-up)
                  (make-dialog-item :widget 'static-text :groupstart t 
                        :tabstop nil :background-color t :box 
                        #.(make-box 40 210 200 230) :value 
                        "Bits per Parameter" :font 
                        (make-font nil :arial 16 '(:bold)) :name 
                        :xxx)
                  (make-dialog-item :widget 'lisp-text :groupstart t 
                        :tabstop t :set-value-fn 'change-ff-parameter :box 
                        #.(make-box 220 208 280 232) :value (bits-per-parameter g)
                        :font (make-font nil :courier\ new 16 nil) :name 
                        :ff-bit)
                  (make-dialog-item :widget 'check-box :groupstart t 
                        :tabstop nil :background-color t :box 
                        #.(make-box 40 240 200 260) :value (gray-coded g)
                       :title  "Use Gray-coding" :font 
                        (make-font nil :arial 16 '(:bold)) :name 
                        :ff-gray)
                  (make-dialog-item :widget 'default-button :groupstart nil 
                        :tabstop nil :set-value-fn 'save-ff-parameters 
                        :box #.(make-box 200 270 280 295) :font 
                        (make-font nil :arial 16 '(:bold)) :name :ga-ok 
                        :title "OK")
                  )
               'dialog *lisp-main-window* :name :ga-parameters
               :title "Fitness Function Parameters"
               :font (make-font :swiss :system 20 '(:bold))
               :user-movable t :user-resizable nil :user-closable nil
               :user-shrinkable nil :user-scrollable nil 
               :window-border :dialog-box
               :background-color (make-rgb :red 0 :green 128 :blue 128) 
               :pop-up-p nil :visible-box #.(make-box 0 0 315 300))))

(defun save-ff-parameters (widget new-value old-value)
     (let ((new-t (dialog-item-value (find-named-object :ff-max *ff-dialog*))))
         (when (numberp new-t)
              (setf (max-f *current-function*) new-t)))
     (let ((new-t (dialog-item-value (find-named-object :ff-min *ff-dialog*))))
         (when (numberp new-t)
              (setf (min-f *current-function*) new-t)))
     (let ((new-t (dialog-item-value (find-named-object :ff-num *ff-dialog*))))
         (when (numberp new-t)
              (setf (nparameter *current-function*) new-t)))   
     (let ((new-t (dialog-item-value (find-named-object :ff-low *ff-dialog*))))
         (when (numberp new-t)
              (setf (lower-bound *current-function*) new-t)))  
     (let ((new-t (dialog-item-value (find-named-object :ff-up *ff-dialog*))))
         (when (numberp new-t)
              (setf (upper-bound *current-function*) new-t))) 
     (let ((new-t (dialog-item-value (find-named-object :ff-bit *ff-dialog*))))
         (when (numberp new-t)
              (setf (bits-per-parameter *current-function*) new-t)))
     (setf (gray-coded *current-function*) 
             (dialog-item-value (find-named-object :ff-gray *ff-dialog*)))
     (close *ff-dialog*))

(defun change-ff-parameter  (widget new-value old-value)
       (set-dialog-item-value widget (eval new-value)))