(in-package :ga)

;;; ==========================================================================
;;; DISPLAYS THE FITNESS OF THE INDIVIDUALS OF A POPULATION
;;; ==========================================================================


(defclass indiv-display (ga-dialog) 
	  ((vxunit	:accessor vxunit :initarg :vxunit)
	   (vyunit	:accessor vyunit :initarg :vyunit)
	   (population	:accessor population :initarg :population))
  (:documentation "This is a display for individuals' fitness"))

(defmethod window-close :before ((d indiv-display))
  (when (eql d *i-disp*) (setf *i-disp* nil)))


(defun open-population-display ()
     (let* ((*i-disp*
                  (open-dialog
                       (list
                          (make-dialog-item :widget 'button
                                :name ':close
                                :title "Close"
                                :font (make-font :modern nil 16 '(:bold))
                                :box (make-box 0 0 200 25)
                                :set-value-fn '(lambda (&rest x) (show-error) t))
                          (make-dialog-item :widget 'button
                                :title "Help"
                                :name ':help
                                :available-p nil
                                :font (make-font :modern nil 16 '(:bold))
                                :box (make-box 200 0 400 25)))
                       'indiv-display *ga-main-window*
                       :pop-up-p nil
                       :title (concatenate 'string
                                       "GA individual fitness for "
                                       (write-to-string
                                        (fitness-function *current-function*)))
                       :user-resizable nil :user-closable nil
                       :user-scrollable nil
                       :window-border :dialog-box
                       :visible-box (make-box 0 0 400 300))))
         (open-stream 'bitmap-window *i-disp* :output
              :window-exterior
              (make-box 0 25
                    (box-width (window-interior *i-disp*))
                    (box-height (window-interior *i-disp*)))
              :user-closable nil :user-scrollable nil
              :user-resizable nil :user-movable nil)
         (setf (vxunit *i-disp*) (/ (box-width (window-interior *i-disp*))
                                                        *generations-to-evolve*))
         (setf (vyunit *i-disp*)
                 (/ (box-height (window-interior *i-disp*))
                    (- (max-f *current-function*)
                       (min-f *current-function*))))
         (setf (population *i-disp*) nil)
         ))




(defmethod view-draw-contents ((g indiv-display)
                               &aux (vx (round (vxunit g)))
                                    (vy (vyunit g))
                                    (mh (point-v (view-size g)))
                                    (x 0))
 (dolist (i (population g))
    (move-to g x mh)
    (line-to
     g
     x
     (- mh
        (round (* (+ (min-f *current-function*)
                     i)
                  vy))))
    (setq x (+ x vx))))
;;; ==========================================================================
;;; DISPLAYS THE FITNESS OF THE INDIVIDUALS OF A POPULATION
;;; ==========================================================================

(defclass indiv-display (ga-dialog) ;display)
      ((vxunit	:accessor vxunit :initarg :vxunit)
       (vyunit	:accessor vyunit :initarg :vyunit)
       (population	:accessor population :initarg :population)
       )
     (:documentation "This is a display for individuals' fitness"))


(defmethod window-close :before ((d indiv-display))
  (when (eql d *i-disp*) (setf *i-disp* nil)))

(defmethod view-draw-contents ((g indiv-display)
                               &aux (vx (round (vxunit g)))
                                    (vy (vyunit g))
                                    (mh (point-v (view-size g)))
                                    (x 0))
 (dolist (i (population g))
    (move-to g x mh)
    (line-to
     g
     x
     (- mh
        (round (* (+ (min-f *current-function*)
                     i)
                  vy))))
    (setq x (+ x vx))))