(in-package :ga)

;;; ==========================================================================
;;;  GRAPH (MAXIMUM & AVERAGE FITNESS) DISPLAY
;;; ==========================================================================

(defclass graph-display (ga-dialog) ;display)
	  ((vxunit	:accessor vxunit :initarg :vxunit)
	   (vyunit	:accessor vyunit :initarg :vyunit)
	   (plist	:accessor plist :initarg :plist)
           (plista	:accessor plista :initarg :plista))
  (:documentation "This is a display for line Graphs"))



(defmethod window-close :before ((d graph-display))
  (when (eql d *perf-disp*) (setf *perf-disp* nil)))

(defmethod view-draw-contents ((g graph-display)
                               &aux (vx (round (vxunit g)))
                                    (vy (vyunit g))
                                    (mh (point-v (view-size g))))
  (move-to g 0 0)
  (print (max-f *current-function*) g)
  (move-to g 0 (- mh 10))
  (print (min-f *current-function*) g)
      (dotimes (i *generations-to-evolve*)
        (let ((x                         ;(+ iw 
               (round (* i vx))))          ;(vxunit g)))));)
          (move-to g x 0)
          (line-to g x (if (eql (mod i 10 ) 0) 5 2))))
      (do* ((pl (plist g) (cdr pl))
            (point (cadr pl) (cadr pl))
            (pla (plista g) (cdr pla))
            (pointa (cadr pla) (cadr pla))
            (x- 0 (+ x- vx))
            (x vx (+ x vx)))
           ((or (null pl)(null (cdr pl))))
        (move-to g
                 x-
                 (- mh
                    (round (* (+ (min-f *current-function*)
                                 (car pl))       ;(last (plist g))))
                              vy))))      ;unit g))))
        (set-fore-color g *red-color*)
        (line-to g x (- mh (round (* (+ (min-f *current-function*) point) vy))))     ;(vyunit g))))
        (set-fore-color g *blue-color*)
        (move-to g
                 x-
                 (- mh
                    (round (* (+ (min-f *current-function*)
                                 (car pla))       ;(last (plist g))))
                              vy))))      ;unit g))))
        ;(set-fore-color g *blue-color*)
        (line-to g x (- mh (round (* (+ (min-f *current-function*) pointa) vy))))     ;(vyunit g))))
        (set-fore-color g *black-color*)))

(defvar *gen-l* nil)
(defvar *mut-l* nil)
(defvar *avf-l* nil)
(defvar *gen-b* nil)
(defvar *mut-b* nil)
(defvar *avf-b* nil)






;;; ==========================================================================
;;; ANALYZE (CROMOZONES) DISPL 
;;; ==========================================================================


(defclass analyze-displ (sequence-window ga-dialog)
  ((crt-pop :accessor crt-pop :initarg :crt-pop)
   (ngen :accessor ngen :initarg :ngen)))

(defun open-analyze-display (n)
  (let* ((ngen (length (populations *current-generation*)))
         (bwidth (* 5 *max-allele*))
         (bheight (* *population-size*
                     (multiple-value-bind (ascent descent maxwidth leading)
                                          (font-info)
                       (declare (ignore maxwidth leading))
                       (+ ascent descent))))
         (pop (population (nth-pop (- ngen n 1)))))
    (push (make-instance 'analyze-displ
                :button-list '(("Previous" 'last-generation)
                               ("Close" 'close-anb)
                               ("Close all" 'close-allanb)
                               )
                ;:field-size (make-point 1000 1000)
                :ngen ngen
                :crt-pop n
                ;  :view-font *message-font*
                :view-position (list :left (min 500 (+ 10 (* 10 n))))
                :sequence (mapcar #'(lambda(john)
                                      (mapcar #'(lambda(x)
                                                  (if x '_ 0))
                                              (genotype john))) pop)

                :view-size (make-point
                            (min *screen-width* (max 150 (+ 60 bwidth)))
                            (min 300 (+ 40 bheight)))
                :window-title (format nil "GA: gen ~A " (- ngen n)))
          *analyze-display*)))


(defun ch-height ()
  (multiple-value-bind (ascent descent maxwidth leading)
                       (font-info)
    (declare (ignore maxwidth leading))
    (+ ascent descent)))

(defun nth-pop (n)
  (nth n (populations *current-generation*)))

(defmethod close-anb ((window analyze-displ))
  (window-close window))
                      
(defmethod close-allanb ((window analyze-displ))
  (close-all-anal-displ))

(defun close-all-anal-displ ()
  (when (and *analyze-display* (y-or-n-dialog "Closing all chromozomes windows ?"))
    (dolist (w *analyze-display*)
      (window-close w))
    (setf *analyze-display* nil)))


(defmethod last-generation ((window analyze-displ)
                            &aux
                            (crt-pop (crt-pop window)))
  (if (< crt-pop (1- (ngen window)))
    (open-analyze-display (1+ crt-pop))   ;(setf (crt-pop window) (1+ crt-pop))
    (message-dialog "Sorry, this is the first generation!")))


;;; ==========================================================================
;;; OPEN AND DISPLAY GRAPHS
;;; ==========================================================================

(defun open-monitor (&aux (c (find-class 'graph-display)))
;;;                           (width (+ 20 (round (* 0.5 *screen-width* *main-width*))))
;;;                           (height 100))
  (ga-parameter-dialog)
;;;   (when (and *perf-disp* (y-or-n-dialog "Closing previous fitness graph windows ?"))
;;;     (dolist (window *open-ga-windows*)
;;;       (when (eql (class-of window) c)
;;;         (window-close window))))
     (open-fitness-display)
  (if *i-disp*
    (window-close *i-disp*))
     (open-population-display))
         


(defun display-message(string)
  (format-display *ga-output-window* (concatenate 'string string "~%")))


