(in-package :ga)

;;; ==========================================================================
;;; GA MAIN DIALOG
;;; ==========================================================================
 
(defun ga ()
  (setq pail-lib::*ga-module-loaded* t)
  (in-package :ga)
  (dialog-item-disable (view-named 'ga *button-bar*))
  (set-ga-menubar)
  (set-help-ga)
  (create-ga-window))
 
(defun set-help-ga ()
  (set-pail-help :general "ga:help:ga-main-help.gen"
                 :technical "ga:help:ga-main-help.tec"))


(defun quit-ga ()
  (dolist (window *open-ga-windows*)
    (window-close window))
  (setq *ga-main-window* nil)
  (dialog-item-enable (view-named 'ga *button-bar*))
  (setq pail-lib::*ga-module-loaded* nil)
  (pail))


(defun create-ga-window ()
  (unless *ga-main-window*
    (let* ((wtitle "Genetic algorithms")
           (window-width (round (* *screen-width* *main-width*)))
           (width (- window-width (* 2 *main-indent*)))
           (height (round (* *screen-height* *main-dialog-height*)))
           (spacing (truncate (- width (* 4 *button-width*)) 3))
           (button-y (+ (* 3 *main-indent*) *heading-height* height))
           (button-y2 (+ (* 4 *main-indent*) *heading-height* *button-height* height))
           (title-width (+ 6 (string-width wtitle *heading-font*))))
      (setq *ga-main-window*
            (make-instance 'ga-main-dialog
              :window-type :document
              ;              :view-position '(:left 225)
              :window-title ""
              :view-size (make-point
                          window-width
                          (+ (* 5 *main-indent*)
                             *heading-height*
                             (* 2 *button-height*)
                             height))
              :view-font *heading-font*
              :window-do-first-click t
              :close-box-p nil
              :view-subviews
              (list (make-dialog-item 'ro-scrolling-fred-dialog-item
                                      (make-point *main-indent*
                                                  (+ (* 2 *main-indent*)
                                                     *heading-height*))
                                      (make-point (- width 15) (- height 15))
                                      nil
                                      nil
                                      :view-font *message-font*
                                      :allow-returns nil)
                    (make-dialog-item 'static-text-dialog-item
                                      (make-point (round (- window-width
                                                            title-width)
                                                         2)
                                                  *main-indent*)
                                      (make-point title-width *heading-height*)
                                      wtitle
                                      nil
                                      :view-font *heading-font*
                                      )
                    (make-dialog-item 'button-dialog-item
                                      (make-point *main-indent* button-y)  
                                      (make-point *button-width* *button-height*)
                                      
                                      "Help"
                                      
                                      #'(lambda (item) item
                                         (make-instance 'help-window
                                           :filename (concatenate
                                                      'string
                                                      *pail-directory*
                                                      "ga:help:ga-main-help.tec")
                                           :view-size #@(350 250)
                                           :direction :output
                                           :grow-icon-p t
                                           :window-title "GA: MAIN HELP"))
                                      :view-font *button-font*)
                    (make-dialog-item 'button-dialog-item
                                      (make-point  (+ *main-indent* *button-width*
                                                      spacing)
                                                   button-y)
                                      (make-point *button-width* *button-height*)
                                      
                                      "Start"
                                      
                                      #'(lambda (item)
                                          item
                                          (setq *current-generation* nil)
                                          (open-monitor)
                                          (eval-enqueue '(start-evolving)))
                                      :view-font *button-font*
                                      :view-nick-name 'start
                                      :dialog-item-enabled-p nil
                                      :default-button t)
                    (make-dialog-item 'button-dialog-item
                                      (make-point (+ *main-indent*
                                                     (* 2 (+ *button-width*
                                                             spacing)))
                                                  button-y)
                                      (make-point *button-width* *button-height*)
                                      
                                      "Interrupt"
                                      
                                      #'(lambda (item)
                                          item
                                          (setq *proceed* nil))
                                      :view-font *button-font*
                                      :view-nick-name 'stop
                                      :default-button nil
                                      :dialog-item-enabled-p nil
                                      )
                    (make-dialog-item 'button-dialog-item
                                      (make-point (+ *main-indent*
                                                     (* 3 (+ *button-width*
                                                             spacing)))
                                                  button-y)
                                      (make-point *button-width* *button-height*)
                                      
                                      "Continue"
                                      
                                      #'(lambda (item)
                                          item
                                          (open-monitor)
                                          (eval-enqueue '(start-evolving)))
                                      :view-font *button-font*
                                      :view-nick-name 'continue
                                      :default-button nil
                                      :dialog-item-enabled-p nil
                                      )
                    (make-dialog-item 'button-dialog-item
                                      (make-point *main-indent* button-y2)
                                      (make-point *button-width* *button-height*)
                                      
                                      "Parameters"
                                      
                                      #'(lambda (item) item (ga-parameter-dialog))
                                      :view-font *button-font*
                                      :view-nick-name 'parameters
                                      :default-button nil
                                      )
                    (make-dialog-item 'button-dialog-item
                                      (make-point (+ *main-indent*
                                                     (+ *button-width*
                                                        spacing))
                                                  button-y2)
                                      (make-point *button-width* *button-height*)
                                      
                                      "Options"
                                      
                                      #'(lambda (item) item (fitness-parameter-dialog))
                                      :view-font *button-font*
                                      :view-nick-name 'abort
                                      :default-button nil)
                    (make-dialog-item 'button-dialog-item
                                      (make-point (+ *main-indent*
                                                     (* 2 (+ *button-width*
                                                             spacing)))
                                                  button-y2)
                                      (make-point *button-width* *button-height*)
                                      
                                      "Function"
                                      
                                      #'(lambda (item) item (select-fitness-function))
                                      :view-font *button-font*
                                      :view-nick-name 'fitness-fnct
                                      :default-button nil)
                    (make-dialog-item 'button-dialog-item
                                      (make-point (+ *main-indent*
                                                     (* 3 (+ *button-width*
                                                             spacing)))
                                                  button-y2)
                                      (make-point *button-width* *button-height*)
                                      
                                      "Analyze"
                                      
                                      #'(lambda (item) item (open-analyze-display 0))
                                      :view-font *button-font*
                                      :view-nick-name 'analyze
                                      :default-button nil
                                      :dialog-item-enabled-p nil))))
      (setq *ga-output-window* (aref (view-subviews *ga-main-window*) 0)))))


(defparameter *ga-file-menu*
      (make-instance 'menu
                     :menu-title "File"
                     :menu-items
                     (list
                           (make-instance 'menu-item
                                          :menu-item-title "New"
                                          :menu-item-action
                                          #'(lambda nil (make-instance 'fred-window))
                                          :command-key #\N)
                           (make-instance 'menu-item
                                          :menu-item-title "Open"
                                          :menu-item-action 'edit-select-file
                                          :command-key #\O)
                           (make-instance 'menu-item
                                          :menu-item-title "-"
                                          :disabled t)
                           (make-instance 'menu-item
                                          :menu-item-title "Load Function..."
                                          :menu-item-action #'(lambda()
                                                                (eval-enqueue
                                                                 '(load-fitness-function))))
                           (make-instance 'menu-item
                                          :menu-item-title "-"
                                          :disabled t)
                           (make-instance 'window-menu-item
                                          :menu-item-title "Close"
                                          :command-key #\W
                                          :menu-item-action 'window-close)
                           (make-instance 'window-menu-item
                                          :menu-item-title "Save"
                                          :disabled t
                                          :command-key #\S
                                          :menu-item-action 'window-save)
                           (make-instance 'window-menu-item
                                          :menu-item-title "Save As"
                                          :menu-item-action 'window-save-as)
                           (make-instance 'window-menu-item
                                          :menu-item-title "Save Copy As"
                                          :menu-item-action
                                          'ccl::window-save-copy-as)
                           (make-instance 'menu-item
                                          :menu-item-title "-"
                                          :disabled t)
                           (make-instance 'menu-item
                                          :menu-item-title "Page Setup"
                                          :menu-item-action 'ccl::print-style-dialog)
                           (make-instance 'window-menu-item
                                          :menu-item-title "Print"
                                          :command-key #\P
                                          :menu-item-action 'window-hardcopy)
                           (make-instance 'menu-item
                                          :menu-item-title "-"
                                          :disabled t)
                           (make-instance 'menu-item
                                          :menu-item-title "Return to Pail"
                                          :menu-item-action 'pail)
                           (make-instance 'menu-item
                                          :menu-item-title "Exit from GA"
                                          :menu-item-action 'quit-ga))))

;(defvar *verbose-mode* t)

(defparameter *ga-parameter-menu*
      (make-instance 'menu
                     :menu-title "Function"
                     :menu-items
                     (list (make-instance 'menu-item
                                          :menu-item-title "Select Function..."
                                          :menu-item-action 'select-fitness-function)
                           (make-instance 'menu-item
                                          :menu-item-title "Load Function..."
                                          :menu-item-action #'(lambda()
                                                                (eval-enqueue
                                                                 '(load-fitness-function))))
                           (make-instance 'menu-item
                                          :menu-item-title "Set Fitness Options..."
                                          :menu-item-action 'fitness-parameter-dialog))))

(defparameter *ga-main-menu*
      (make-instance 'menu
                     :menu-title "Evolve"
                     :menu-items
                     (list (make-instance 'menu-item
                                          :menu-item-title "Start evolution..."
                                          :menu-item-action #'(lambda()
                                                               (setq *current-generation* nil)
                                                               (open-monitor)
                                                               (eval-enqueue
                                                                '(start-evolving)))
                                          :update-function #'(lambda (item)
                                                               (if (or *running*
                                                                       (not *current-function*))
                                                                 (menu-item-disable item)
                                                                 (menu-item-enable item))))
                           (make-instance 'menu-item
                                          :menu-item-title "Interrupt evolution"
                                          :menu-item-action #'(lambda()(setq *proceed* nil))
                                          :update-function #'(lambda (item)
                                                               (if *running*
                                                                 (menu-item-enable item)
                                                                 (menu-item-disable item))))
                           (make-instance 'menu-item
                                          :menu-item-title "Continue evolution..."
                                          :menu-item-action #'(lambda()
                                                                (open-monitor)
                                                                (eval-enqueue
                                                                 '(start-evolving)))
                                          :update-function #'(lambda (item)
                                                               (if (and *current-generation*
                                                                        (not *running*))
                                                                 (menu-item-enable item)
                                                                 (menu-item-disable item))))
                           (make-instance 'menu-item
                                          :menu-item-title "Analyze chromosomes..."
                                          :menu-item-action #'(lambda()
                                                               (eval-enqueue
                                                                '(open-analyze-display 0)))
                                          :update-function #'(lambda (item)
                                                               (if (and *current-generation*
                                                                        (not *running*))
                                                                 (menu-item-enable item)
                                                                 (menu-item-disable item))))
                           (make-instance 'menu-item
                                          :menu-item-title "-"
                                          :disabled t)
                           (make-instance 'menu-item
                                          :menu-item-title "Genetic Parameters..."
                                          :menu-item-action 'ga-parameter-dialog)
                           (make-instance 'menu-item
                                          :menu-item-title "Environment Info"
                                          :menu-item-action 'display-environment))))

;;; ==========================================================================
;;; GA PARAMETER DIALOG
;;; ==========================================================================

(defvar *ga-dialog* nil)

(defclass ga-parameter (ga-dialog) ())

(defmethod window-close :before ((d ga-parameter)) (setf *ga-dialog* nil))

(defun ga-parameter-dialog ()
  (if *ga-dialog*
    (window-select *ga-dialog*)
    (setq *ga-dialog*
          (make-instance   'ga-parameter
            :window-title "Genetic Parameters"
            :view-position '(:right 10)      ;(make-point 350 60)
            :view-size     #@(270 120)
            :close-box-p   nil
            :view-font  *heading-font*       ;'("helvetica" 12 :srcor :bold)
            :view-subviews
    (list (make-dialog-item 'static-text-dialog-item
                            #@(20 15)
                            #@(150 15)
                            "Crossover Probability:"
                            'nil
                            :view-font *option-font*);'("helvetica" 12 :srcor :bold))
          (make-dialog-item 'static-text-dialog-item
                            #@(20 40)
                            #@(150 15)
                            "Mutation Probability:"
                            'nil
                            :view-font *option-font*);'("helvetica" 12 :srcor :bold))
          (make-dialog-item 'static-text-dialog-item
                            #@(20 65)
                            #@(150 15)
                            "Population Size:"
                            'nil
                            :view-font *option-font*);'("helvetica" 12 :srcor :bold))
          (make-dialog-item 'static-text-dialog-item
                            #@(20 90)
                            #@(150 15)
                            "Nr. of Generations:"
                            'nil
                            :view-font *option-font*);'("helvetica" 12 :srcor :bold))
          (make-dialog-item 'editable-text-dialog-item
                            #@(180 15)
                            #@(80 15)
                            (write-to-string *crossover-probability*)
                            #'(lambda (item) (when (> (length (dialog-item-text item)) 0)
                                               (setf *crossover-probability*
                                                     (read-from-string (dialog-item-text item)))))
                            :allow-returns nil)
          (make-dialog-item 'editable-text-dialog-item
                            #@(180 40)
                            #@(80 15)
                            (write-to-string *mutation-probability*)
                            #'(lambda (item) (when (> (length (dialog-item-text item)) 0)
                                               (setf *mutation-probability*
                                                     (read-from-string (dialog-item-text item)))))
                            :allow-returns nil)
          (make-dialog-item 'editable-text-dialog-item
                            #@(180 65)
                            #@(80 15)
                            (write-to-string *population-size*)
                            #'(lambda (item) (when (> (length (dialog-item-text item)) 0)
                                               (setf *population-size*
                                                     (read-from-string (dialog-item-text item)))))
                          :allow-returns nil)
          (make-dialog-item 'editable-text-dialog-item
                            #@(180 90)
                            #@(80 15)
                            (write-to-string *generations-to-evolve*)
                            #'(lambda (item) (when (> (length (dialog-item-text item)) 0)
                                               (setf *generations-to-evolve*
                                                     (read-from-string (dialog-item-text item)))))
                          :allow-returns nil))))))

(defun setup-globals (from-this-object)
  (setq *current-generation* nil)
  (setf *fitness-function* (fitness-function from-this-object))
  (setf *parameter* (nparameter from-this-object))
  (setf *bits-per-parameter* (bits-per-parameter from-this-object))
  (setf *lower-bound* (lower-bound from-this-object))
  (setf *upper-bound* (upper-bound from-this-object))
  (setf *precision* (expt 2 (bits-per-parameter from-this-object)))
  (setf *max-allele* (* *bits-per-parameter* *parameter*))
  (setf *itervall-length* (- *upper-bound* *lower-bound*))
  (setf *gray-coding* (gray-coded from-this-object)))


(defun fitness-parameter-dialog ()
  (set-pail-help 
   :general "ga:help:ga-options-help.gen"
   :gen-title "GA: Options Help")
  (modal-dialog
   (make-instance   'ga-option
    :window-title "GA Options"
    :view-subviews
    (list (make-instance 'check-box-dialog-item
            :dialog-item-text "Verbose Output"
            :dialog-item-action #'(lambda (item)
                                    (declare (ignore item))
                                    (setq *verbose-mode* (not *verbose-mode*)))
            :check-box-checked-p *verbose-mode*)
          (make-instance 'check-box-dialog-item
            :dialog-item-text           "   Normalize Fitness"
            :dialog-item-action         #'(lambda (item)
                                            (setf *normalize-fitness-p*
                                                  (check-box-checked-p item)))
            :check-box-checked-p *normalize-fitness-p*)
          (make-instance 'check-box-dialog-item
            :dialog-item-text "   Scale Fitness"
            :dialog-item-action #'(lambda (item)
                                    (setf *scale-fitness-p*
                                          (check-box-checked-p item)))
            :check-box-checked-p *scale-fitness-p*)
          (make-instance 'check-box-dialog-item
            :dialog-item-text "   Allow Mutations"
            :dialog-item-action #'(lambda (item)
                                    (setf *mutations-p*
                                          (check-box-checked-p item)))
            :check-box-checked-p *mutations-p*)))))


 
;;; ==========================================================================
;;; FITNESS FUNCTION DIALOG
;;; ==========================================================================


(defun select-fitness-function ()
  (fitness-function-dialog
   (setq *current-function*
         (car (select-item-from-list  *known-functions*
                                      :window-title "Fitness Functions"
                                      :selection-type :single
                                      :table-print-function #'sf-print-function))))
  (setup-globals *current-function*)
  (dialog-item-enable (view-named 'start *ga-main-window*)))

(defun load-fitness-function ()
  (let ((file
         (choose-file-dialog :directory (concatenate 'string *pail-directory*
                                                     "ga:functions:")
                             :button-string "Load")))
    (when file (load file))))


(defun new-fitness-function (f &optional (aux (make-instance 'ga-function :fitness-function f)))
  (push aux *known-functions*)
  (fitness-function-dialog
   (setq *current-function* aux))
  (setup-globals *current-function*)
  (dialog-item-enable (view-named 'start *ga-main-window*)))


(defun sf-print-function (a b)
  (princ (fitness-function a) b))

(defvar *ff-dialog* nil)

(defclass ga-fnct (ga-info)())

(defmethod initialize-instance ((g ga-fnct) &rest rest)
  (declare (ignore rest))
  (call-next-method)
  (set-dialog-item-text (elt (view-subviews g) 0) "Fitness Function Parameters"))


(defmethod fitness-function-dialog ((g ga-function))
    (set-pail-help :gen-title "GA: Options Help")
  (setq *ff-dialog*
  (modal-dialog
   (make-instance   'ga-fnct
    :view-subviews
    (list (make-instance
           'static-text-dialog-item
           :dialog-item-text "Function:")
          (make-instance
           'static-text-dialog-item
           :dialog-item-text (write-to-string (fitness-function g))
           :dialog-item-action #'(lambda (item) (when (> (length (dialog-item-text item)) 0)
                                                  (setf (fitness-function g)
                                                        (read-from-string (dialog-item-text item))))))
          (make-instance
           'static-text-dialog-item
           :dialog-item-text "Maximum Value:")
          (make-instance
           'editable-text-dialog-item
           :dialog-item-text (write-to-string (max-f g))
           :dialog-item-action #'(lambda (item) (let* ((new-t (dialog-item-text item))
                                                       (newr-t (when (> (length new-t) 0)
                                                                 (read-from-string new-t))))
                                                  (when (numberp newr-t)
                                                    (setf (max-f g) newr-t)))))
          (make-instance
           'static-text-dialog-item
           :dialog-item-text "Minimum Value:")
          (make-instance
           'editable-text-dialog-item
           :dialog-item-text (write-to-string (min-f g))
           :dialog-item-action #'(lambda (item) (let* ((new-t (dialog-item-text item))
                                                       (newr-t (when (> (length new-t) 0)
                                                                 (read-from-string new-t))))
                                                  (when (numberp newr-t)
                                                    (setf (min-f g) newr-t)))))
          (make-instance
           'static-text-dialog-item
           :dialog-item-text "Number of Parameters:")
          (make-instance
           'editable-text-dialog-item
           :dialog-item-text (write-to-string (nparameter g))
           :dialog-item-action #'(lambda (item) (let* ((new-t (dialog-item-text item))
                                                       (newr-t (when (> (length new-t) 0)
                                                                 (read-from-string new-t))))
                                                  (when (numberp newr-t)
                                                    (setf (nparameter g) newr-t)))))
          (make-instance
           'static-text-dialog-item
           :dialog-item-text "Lower Bound:")
          (make-instance
         'editable-text-dialog-item
         :dialog-item-text (write-to-string (lower-bound g))
         :dialog-item-action #'(lambda (item) (let* ((new-t (dialog-item-text item))
                                                     (newr-t (when (> (length new-t) 0)
                                                               (read-from-string new-t))))
                                                (when (numberp newr-t)
                                                  (setf (lower-bound g) newr-t)))))
          (make-instance
           'static-text-dialog-item
           :dialog-item-text "Upper Bound:")
          (make-instance
           'editable-text-dialog-item
           :dialog-item-text (write-to-string (upper-bound g))
           :dialog-item-action #'(lambda (item) (let* ((new-t (dialog-item-text item))
                                                       (newr-t (when (> (length new-t) 0)
                                                                 (read-from-string new-t))))
                                                  (when (numberp newr-t)
                                                    (setf (upper-bound g) newr-t)))))
          (make-instance
           'static-text-dialog-item
           :dialog-item-text "Bits per Parameter:")
          (make-instance
           'editable-text-dialog-item
           :dialog-item-text (write-to-string (bits-per-parameter g))
           :dialog-item-action #'(lambda (item) (let* ((new-t (dialog-item-text item))
                                                       (newr-t (when (> (length new-t) 0)
                                                                 (read-from-string new-t))))
                                                  (when (numberp newr-t)
                                                    (setf (bits-per-parameter g) newr-t)))))
          (make-instance
           'static-text-dialog-item
           :dialog-item-text "Use Gray-coding:")
          (make-instance
           'check-box-dialog-item
           :dialog-item-text "" 
           :dialog-item-action #'(lambda (item)
                                   (setf (gray-coded g) (check-box-checked-p item)))
           :check-box-checked-p (gray-coded g)))))))


(defun done-fitness-function ()
  (window-close *ff-dialog*))

(defun display-environment ()
  (modal-dialog 
   (make-instance 'ga-info
     :view-subviews
     (list (make-instance 'static-text-dialog-item
             :dialog-item-text "Function")
           (make-instance 'static-text-dialog-item
             :dialog-item-text (if *current-function*
                                 (write-to-string (fitness-function *current-function*))
                                 "Not specified"))
           (make-instance 'static-text-dialog-item
             :dialog-item-text "Normalize fittness")
           (make-instance 'static-text-dialog-item
             :dialog-item-text (if *normalize-fitness-p* "yes" "no"))
           (make-instance 'static-text-dialog-item
             :dialog-item-text "Scale fittness")
           (make-instance 'static-text-dialog-item
             :dialog-item-text (if *scale-fitness-p* "yes" "no"))
           (make-instance 'static-text-dialog-item
             :dialog-item-text "Allow mutations")
           (make-instance 'static-text-dialog-item
             :dialog-item-text (if *mutations-p* "yes" "no"))
           (make-instance 'static-text-dialog-item
             :dialog-item-text "Mutation Probability")
           (make-instance 'static-text-dialog-item
             :dialog-item-text (write-to-string *mutation-probability*))
           (make-instance 'static-text-dialog-item
             :dialog-item-text "Crossover Probability")
           (make-instance 'static-text-dialog-item
             :dialog-item-text (write-to-string *crossover-probability*))
           (make-instance 'static-text-dialog-item
             :dialog-item-text "Population Size")
           (make-instance 'static-text-dialog-item
             :dialog-item-text (write-to-string *population-size*))
           (make-instance 'static-text-dialog-item
             :dialog-item-text "Nr. of Generations")
           (make-instance 'static-text-dialog-item
             :dialog-item-text (write-to-string *generations-to-evolve*))
           (make-instance 'static-text-dialog-item
             :dialog-item-text "Verbose")
           (make-instance 'static-text-dialog-item
             :dialog-item-text (if *verbose-mode* "yes" "no"))))))

;;; ==========================================================================
;;; GA DEMO MENU
;;; ==========================================================================

(defparameter *ga-demo-menu*
  (make-instance 'menu
    :menu-title "Demos"
    :menu-items
    (list (make-instance 'menu-item
            :menu-item-title "Demo 1"
            :menu-item-action #'(lambda ()
                                  (eval-enqueue 
                                   '(demo-1))))
#|          (make-instance 'menu-item
            :menu-item-title "Demo 2"
            :menu-item-action #'(lambda ()
                                  (eval-enqueue 
                                   '(demo-2))))
          (make-instance 'menu-item
            :menu-item-title "Demo 3"
            :menu-item-action #'(lambda ()
                                  (eval-enqueue 
                                   '(demo-3))))|#)))
#|
(defun demo-1 (&rest nulla)
  (declare (ignore nulla))
  (start-demo-1))
(defun demo-2 (&rest nulla)
  (declare (ignore nulla)))
(defun demo-3 (&rest nulla)
  (declare (ignore nulla)))
|#
                                                     
(defvar *ga-menubar* nil)

(defun set-ga-menubar ()
  (setq *ga-menubar*
        (list (find-menu "")
              *pail-tool-menu*
              *ga-file-menu*
              (find-menu "Edit")
              *ga-parameter-menu*
              *ga-main-menu*
              *ga-demo-menu*
              (find-menu "Windows")))
  (set-menubar *ga-menubar*))



;;; ==========================================================================
;;; 
;;; ==========================================================================

(defun start-evolving ()
  (close-all-anal-displ)
  (dialog-item-enable (view-named 'stop *ga-main-window*))
  (dialog-item-disable (view-named 'start *ga-main-window*))
  (dialog-item-disable (view-named 'analyze *ga-main-window*))
  (dialog-item-disable (view-named 'continue *ga-main-window*))
  (format *ga-output-window* "~%Evolving ~a generations~%" *generations-to-evolve*);)
  (unless *current-generation*
    (setf *current-generation* (make-instance 'population :size *population-size*)))
  (setf *running* t 
        *current-generation*
        (evolve *current-generation* :generations *generations-to-evolve*)
        *running* nil)
  (dialog-item-enable (view-named 'start *ga-main-window*))
  (dialog-item-enable (view-named 'analyze *ga-main-window*))
  (dialog-item-enable (view-named 'continue *ga-main-window*))
  (dialog-item-disable (view-named 'stop *ga-main-window*))
  (setf *proceed* t))



